/*
 * Decompiled with CFR 0.152.
 */
package thut.crafts.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.entity.IMultiplePassengerEntity;
import thut.api.entity.blockentity.BlockEntityBase;
import thut.api.entity.blockentity.BlockEntityInteractHandler;
import thut.api.maths.Vector3;
import thut.api.maths.vecmath.Vector3f;
import thut.core.common.network.EntityUpdate;
import thut.crafts.entity.CraftController;
import thut.crafts.entity.CraftInteractHandler;
import thut.crafts.entity.EventCraftConsumePower;

public class EntityCraft
extends BlockEntityBase
implements IMultiplePassengerEntity {
    public static final EntityType<EntityCraft> CRAFTTYPE = new BlockEntityBase.BlockEntityType<EntityCraft>(EntityCraft::new);
    static final DataParameter<IMultiplePassengerEntity.Seat>[] SEAT = new DataParameter[10];
    static final DataParameter<Integer> SEATCOUNT = EntityDataManager.func_187226_a(EntityCraft.class, (IDataSerializer)DataSerializers.field_187192_b);
    static final DataParameter<Integer> MAINSEATDW = EntityDataManager.func_187226_a(EntityCraft.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static boolean ENERGYUSE;
    public static int ENERGYCOST;
    public CraftController controller = new CraftController(this);
    int energy = 0;
    public UUID owner;
    EntitySize field_213325_aI;

    public EntityCraft(EntityType<EntityCraft> type, World par1World) {
        super(type, par1World);
        this.field_70158_ak = true;
        this.field_70172_ad = 0;
    }

    @Override
    public void accelerate() {
        float destX;
        float destY;
        if (this.isServerWorld() && !this.consumePower()) {
            this.toMoveZ = false;
            this.toMoveX = false;
            this.toMoveY = false;
        }
        this.toMoveX = this.controller.leftInputDown || this.controller.rightInputDown;
        this.toMoveZ = this.controller.backInputDown || this.controller.forwardInputDown;
        boolean bl = this.toMoveY = this.controller.upInputDown || this.controller.downInputDown;
        float f = this.toMoveY ? (this.controller.upInputDown ? 30.0f : -30.0f) : (destY = 0.0f);
        float f2 = this.toMoveX ? (this.controller.leftInputDown ? 30.0f : -30.0f) : (destX = 0.0f);
        float destZ = this.toMoveZ ? (this.controller.forwardInputDown ? 30.0f : -30.0f) : 0.0f;
        this.toMoveZ = false;
        this.toMoveX = false;
        this.toMoveY = false;
        if (destX == destY && destY == destZ && destZ == 0.0f) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.5, 0.5, 0.5));
            return;
        }
        IMultiplePassengerEntity.Seat seat = null;
        for (int i = 0; i < this.getSeatCount(); ++i) {
            if (this.getSeat(i).getEntityId().equals(IMultiplePassengerEntity.Seat.BLANK)) continue;
            seat = this.getSeat(i);
            break;
        }
        float f3 = (float)Math.sqrt(destX * destX + destZ * destZ);
        if (this.controller.forwardInputDown) {
            destX = MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f3;
            destZ = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f3;
        } else if (this.controller.backInputDown) {
            destX = -MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f3;
            destZ = -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f3;
        } else if (this.controller.leftInputDown) {
            destX = MathHelper.func_76134_b((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f3;
            destZ = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * f3;
        } else if (this.controller.rightInputDown) {
            destX = -MathHelper.func_76134_b((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f3;
            destZ = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * f3;
        }
        if (seat != null) {
            Vector3 rel = Vector3.getNewVector().set(this).addTo(seat.seat.x, seat.seat.y, seat.seat.z);
            BlockPos pos = rel.getPos();
            BlockState block = this.getFakeWorld().getBlock(pos);
            if (block != null && block.func_235901_b_((Property)StairsBlock.field_176309_a)) {
                Vector3 dest = Vector3.getNewVector().set(destX, destY, destZ);
                switch ((Direction)block.func_177229_b((Property)StairsBlock.field_176309_a)) {
                    case DOWN: {
                        break;
                    }
                    case EAST: {
                        dest = dest.rotateAboutAngles(0.0, -1.5707963267948966, Vector3.getNewVector(), Vector3.getNewVector());
                        break;
                    }
                    case NORTH: {
                        break;
                    }
                    case SOUTH: {
                        dest = dest.rotateAboutAngles(0.0, Math.PI, Vector3.getNewVector(), Vector3.getNewVector());
                        break;
                    }
                    case UP: {
                        break;
                    }
                    case WEST: {
                        dest = dest.rotateAboutAngles(0.0, 1.5707963267948966, Vector3.getNewVector(), Vector3.getNewVector());
                        break;
                    }
                }
                destX = (float)dest.x;
                destY = (float)dest.y;
                destZ = (float)dest.z;
            }
        }
        destX = (float)((double)destX + this.func_226277_ct_());
        destY = (float)((double)destY + this.func_226278_cu_());
        destZ = (float)((double)destZ + this.func_226281_cx_());
        Vector3d v = this.func_213322_ci();
        double vx = v.field_72450_a;
        double vy = v.field_72448_b;
        double vz = v.field_72449_c;
        if ((double)destY != this.func_226278_cu_()) {
            double dy;
            vy = dy = this.getSpeed(this.func_226278_cu_(), destY, vy, this.getSpeedUp(), this.getSpeedDown());
            this.toMoveY = true;
        } else {
            vy *= 0.5;
        }
        if ((double)destX != this.func_226277_ct_()) {
            double dx;
            vx = dx = this.getSpeed(this.func_226277_ct_(), destX, vx, this.getSpeedHoriz(), this.getSpeedHoriz());
            this.toMoveX = true;
        } else {
            vx *= 0.5;
        }
        if ((double)destZ != this.func_226281_cx_()) {
            double dz;
            vz = dz = this.getSpeed(this.func_226281_cx_(), destZ, vz, this.getSpeedHoriz(), this.getSpeedHoriz());
            this.toMoveZ = true;
        } else {
            vz *= 0.5;
        }
        this.func_213293_j(vx, vy, vz);
    }

    public void addSeat(Vector3f seat) {
        IMultiplePassengerEntity.Seat toSet = this.getSeat(this.getSeatCount());
        toSet.seat.set(seat);
        this.field_70180_af.func_187227_b(SEAT[this.getSeatCount()], (Object)toSet);
        this.setSeatCount(this.getSeatCount() + 1);
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < this.getSeatCount();
    }

    public boolean canRiderInteract() {
        return true;
    }

    @Override
    protected boolean checkAccelerationConditions() {
        return this.consumePower();
    }

    private boolean consumePower() {
        if (!ENERGYUSE) {
            return true;
        }
        boolean power = false;
        Vector3 bounds = Vector3.getNewVector().set(this.boundMax.func_177973_b((Vector3i)this.boundMin));
        double volume = bounds.x * bounds.y * bounds.z;
        float speed = 10.0f;
        double energyCost = (double)(Math.abs(10.0f) * (float)ENERGYCOST) * volume * 0.01;
        this.energy = (int)((double)this.energy - (energyCost = Math.max(energyCost, 1.0)));
        boolean bl = power = this.energy > 0;
        if (this.energy < 0) {
            this.energy = 0;
        }
        MinecraftForge.EVENT_BUS.post((Event)new EventCraftConsumePower(this, (long)energyCost));
        if (!power) {
            this.toMoveY = false;
        }
        return power;
    }

    @Override
    protected BlockEntityInteractHandler createInteractHandler() {
        return new CraftInteractHandler(this);
    }

    @Override
    public void doMotion() {
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getMainSeat() {
        return (Integer)this.field_70180_af.func_187225_a(MAINSEATDW);
    }

    @Override
    public Entity getPassenger(Vector3f seatl) {
        UUID id = null;
        for (int i = 0; i < this.getSeatCount(); ++i) {
            IMultiplePassengerEntity.Seat seat = this.getSeat(i);
            if (!seat.seat.equals(seatl)) continue;
            id = seat.getEntityId();
        }
        if (id != null) {
            for (Entity e : this.func_184188_bt()) {
                if (!e.func_110124_au().equals(id)) continue;
                return e;
            }
        }
        return null;
    }

    @Override
    public float getPitch() {
        return this.field_70125_A;
    }

    @Override
    public float getPrevPitch() {
        return this.field_70127_C;
    }

    @Override
    public float getPrevYaw() {
        return this.field_70126_B;
    }

    @Override
    public Vector3f getSeat(Entity passenger) {
        Vector3f ret = null;
        for (int i = 0; i < this.getSeatCount(); ++i) {
            IMultiplePassengerEntity.Seat seat = this.getSeat(i);
            if (!seat.getEntityId().equals(passenger.func_110124_au())) continue;
            return seat.seat;
        }
        return ret;
    }

    IMultiplePassengerEntity.Seat getSeat(int index) {
        return (IMultiplePassengerEntity.Seat)this.field_70180_af.func_187225_a(SEAT[index]);
    }

    int getSeatCount() {
        return (Integer)this.field_70180_af.func_187225_a(SEATCOUNT);
    }

    @Override
    public List<Vector3f> getSeats() {
        ArrayList ret = Lists.newArrayList();
        for (int i = 0; i < this.getSeatCount(); ++i) {
            IMultiplePassengerEntity.Seat seat = this.getSeat(i);
            ret.add(seat.seat);
        }
        return null;
    }

    public EntitySize func_213305_a(Pose pose) {
        if (this.field_213325_aI == null) {
            this.field_213325_aI = EntitySize.func_220311_c((float)(1 + this.getMax().func_177958_n() - this.getMin().func_177958_n()), (float)this.getMax().func_177956_o());
        }
        return this.field_213325_aI;
    }

    @Override
    public float getYaw() {
        return this.field_70177_z;
    }

    @Override
    protected void onGridAlign() {
        BlockPos pos = this.func_233580_cy_();
        double dx = this.func_226277_ct_();
        double dy = this.func_226278_cu_();
        double dz = this.func_226281_cx_();
        this.func_70107_b((double)pos.func_177958_n() + 0.5, Math.round(this.func_226278_cu_()), (double)pos.func_177952_p() + 0.5);
        dx -= this.func_226277_ct_();
        dy -= this.func_226278_cu_();
        dz -= this.func_226281_cx_();
        if (dx * dx + dy * dy + dz * dz > 0.0) {
            EntityUpdate.sendEntityUpdate(this);
        }
    }

    @Override
    protected void preColliderTick() {
        this.controller.doServerTick(this.getFakeWorld());
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.energy = nbt.func_74762_e("energy");
        if (nbt.func_74764_b("seats")) {
            ListNBT seatsList = nbt.func_150295_c("seats", 10);
            for (int i = 0; i < seatsList.size(); ++i) {
                CompoundNBT nbt1 = seatsList.func_150305_b(i);
                IMultiplePassengerEntity.Seat seat = IMultiplePassengerEntity.Seat.readFromNBT(nbt1);
                this.field_70180_af.func_187227_b(SEAT[i], (Object)seat);
            }
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MAINSEATDW, (Object)-1);
        for (int i = 0; i < 10; ++i) {
            this.field_70180_af.func_187214_a(SEAT[i], (Object)new IMultiplePassengerEntity.Seat(new Vector3f(), null));
        }
        this.field_70180_af.func_187214_a(SEATCOUNT, (Object)0);
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.getSeatCount(); ++i) {
                if (!this.getSeat(i).getEntityId().equals(passenger.func_110124_au())) continue;
                this.setSeatID(i, IMultiplePassengerEntity.Seat.BLANK);
                new DismountTicker(passenger, this, this.getSeat(i));
                break;
            }
        }
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public void setMainSeat(int seat) {
        this.field_70180_af.func_187227_b(MAINSEATDW, (Object)seat);
    }

    void setSeatCount(int count) {
        this.field_70180_af.func_187227_b(SEATCOUNT, (Object)count);
    }

    void setSeatID(int index, UUID id) {
        IMultiplePassengerEntity.Seat toSet = this.getSeat(index);
        UUID old = toSet.getEntityId();
        if (!old.equals(id)) {
            toSet = (IMultiplePassengerEntity.Seat)toSet.clone();
            toSet.setEntityId(id);
            this.field_70180_af.func_187227_b(SEAT[index], (Object)toSet);
        }
    }

    @Override
    public void setSize(EntitySize size) {
        this.field_213325_aI = size;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            if (passenger.func_225608_bj_()) {
                passenger.func_184210_p();
            }
            IMultiplePassengerEntity.MultiplePassengerManager.managePassenger(passenger, this);
            passenger.func_230245_c_(true);
            passenger.func_225503_b_(passenger.field_70143_R, 0.0f);
            passenger.field_70143_R = 0.0f;
            if (passenger instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)passenger).field_71135_a.field_184346_E = 0;
                ((ServerPlayerEntity)passenger).field_71135_a.field_147365_f = 0;
            }
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    @Override
    public void updateSeat(int index, UUID id) {
        IMultiplePassengerEntity.Seat seat = (IMultiplePassengerEntity.Seat)this.getSeat(index).clone();
        seat.setEntityId(id);
        this.field_70180_af.func_187227_b(SEAT[index], (Object)seat);
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("energy", this.energy);
        ListNBT seats = new ListNBT();
        for (int i = 0; i < this.getSeatCount(); ++i) {
            CompoundNBT tag1 = new CompoundNBT();
            this.getSeat(i).writeToNBT(tag1);
            seats.add((Object)tag1);
        }
        nbt.func_218657_a("seats", (INBT)seats);
    }

    static {
        for (int i = 0; i < SEAT.length; ++i) {
            EntityCraft.SEAT[i] = EntityDataManager.func_187226_a(EntityCraft.class, IMultiplePassengerEntity.SEATSERIALIZER);
        }
        ENERGYUSE = false;
        ENERGYCOST = 100;
    }

    public static class DismountTicker {
        final Entity dismounted;
        final Entity craft;
        final IMultiplePassengerEntity.Seat seat;

        public DismountTicker(Entity dismounted, Entity craft, IMultiplePassengerEntity.Seat seat) {
            this.dismounted = dismounted;
            this.craft = craft;
            this.seat = seat;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void tick(TickEvent.WorldTickEvent event) {
            if (event.world != this.craft.field_70170_p) {
                return;
            }
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            double x = this.craft.func_226277_ct_() + (double)this.seat.seat.x;
            double y = this.craft.func_226278_cu_() + (double)this.seat.seat.y;
            double z = this.craft.func_226281_cx_() + (double)this.seat.seat.z;
            if (this.dismounted instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)this.dismounted).field_71135_a.func_147364_a(x, y, z, this.dismounted.field_70177_z, this.dismounted.field_70125_A);
            } else {
                this.dismounted.func_70107_b(x, y, z);
            }
        }
    }
}

