/*
 * Decompiled with CFR 0.152.
 */
package thut.crafts.network;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import thut.core.common.network.Packet;
import thut.crafts.ThutCrafts;
import thut.crafts.entity.CraftController;
import thut.crafts.entity.EntityCraft;

public class PacketCraftControl
extends Packet {
    private static final short FORWARD = 1;
    private static final short BACK = 2;
    private static final short LEFT = 4;
    private static final short RIGHT = 8;
    private static final short UP = 16;
    private static final short DOWN = 32;
    private static final short RLEFT = 64;
    private static final short RRIGHT = 128;
    int entityId;
    short message;

    public static void sendControlPacket(Entity pokemob, CraftController controller) {
        PacketCraftControl packet = new PacketCraftControl();
        packet.entityId = pokemob.func_145782_y();
        if (controller.backInputDown) {
            packet.message = (short)(packet.message + 2);
        }
        if (controller.forwardInputDown) {
            packet.message = (short)(packet.message + 1);
        }
        if (controller.leftInputDown) {
            packet.message = (short)(packet.message + 4);
        }
        if (controller.rightInputDown) {
            packet.message = (short)(packet.message + 8);
        }
        if (controller.upInputDown) {
            packet.message = (short)(packet.message + 16);
        }
        if (controller.downInputDown) {
            packet.message = (short)(packet.message + 32);
        }
        if (controller.leftRotateDown) {
            packet.message = (short)(packet.message + 64);
        }
        if (controller.rightRotateDown) {
            packet.message = (short)(packet.message + 128);
        }
        ThutCrafts.packets.sendToServer(packet);
    }

    PacketCraftControl() {
        super(null);
    }

    public PacketCraftControl(PacketBuffer buffer) {
        super(buffer);
        this.entityId = buffer.readInt();
        this.message = buffer.readShort();
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            Entity mob = player.func_130014_f_().func_73045_a(this.entityId);
            if (mob != null && mob instanceof EntityCraft) {
                CraftController controller = ((EntityCraft)mob).controller;
                controller.forwardInputDown = (this.message & 1) > 0;
                controller.backInputDown = (this.message & 2) > 0;
                controller.leftInputDown = (this.message & 4) > 0;
                controller.rightInputDown = (this.message & 8) > 0;
                controller.upInputDown = (this.message & 0x10) > 0;
                controller.downInputDown = (this.message & 0x20) > 0;
                controller.leftRotateDown = (this.message & 0x40) > 0;
                controller.rightRotateDown = (this.message & 0x80) > 0;
            }
        });
        ctx.get().setPacketHandled(true);
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeShort((int)this.message);
    }
}

