/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.belt;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import gigaherz.toolbelt.ToolBelt;
import gigaherz.toolbelt.belt.ToolBeltInventory;
import gigaherz.toolbelt.shadow.common.ItemRegistered;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.IItemHandler;

@Optional.Interface(modid="Baubles", iface="baubles.api.IBauble")
public class ItemToolBelt
extends ItemRegistered
implements IBauble {
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEM_HANDLER;
    public static int[] xpCost;

    public ItemToolBelt(String name) {
        super(name);
        this.field_77777_bU = 1;
        this.func_77637_a(CreativeTabs.field_78040_i);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        playerIn.openGui((Object)ToolBelt.instance, 0, worldIn, hand.ordinal(), 0, 0);
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        playerIn.openGui((Object)ToolBelt.instance, 0, worldIn, hand.ordinal(), 0, 0);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        int size = ItemToolBelt.getSlotsCount(stack);
        tooltip.add(I18n.func_135052_a((String)"text.toolbelt.tooltip", (Object[])new Object[]{size - 2, size}));
    }

    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.BELT;
    }

    public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        return new ICapabilityProvider(){
            final ItemStack itemStack;
            {
                this.itemStack = stack;
            }

            public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == ITEM_HANDLER;
            }

            @Nullable
            public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                if (capability == ITEM_HANDLER) {
                    return (T)ItemToolBelt.getItems(stack);
                }
                return null;
            }
        };
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public static int getSlotsCount(ItemStack stack) {
        int size = 2;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            size = MathHelper.func_76125_a((int)nbt.func_74762_e("Size"), (int)2, (int)9);
        }
        return size;
    }

    public static void setSlotsCount(ItemStack stack, int newSize) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            nbt.func_74782_a("Items", (NBTBase)new NBTTagList());
        }
        nbt.func_74768_a("Size", newSize);
        stack.func_77982_d(nbt);
    }

    public static ToolBeltInventory getItems(ItemStack stack) {
        return new ToolBeltInventory(stack);
    }

    public static int getUpgradeXP(ItemStack stack) {
        int slots = ItemToolBelt.getSlotsCount(stack);
        if (slots >= 9) {
            return -1;
        }
        if (slots < 2) {
            return 1;
        }
        return xpCost[slots - 2];
    }

    @Nullable
    public static ItemStack upgrade(ItemStack stack) {
        int slots = ItemToolBelt.getSlotsCount(stack);
        if (slots >= 9) {
            return stack.func_77946_l();
        }
        stack = stack.func_77946_l();
        ItemToolBelt.setSlotsCount(stack, slots + 1);
        return stack;
    }

    @Nullable
    public ItemStack getStack(int upgradeLevel) {
        if (upgradeLevel < 0 || upgradeLevel >= 9) {
            return null;
        }
        ItemStack stack = new ItemStack((Item)this);
        ItemToolBelt.setSlotsCount(stack, upgradeLevel + 2);
        return stack;
    }

    public ItemStack of(int upgradeLevel) {
        if (upgradeLevel < 0 || upgradeLevel >= 9) {
            throw new IllegalArgumentException("upgradeLevel must be between 0 and 9, inclusive.");
        }
        ItemStack stack = new ItemStack((Item)this);
        ItemToolBelt.setSlotsCount(stack, upgradeLevel + 2);
        return stack;
    }

    static {
        xpCost = new int[]{3, 5, 8, 12, 15, 20, 30};
    }
}

