/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.belt;

import gigaherz.toolbelt.Config;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ToolBeltInventory
implements IItemHandlerModifiable {
    private final ItemStack itemStack;

    ToolBeltInventory(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    private NBTTagCompound getTag() {
        NBTTagCompound tag = this.itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            this.itemStack.func_77982_d(tag);
        }
        return tag;
    }

    public int getSlots() {
        return MathHelper.func_76125_a((int)this.getTag().func_74762_e("Size"), (int)2, (int)9);
    }

    @Nullable
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        NBTTagList tagList = this.getTag().func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            if (itemTags.func_74762_e("Slot") != slot) continue;
            return ItemStack.func_77949_a((NBTTagCompound)itemTags);
        }
        return null;
    }

    public void setStackInSlot(int slot, @Nullable ItemStack stack) {
        this.validateSlotIndex(slot);
        NBTTagCompound itemTag = null;
        if (stack != null) {
            itemTag = new NBTTagCompound();
            itemTag.func_74768_a("Slot", slot);
            stack.func_77955_b(itemTag);
        }
        NBTTagList tagList = this.getTag().func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound existing = tagList.func_150305_b(i);
            if (existing.func_74762_e("Slot") != slot) continue;
            if (stack != null) {
                tagList.func_150304_a(i, (NBTBase)itemTag);
            } else {
                tagList.func_74744_a(i);
            }
            return;
        }
        if (stack != null) {
            tagList.func_74742_a((NBTBase)itemTag);
        }
        this.getTag().func_74782_a("Items", (NBTBase)tagList);
    }

    @Nullable
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (!Config.isItemStackAllowed(stack)) {
            return stack;
        }
        if (stack == null || stack.field_77994_a == 0) {
            return null;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        int limit = this.getStackLimit(slot, stack);
        if (existing != null) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.field_77994_a;
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.field_77994_a > limit;
        if (!simulate) {
            if (existing == null) {
                existing = reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack;
            } else {
                existing.field_77994_a = existing.field_77994_a + (reachedLimit ? limit : stack.field_77994_a);
            }
            this.setStackInSlot(slot, existing);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.field_77994_a - limit)) : null;
    }

    @Nullable
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return null;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        if (existing == null) {
            return null;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.field_77994_a <= toExtract) {
            if (!simulate) {
                this.setStackInSlot(slot, null);
            }
            return existing;
        }
        if (!simulate) {
            this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.field_77994_a - toExtract)));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getStackLimit(int slot, ItemStack stack) {
        return stack.func_77976_d();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }
}

