/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.integration.anvil;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class BeltUpgradeRecipeWrapper
extends BlankRecipeWrapper {
    private final List<List<ItemStack>> inputs = Lists.newArrayList();
    private final ItemStack output;
    private int levelsCost;

    public BeltUpgradeRecipeWrapper(ItemStack leftInput, ItemStack rightInputs, ItemStack output, int levelsCost) {
        this.inputs.add(Collections.singletonList(leftInput));
        this.inputs.add(Collections.singletonList(rightInputs));
        this.output = output;
        this.levelsCost = levelsCost;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String text = I18n.func_135052_a((String)"container.repair.cost", (Object[])new Object[]{this.levelsCost});
        int mainColor = -8323296;
        if (!(this.levelsCost < 40 && this.levelsCost <= minecraft.field_71439_g.field_71068_ca || minecraft.field_71439_g.field_71075_bZ.field_75098_d)) {
            mainColor = -40864;
        }
        this.drawRepairCost(minecraft, text, mainColor, recipeWidth);
    }

    private void drawRepairCost(Minecraft minecraft, String text, int mainColor, int recipeWidth) {
        int shadowColor = 0xFF000000 | (mainColor & 0xFCFCFC) >> 2;
        int width = minecraft.field_71466_p.func_78256_a(text);
        int x = recipeWidth - 2 - width;
        int y = 27;
        if (minecraft.field_71466_p.func_82883_a()) {
            Gui.func_73734_a((int)(x - 2), (int)(y - 2), (int)(x + width + 2), (int)(y + 10), (int)-16777216);
            Gui.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + width + 1), (int)(y + 9), (int)-12895429);
        } else {
            minecraft.field_71466_p.func_78276_b(text, x + 1, y, shadowColor);
            minecraft.field_71466_p.func_78276_b(text, x, y + 1, shadowColor);
            minecraft.field_71466_p.func_78276_b(text, x + 1, y + 1, shadowColor);
        }
        minecraft.field_71466_p.func_78276_b(text, x, y, mainColor);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setOutput(ItemStack.class, (Object)this.output);
    }
}

