/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.client;

import com.google.common.collect.Lists;
import gigaherz.toolbelt.BeltFinder;
import gigaherz.toolbelt.Config;
import gigaherz.toolbelt.ToolBelt;
import gigaherz.toolbelt.belt.ItemToolBelt;
import gigaherz.toolbelt.belt.ToolBeltInventory;
import gigaherz.toolbelt.client.ClientProxy;
import gigaherz.toolbelt.network.SwapItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Mouse;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class GuiRadialMenu
extends GuiScreen {
    private final BeltFinder.BeltGetter getter;
    private ItemStack stackEquipped;
    private ToolBeltInventory inventory;
    private List<ItemStack> cachedStacks = null;
    private boolean closing;
    private boolean doneClosing;
    private double startAnimation;
    private int selectedItem = -1;
    private boolean keyCycleBeforeL = false;
    private boolean keyCycleBeforeR = false;
    private static final float PRECISION = 5.0f;

    GuiRadialMenu(BeltFinder.BeltGetter getter) {
        this.getter = getter;
        this.stackEquipped = getter.getBelt();
        this.inventory = this.stackEquipped.func_190916_E() > 0 ? ItemToolBelt.getItems(this.stackEquipped) : null;
        this.startAnimation = (double)Minecraft.func_71410_x().field_71441_e.func_82737_E() + (double)Minecraft.func_71410_x().func_184121_ak();
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiRadialMenu) {
            event.setCanceled(true);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.closing) {
            if (this.doneClosing || this.inventory == null) {
                Minecraft.func_71410_x().func_147108_a(null);
                ClientProxy.wipeOpen();
            }
            return;
        }
        ItemStack inHand = this.field_146297_k.field_71439_g.func_184614_ca();
        if (!Config.isItemStackAllowed(inHand)) {
            this.inventory = null;
        } else {
            ItemStack stack = this.getter.getBelt();
            if (stack.func_190916_E() <= 0) {
                this.inventory = null;
                this.stackEquipped = null;
            } else if (this.stackEquipped != stack) {
                this.stackEquipped = stack;
                this.inventory = ItemToolBelt.getItems(stack);
                this.cachedStacks = null;
            }
        }
        if (this.inventory == null) {
            Minecraft.func_71410_x().func_147108_a(null);
        } else if (!GameSettings.func_100015_a((KeyBinding)ClientProxy.keyOpenToolMenu)) {
            if (Config.releaseToSwap) {
                int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
                int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
                this.func_146286_b(x, y, -1);
            } else {
                this.animateClose();
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (this.closing) {
            return;
        }
        if (this.inventory == null) {
            return;
        }
        ItemStack inHand = this.field_146297_k.field_71439_g.func_184614_ca();
        if (!Config.isItemStackAllowed(inHand)) {
            return;
        }
        ArrayList items = Lists.newArrayList();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack inSlot = this.inventory.getStackInSlot(i);
            if (inSlot.func_190916_E() <= 0) continue;
            items.add(i);
        }
        boolean hasAddButton = false;
        int numItems = items.size();
        if (numItems < this.inventory.getSlots() && inHand.func_190916_E() > 0) {
            hasAddButton = true;
            ++numItems;
        }
        if (numItems <= 0) {
            return;
        }
        if (this.selectedItem >= 0) {
            int swapWith = hasAddButton ? (this.selectedItem == 0 ? -1 : (Integer)items.get(this.selectedItem - 1)) : (Integer)items.get(this.selectedItem);
            SwapItems.swapItem(swapWith, (EntityPlayer)this.field_146297_k.field_71439_g);
            ToolBelt.channel.sendToServer((IMessage)new SwapItems(swapWith));
        }
        this.animateClose();
    }

    private void animateClose() {
        this.closing = true;
        this.doneClosing = false;
        this.startAnimation = (double)Minecraft.func_71410_x().field_71441_e.func_82737_E() + (double)Minecraft.func_71410_x().func_184121_ak();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        double radius;
        double scaledY;
        double scaledX;
        double distance;
        float e;
        float s;
        int i;
        float openAnimation;
        ItemStack inHand;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.inventory == null) {
            return;
        }
        ArrayList items = this.cachedStacks;
        if (items == null) {
            items = Lists.newArrayList();
            for (int i2 = 0; i2 < this.inventory.getSlots(); ++i2) {
                ItemStack inSlot = this.inventory.getStackInSlot(i2);
                if (inSlot.func_190916_E() <= 0) continue;
                items.add(inSlot);
            }
            this.cachedStacks = items;
        }
        if (!Config.isItemStackAllowed(inHand = this.field_146297_k.field_71439_g.func_184614_ca())) {
            return;
        }
        boolean hasAddButton = false;
        int numItems = items.size();
        if (numItems < this.inventory.getSlots() && inHand.func_190916_E() > 0) {
            hasAddButton = true;
            ++numItems;
        }
        if (numItems <= 0) {
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"text.toolbelt.empty", (Object[])new Object[0]), this.field_146294_l / 2, (this.field_146295_m - this.field_146289_q.field_78288_b) / 2, -1);
            if (this.closing) {
                this.doneClosing = true;
            }
            return;
        }
        if (hasAddButton) {
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"text.toolbelt.insert", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 + 45 - this.field_146289_q.field_78288_b / 2, -1);
        }
        float OPEN_ANIMATION_LENGTH = 2.5f;
        float f = openAnimation = this.closing ? (float)(1.0 - ((double)((float)Minecraft.func_71410_x().field_71441_e.func_82737_E() + partialTicks) - this.startAnimation) / 2.5) : (float)(((double)((float)Minecraft.func_71410_x().field_71441_e.func_82737_E() + partialTicks) - this.startAnimation) / 2.5);
        if (this.closing && openAnimation <= 0.0f) {
            this.doneClosing = true;
        }
        float animProgress = MathHelper.func_76131_a((float)openAnimation, (float)0.0f, (float)1.0f);
        float radiusIn = Math.max(0.1f, 30.0f * animProgress);
        float radiusOut = radiusIn * 2.0f;
        float itemRadius = (radiusIn + radiusOut) * 0.5f;
        float animTop = (1.0f - animProgress) * (float)this.field_146295_m / 2.0f;
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m / 2;
        if (!this.closing) {
            if (GameSettings.func_100015_a((KeyBinding)ClientProxy.keyCycleToolMenuL)) {
                if (!this.keyCycleBeforeL) {
                    --this.selectedItem;
                    if (this.selectedItem < 0) {
                        this.selectedItem = numItems - 1;
                    }
                    this.setMousePosition((double)x + (double)itemRadius * Math.cos(-1.5707963267948966 - (double)(this.selectedItem * 2) * Math.PI / (double)numItems), (double)y + (double)itemRadius * Math.sin(-1.5707963267948966 + (double)(this.selectedItem * 2) * Math.PI / (double)numItems));
                }
                this.keyCycleBeforeL = true;
            } else {
                this.keyCycleBeforeL = false;
            }
            if (GameSettings.func_100015_a((KeyBinding)ClientProxy.keyCycleToolMenuR)) {
                if (!this.keyCycleBeforeR) {
                    if (this.selectedItem < 0) {
                        this.selectedItem = 0;
                    } else {
                        ++this.selectedItem;
                        if (this.selectedItem >= numItems) {
                            this.selectedItem = 0;
                        }
                    }
                    this.setMousePosition((double)x + (double)itemRadius * Math.cos(-1.5707963267948966 - (double)(this.selectedItem * 2) * Math.PI / (double)numItems), (double)y + (double)itemRadius * Math.sin(-1.5707963267948966 + (double)(this.selectedItem * 2) * Math.PI / (double)numItems));
                }
                this.keyCycleBeforeR = true;
            } else {
                this.keyCycleBeforeR = false;
            }
        }
        double a = Math.toDegrees(Math.atan2(mouseY - y, mouseX - x));
        double d = Math.sqrt(Math.pow(mouseX - x, 2.0) + Math.pow(mouseY - y, 2.0));
        float s0 = (-0.5f / (float)numItems + 0.25f) * 360.0f;
        if (a < (double)s0) {
            a += 360.0;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)animTop, (float)0.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        boolean hasMouseOver = false;
        ItemStack itemMouseOver = ItemStack.field_190927_a;
        if (!this.closing) {
            this.selectedItem = -1;
            for (i = 0; i < numItems; ++i) {
                s = (((float)i - 0.5f) / (float)numItems + 0.25f) * 360.0f;
                e = (((float)i + 0.5f) / (float)numItems + 0.25f) * 360.0f;
                if (!(a >= (double)s) || !(a < (double)e) || !(d >= (double)radiusIn) || !(d < (double)radiusOut) || !(a >= (double)s) || !(a < (double)e) || !(d >= (double)radiusIn) || !(d < (double)radiusOut) && !Config.clipMouseToCircle && !Config.allowClickOutsideBounds) continue;
                this.selectedItem = i;
                break;
            }
        }
        for (i = 0; i < numItems; ++i) {
            s = (((float)i - 0.5f) / (float)numItems + 0.25f) * 360.0f;
            e = (((float)i + 0.5f) / (float)numItems + 0.25f) * 360.0f;
            if (this.selectedItem == i) {
                this.drawPieArc(buffer, x, y, this.field_73735_i, radiusIn, radiusOut, s, e, 255, 255, 255, 64);
                if (i <= 0 && hasAddButton) continue;
                hasMouseOver = true;
                ItemStack inSlot = ItemStack.field_190927_a;
                if (hasAddButton) {
                    if (i > 0) {
                        inSlot = (ItemStack)items.get(i - 1);
                    }
                } else {
                    inSlot = (ItemStack)items.get(i);
                }
                itemMouseOver = inSlot;
                continue;
            }
            this.drawPieArc(buffer, x, y, this.field_73735_i, radiusIn, radiusOut, s, e, 0, 0, 0, 64);
        }
        if (Config.clipMouseToCircle && (distance = Math.sqrt((scaledX = (double)((float)Mouse.getX() - (float)this.field_146297_k.field_71443_c / 2.0f)) * scaledX + (scaledY = (double)((float)Mouse.getY() - (float)this.field_146297_k.field_71440_d / 2.0f)) * scaledY)) > (radius = 60.0 * (double)(this.field_146297_k.field_71443_c / this.field_146294_l))) {
            double fixedX = scaledX * radius / distance;
            double fixedY = scaledY * radius / distance;
            Mouse.setCursorPosition((int)((int)((double)(this.field_146297_k.field_71443_c / 2) + fixedX)), (int)((int)((double)(this.field_146297_k.field_71440_d / 2) + fixedY)));
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        if (hasMouseOver) {
            if (inHand.func_190916_E() > 0) {
                this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"text.toolbelt.swap", (Object[])new Object[0]), this.field_146294_l / 2, (this.field_146295_m - this.field_146289_q.field_78288_b) / 2, -1);
            } else {
                this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"text.toolbelt.extract", (Object[])new Object[0]), this.field_146294_l / 2, (this.field_146295_m - this.field_146289_q.field_78288_b) / 2, -1);
            }
        }
        RenderHelper.func_74520_c();
        for (i = 0; i < numItems; ++i) {
            float angle1 = ((float)i / (float)numItems + 0.25f) * 2.0f * (float)Math.PI;
            float posX = (float)(x - 8) + itemRadius * (float)Math.cos(angle1);
            float posY = (float)(y - 8) + itemRadius * (float)Math.sin(angle1);
            ItemStack inSlot = ItemStack.field_190927_a;
            if (hasAddButton) {
                if (i > 0) {
                    inSlot = (ItemStack)items.get(i - 1);
                }
            } else {
                inSlot = (ItemStack)items.get(i);
            }
            if (inSlot.func_190916_E() <= 0) continue;
            this.field_146296_j.func_180450_b(inSlot, (int)posX, (int)posY);
            this.field_146296_j.func_180453_a(this.field_146289_q, inSlot, (int)posX, (int)posY, "");
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
        if (itemMouseOver.func_190916_E() > 0) {
            this.func_146285_a(itemMouseOver, mouseX, mouseY);
        }
    }

    private void setMousePosition(double x, double y) {
        Mouse.setCursorPosition((int)((int)(x * (double)this.field_146297_k.field_71443_c / (double)this.field_146294_l)), (int)((int)(y * (double)this.field_146297_k.field_71440_d / (double)this.field_146295_m)));
    }

    private void drawPieArc(VertexBuffer buffer, float x, float y, float z, float radiusIn, float radiusOut, float startAngle, float endAngle, int r, int g, int b, int a) {
        float angle = endAngle - startAngle;
        int sections = Math.max(1, MathHelper.func_76123_f((float)(angle / 5.0f)));
        startAngle = (float)Math.toRadians(startAngle);
        endAngle = (float)Math.toRadians(endAngle);
        angle = endAngle - startAngle;
        for (int i = 0; i < sections; ++i) {
            float angle1 = startAngle + (float)i / (float)sections * angle;
            float angle2 = startAngle + (float)(i + 1) / (float)sections * angle;
            float pos1InX = x + radiusIn * (float)Math.cos(angle1);
            float pos1InY = y + radiusIn * (float)Math.sin(angle1);
            float pos1OutX = x + radiusOut * (float)Math.cos(angle1);
            float pos1OutY = y + radiusOut * (float)Math.sin(angle1);
            float pos2OutX = x + radiusOut * (float)Math.cos(angle2);
            float pos2OutY = y + radiusOut * (float)Math.sin(angle2);
            float pos2InX = x + radiusIn * (float)Math.cos(angle2);
            float pos2InY = y + radiusIn * (float)Math.sin(angle2);
            buffer.func_181662_b((double)pos1OutX, (double)pos1OutY, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)pos1InX, (double)pos1InY, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)pos2InX, (double)pos2InY, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)pos2OutX, (double)pos2OutY, (double)z).func_181669_b(r, g, b, a).func_181675_d();
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

