/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import gigaherz.toolbelt.ToolBelt;
import gigaherz.toolbelt.belt.ItemToolBelt;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class Config {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    private static final Set<ItemStack> blackList;
    private static final Set<ItemStack> whiteList;
    public static boolean showBeltOnPlayers;
    public static double beltItemScale;
    public static boolean releaseToSwap;
    public static boolean clipMouseToCircle;
    public static boolean allowClickOutsideBounds;
    public static boolean displayEmptySlots;
    public static boolean disableAnvilUpgrading;
    private static final Pattern itemRegex;

    public static void refreshClient() {
        showBeltOnPlayers = (Boolean)Config.CLIENT.showBeltOnPlayers.get();
        beltItemScale = (Double)Config.CLIENT.beltItemScale.get();
        releaseToSwap = (Boolean)Config.CLIENT.releaseToSwap.get();
        clipMouseToCircle = (Boolean)Config.CLIENT.clipMouseToCircle.get();
        allowClickOutsideBounds = (Boolean)Config.CLIENT.allowClickOutsideBounds.get();
        displayEmptySlots = (Boolean)Config.CLIENT.displayEmptySlots.get();
    }

    public static void refreshServer() {
        disableAnvilUpgrading = (Boolean)Config.SERVER.disableAnvilUpgrading.get();
        ((List)Config.SERVER.blacklist.get()).stream().map(Config::parseItemStack).forEach(blackList::add);
        ((List)Config.SERVER.whitelist.get()).stream().map(Config::parseItemStack).forEach(whiteList::add);
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("toolbelt".equals(event.getModID())) {
            Config.refreshClient();
            Config.refreshServer();
        }
    }

    private static ItemStack parseItemStack(String itemString) {
        Matcher matcher = itemRegex.matcher(itemString);
        if (!matcher.matches()) {
            ToolBelt.logger.warn("Could not parse item " + itemString);
            return ItemStack.field_190927_a;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(matcher.group("item")));
        if (item == null) {
            ToolBelt.logger.warn("Could not parse item " + itemString);
            return ItemStack.field_190927_a;
        }
        return new ItemStack((IItemProvider)item, 1);
    }

    public static boolean isItemStackAllowed(ItemStack stack) {
        if (stack.func_190916_E() <= 0) {
            return true;
        }
        if (whiteList.stream().anyMatch(s -> ItemStack.func_179545_c((ItemStack)s, (ItemStack)stack))) {
            return true;
        }
        if (blackList.stream().anyMatch(s -> ItemStack.func_179545_c((ItemStack)s, (ItemStack)stack))) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemToolBelt) {
            return false;
        }
        return stack.func_77976_d() == 1;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        blackList = Sets.newHashSet();
        whiteList = Sets.newHashSet();
        showBeltOnPlayers = true;
        beltItemScale = 0.5;
        releaseToSwap = false;
        clipMouseToCircle = true;
        allowClickOutsideBounds = true;
        displayEmptySlots = true;
        disableAnvilUpgrading = false;
        itemRegex = Pattern.compile("^(?<item>([a-zA-Z-0-9_]+:)?[a-zA-Z-0-9_]+)(?:@((?<meta>[0-9]+)|(?<any>any)))?$");
    }

    public static class ClientConfig {
        public ForgeConfigSpec.BooleanValue showBeltOnPlayers;
        public ForgeConfigSpec.DoubleValue beltItemScale;
        public ForgeConfigSpec.BooleanValue releaseToSwap;
        public ForgeConfigSpec.BooleanValue clipMouseToCircle;
        public ForgeConfigSpec.BooleanValue allowClickOutsideBounds;
        public ForgeConfigSpec.BooleanValue displayEmptySlots;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Options for customizing the display of tools on the player").push("display");
            this.showBeltOnPlayers = builder.comment("If set to FALSE, the belts and tools will NOT draw on players.").translation("text.toolbelt.config.show_belt_on_players").define("showBeltOnPlayers", true);
            this.beltItemScale = builder.comment("Changes the scale of items on the belt.").translation("text.toolbelt.config.belt_item_scale").defineInRange("beltItemScale", 0.5, 0.1, 2.0);
            builder.pop();
            builder.comment("Options for customizing the display of tools on the player").push("display");
            this.releaseToSwap = builder.comment("If set to TRUE, releasing the menu key (R) will activate the swap. Requires a click otherwise (default).").translation("text.toolbelt.config.release_to_swap").define("releaseToSwap", false);
            this.clipMouseToCircle = builder.comment("If set to TRUE, the radial menu will try to prevent the mouse from leaving the outer circle.").translation("text.toolbelt.config.clip_mouse_to_circle").define("clipMouseToCircle", false);
            this.allowClickOutsideBounds = builder.comment("If set to TRUE, the radial menu will allow clicking outside the outer circle to activate the items.").translation("text.toolbelt.config.click_outside_bounds").define("allowClickOutsideBounds", false);
            this.displayEmptySlots = builder.comment("If set to TRUE, the radial menu will always display all the slots, even when empty, and will allow choosing which empty slot to insert into.").translation("text.toolbelt.config.display_empty_slots").define("displayEmptySlots", false);
            builder.pop();
        }
    }

    public static class ServerConfig {
        public ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;
        public ForgeConfigSpec.BooleanValue disableAnvilUpgrading;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.whitelist = builder.comment("List of items to force-allow placing in the belt. Takes precedence over blacklist.").translation("text.toolbelt.config.whitelist").defineList("whitelist", (List)Lists.newArrayList(), o -> o instanceof String);
            this.blacklist = builder.comment("List of items to disallow from placing in the belt. (whitelist takes precedence)").translation("text.toolbelt.config.blacklist").defineList("whitelist", (List)Lists.newArrayList(), o -> o instanceof String);
            this.disableAnvilUpgrading = builder.comment("If set to TRUE, the internal anvil upgrade will not work, and alternative methods for upgrades will have to be provided externally.").translation("text.toolbelt.config.disable_anvil_update").define("disableAnvilUpgrading", false);
            builder.pop();
        }
    }
}

