/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt;

import gigaherz.toolbelt.Config;
import gigaherz.toolbelt.ISideProxy;
import gigaherz.toolbelt.belt.ItemToolBelt;
import gigaherz.toolbelt.client.ClientProxy;
import gigaherz.toolbelt.common.GuiHandler;
import gigaherz.toolbelt.network.BeltContentsChange;
import gigaherz.toolbelt.network.ContainerSlotsHack;
import gigaherz.toolbelt.network.OpenBeltSlotInventory;
import gigaherz.toolbelt.network.SwapItems;
import gigaherz.toolbelt.network.SyncBeltSlotContents;
import gigaherz.toolbelt.server.ServerProxy;
import gigaherz.toolbelt.slot.ExtensionSlotBelt;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="toolbelt")
public class ToolBelt {
    public static final String MODID = "toolbelt";
    @ObjectHolder(value="toolbelt:belt")
    public static Item belt;
    @ObjectHolder(value="toolbelt:pouch")
    public static Item pouch;
    public static ToolBelt instance;
    public static final ISideProxy proxy;
    public static final Logger logger;
    public static final String CHANNEL = "toolbelt";
    private static final String PROTOCOL_VERSION = "1.0";
    public static SimpleChannel channel;

    public ToolBelt() {
        instance = this;
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addGenericListener(Item.class, this::registerItems);
        modEventBus.addListener(this::preInit);
        modEventBus.addListener(this::clientInit);
        modEventBus.addListener(this::modConfig);
        MinecraftForge.EVENT_BUS.addListener(this::anvilChange);
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, Config.SERVER_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_SPEC);
        modLoadingContext.registerExtensionPoint(ExtensionPoint.GUIFACTORY, () -> GuiHandler.Client::getClientGuiElement);
    }

    public void modConfig(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (!"toolbelt".equals(config.getModId())) {
            return;
        }
        if (config.getSpec() == Config.CLIENT_SPEC) {
            Config.refreshClient();
        } else if (config.getSpec() == Config.SERVER_SPEC) {
            Config.refreshServer();
        }
    }

    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ItemToolBelt(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i)).setRegistryName("belt"), (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78040_i)).setRegistryName("pouch")});
    }

    public void preInit(FMLCommonSetupEvent event) {
        int messageNumber = 0;
        channel.registerMessage(messageNumber++, SwapItems.class, SwapItems::encode, SwapItems::decode, SwapItems::onMessage);
        channel.registerMessage(messageNumber++, BeltContentsChange.class, BeltContentsChange::encode, BeltContentsChange::decode, BeltContentsChange::onMessage);
        channel.registerMessage(messageNumber++, OpenBeltSlotInventory.class, OpenBeltSlotInventory::encode, OpenBeltSlotInventory::decode, OpenBeltSlotInventory::onMessage);
        channel.registerMessage(messageNumber++, ContainerSlotsHack.class, ContainerSlotsHack::encode, ContainerSlotsHack::decode, ContainerSlotsHack::onMessage);
        channel.registerMessage(messageNumber++, SyncBeltSlotContents.class, SyncBeltSlotContents::encode, SyncBeltSlotContents::decode, SyncBeltSlotContents::onMessage);
        logger.debug("Final message number: " + messageNumber);
        ExtensionSlotBelt.register();
    }

    public void clientInit(FMLLoadCompleteEvent event) {
        proxy.init();
    }

    public void anvilChange(AnvilUpdateEvent ev) {
        if (Config.disableAnvilUpgrading) {
            return;
        }
        ItemStack left = ev.getLeft();
        ItemStack right = ev.getRight();
        if (left.func_190916_E() <= 0 || left.func_77973_b() != belt) {
            return;
        }
        if (right.func_190916_E() <= 0 || right.func_77973_b() != pouch) {
            return;
        }
        int cost = ItemToolBelt.getUpgradeXP(left);
        if (cost < 0) {
            ev.setCanceled(true);
            return;
        }
        ev.setCost(cost);
        ev.setMaterialCost(1);
        ev.setOutput(ItemToolBelt.upgrade(left));
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation("toolbelt", path);
    }

    static {
        proxy = (ISideProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());
        logger = LogManager.getLogger((String)"toolbelt");
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("toolbelt", "toolbelt")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }
}

