/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.belt;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import gigaherz.toolbelt.belt.ToolBeltInventory;
import gigaherz.toolbelt.common.GuiHandler;
import gigaherz.toolbelt.customslots.ExtensionSlotItemHandler;
import gigaherz.toolbelt.customslots.IExtensionContainer;
import gigaherz.toolbelt.customslots.IExtensionSlot;
import gigaherz.toolbelt.customslots.IExtensionSlotItem;
import gigaherz.toolbelt.customslots.example.RpgEquipment;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class ItemToolBelt
extends Item
implements IExtensionSlotItem {
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEM_HANDLER;
    @CapabilityInject(value=IExtensionSlotItem.class)
    public static Capability<IExtensionSlotItem> EXTENSION_SLOT_ITEM;
    public static final ImmutableSet<ResourceLocation> BELT_SLOT_LIST;
    public static int[] xpCost;

    public ItemToolBelt(Item.Properties properties) {
        super(properties);
    }

    private EnumActionResult openBeltGui(EntityPlayer player, ItemStack stack, World world) {
        int slot = player.field_71071_by.func_184429_b(stack);
        if (slot == -1) {
            return EnumActionResult.FAIL;
        }
        if (!world.field_72995_K && player instanceof EntityPlayerMP) {
            GuiHandler.openBeltGui((EntityPlayerMP)player, slot);
        }
        return EnumActionResult.SUCCESS;
    }

    public EnumActionResult func_195939_a(ItemUseContext context) {
        EntityPlayer player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        World world = context.func_195991_k();
        return this.openBeltGui(player, stack, world);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        return new ActionResult(this.openBeltGui(player, stack, world), (Object)stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int size = ItemToolBelt.getSlotsCount(stack);
        tooltip.add((ITextComponent)new TextComponentTranslation("text.toolbelt.tooltip", new Object[]{size - 2, size}));
    }

    @Override
    @Nonnull
    public ImmutableSet<ResourceLocation> getAcceptableSlots(@Nonnull ItemStack stack) {
        return BELT_SLOT_LIST;
    }

    @Override
    public void onWornTick(ItemStack itemstack, IExtensionSlot slot) {
        this.tickAllSlots(itemstack, slot.getContainer().getOwner());
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof EntityLivingBase) {
            this.tickAllSlots(stack, (EntityLivingBase)entityIn);
        }
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        return new ICapabilityProvider(){
            final ToolBeltInventory itemHandler;
            final LazyOptional<IItemHandler> itemHandlerInstance;
            final LazyOptional<IExtensionSlotItem> extensionSlotInstance;
            {
                this.itemHandler = new ToolBeltInventory(stack);
                this.itemHandlerInstance = LazyOptional.of(() -> this.itemHandler);
                this.extensionSlotInstance = LazyOptional.of(() -> ItemToolBelt.this);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable EnumFacing side) {
                if (cap == ITEM_HANDLER) {
                    return this.itemHandlerInstance;
                }
                if (cap == EXTENSION_SLOT_ITEM) {
                    return this.extensionSlotInstance;
                }
                return LazyOptional.empty();
            }
        };
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public static int getSlotsCount(ItemStack stack) {
        int size = 2;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            size = MathHelper.func_76125_a((int)nbt.func_74762_e("Size"), (int)2, (int)9);
        }
        return size;
    }

    public static void setSlotsCount(ItemStack stack, int newSize) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            nbt.func_74782_a("Items", (INBTBase)new NBTTagList());
        }
        nbt.func_74768_a("Size", newSize);
        stack.func_77982_d(nbt);
    }

    public static int getUpgradeXP(ItemStack stack) {
        int slots = ItemToolBelt.getSlotsCount(stack);
        if (slots >= 9) {
            return -1;
        }
        if (slots < 2) {
            return 1;
        }
        return xpCost[slots - 2];
    }

    public static ItemStack upgrade(ItemStack stack) {
        int slots = ItemToolBelt.getSlotsCount(stack);
        if (slots >= 9) {
            return stack.func_77946_l();
        }
        stack = stack.func_77946_l();
        ItemToolBelt.setSlotsCount(stack, slots + 1);
        return stack;
    }

    public ItemStack of(int upgradeLevel) {
        if (upgradeLevel < 0 || upgradeLevel >= 9) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack((IItemProvider)this);
        ItemToolBelt.setSlotsCount(stack, upgradeLevel + 2);
        return stack;
    }

    private void tickAllSlots(ItemStack source, EntityLivingBase player) {
        BeltExtensionContainer container = new BeltExtensionContainer(source, player);
        for (IExtensionSlot slot : container.getSlots()) {
            ((ExtensionSlotItemHandler)slot).onWornTick();
        }
    }

    static {
        BELT_SLOT_LIST = ImmutableSet.of((Object)RpgEquipment.BELT);
        xpCost = new int[]{3, 5, 8, 12, 15, 20, 30};
    }

    public static class BeltExtensionContainer
    implements IExtensionContainer {
        private static final ResourceLocation SLOT_TYPE = new ResourceLocation("toolbelt", "pocket");
        private final ToolBeltInventory inventory;
        private final EntityLivingBase owner;
        private final ImmutableList<IExtensionSlot> slots;

        public BeltExtensionContainer(ItemStack source, EntityLivingBase owner) {
            this.inventory = (ToolBeltInventory)source.getCapability(ITEM_HANDLER, null).orElseThrow(() -> new RuntimeException("No inventory!"));
            this.owner = owner;
            Object[] slots = new ExtensionSlotItemHandler[this.inventory.getSlots()];
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                slots[i] = new ExtensionSlotItemHandler(this, SLOT_TYPE, this.inventory, i){

                    @Override
                    public boolean canEquip(@Nonnull ItemStack stack) {
                        return inventory.canInsertItem(this.slot, stack);
                    }
                };
            }
            this.slots = ImmutableList.copyOf((Object[])slots);
        }

        @Override
        @Nonnull
        public EntityLivingBase getOwner() {
            return this.owner;
        }

        @Override
        @Nonnull
        public ImmutableList<IExtensionSlot> getSlots() {
            return this.slots;
        }

        @Override
        public void onContentsChanged(IExtensionSlot slot) {
        }
    }
}

