/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.client;

import com.google.common.collect.Lists;
import gigaherz.toolbelt.BeltFinder;
import gigaherz.toolbelt.Config;
import gigaherz.toolbelt.ToolBelt;
import gigaherz.toolbelt.client.ClientProxy;
import gigaherz.toolbelt.client.radial.GenericRadialMenu;
import gigaherz.toolbelt.client.radial.IRadialMenuHost;
import gigaherz.toolbelt.client.radial.ItemStackRadialMenuItem;
import gigaherz.toolbelt.client.radial.RadialMenuItem;
import gigaherz.toolbelt.client.radial.TextRadialMenuItem;
import gigaherz.toolbelt.network.SwapItems;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GuiRadialMenu
extends GuiScreen {
    private final BeltFinder.BeltGetter getter;
    private ItemStack stackEquipped;
    private IItemHandler inventory;
    private boolean keyCycleBeforeL = false;
    private boolean keyCycleBeforeR = false;
    private boolean needsRecheckStacks = true;
    private final List<ItemStackRadialMenuItem> cachedMenuItems = Lists.newArrayList();
    private final TextRadialMenuItem insertMenuItem;
    private final GenericRadialMenu menu;

    GuiRadialMenu(BeltFinder.BeltGetter getter) {
        this.getter = getter;
        this.stackEquipped = getter.getBelt();
        this.inventory = this.stackEquipped.func_190916_E() > 0 ? (IItemHandler)this.stackEquipped.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(null) : null;
        this.menu = new GenericRadialMenu(new IRadialMenuHost(){

            @Override
            public GuiScreen getScreen() {
                return GuiRadialMenu.this;
            }

            @Override
            public FontRenderer getFontRenderer() {
                return GuiRadialMenu.this.field_146289_q;
            }

            @Override
            public ItemRenderer getItemRenderer() {
                return GuiRadialMenu.this.field_146296_j;
            }
        }){

            @Override
            public void onClickOutside() {
                this.close();
            }
        };
        this.insertMenuItem = new TextRadialMenuItem(this.menu, (ITextComponent)new TextComponentTranslation("text.toolbelt.insert", new Object[0])){

            @Override
            public boolean onClick() {
                return GuiRadialMenu.this.trySwap(-1, ItemStack.field_190927_a);
            }
        };
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiRadialMenu) {
            event.setCanceled(true);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.menu.tick();
        if (this.menu.isClosed()) {
            Minecraft.func_71410_x().func_147108_a(null);
            ClientProxy.wipeOpen();
        }
        if (!this.menu.isReady() || this.inventory == null) {
            return;
        }
        ItemStack inHand = this.field_146297_k.field_71439_g.func_184614_ca();
        if (!Config.isItemStackAllowed(inHand)) {
            this.inventory = null;
        } else {
            ItemStack stack = this.getter.getBelt();
            if (stack.func_190916_E() <= 0) {
                this.inventory = null;
                this.stackEquipped = null;
            } else if (this.stackEquipped != stack) {
                this.stackEquipped = stack;
                this.inventory = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(() -> new RuntimeException("No inventory?"));
                this.needsRecheckStacks = true;
            }
        }
        if (this.inventory == null) {
            Minecraft.func_71410_x().func_147108_a(null);
        } else if (!InputMappings.func_197956_a((int)ClientProxy.keyOpenToolMenu.getKey().func_197937_c())) {
            if (Config.releaseToSwap) {
                this.processClick(false);
            } else {
                this.menu.close();
            }
        }
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.processClick(true);
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    protected void processClick(boolean triggeredByMouse) {
        this.menu.clickItem();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.inventory == null) {
            return;
        }
        ItemStack inHand = this.field_146297_k.field_71439_g.func_184614_ca();
        if (!Config.isItemStackAllowed(inHand)) {
            return;
        }
        if (this.needsRecheckStacks) {
            this.cachedMenuItems.clear();
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack inSlot = this.inventory.getStackInSlot(i);
                ItemStackRadialMenuItem item = new ItemStackRadialMenuItem(this.menu, i, inSlot, (ITextComponent)new TextComponentTranslation("text.toolbelt.empty", new Object[0])){

                    @Override
                    public boolean onClick() {
                        return GuiRadialMenu.this.trySwap(this.getSlot(), this.getStack());
                    }
                };
                item.setVisible(inSlot.func_190916_E() > 0 || Config.displayEmptySlots);
                if (inHand.func_190916_E() > 0) {
                    if (inSlot.func_190916_E() > 0) {
                        item.setCentralText((ITextComponent)new TextComponentTranslation("text.toolbelt.swap", new Object[0]));
                    } else {
                        item.setCentralText((ITextComponent)new TextComponentTranslation("text.toolbelt.insert", new Object[0]));
                    }
                } else if (inSlot.func_190916_E() > 0) {
                    item.setCentralText((ITextComponent)new TextComponentTranslation("text.toolbelt.extract", new Object[0]));
                } else {
                    item.setCentralText((ITextComponent)new TextComponentTranslation("text.toolbelt.empty", new Object[0]));
                }
                this.cachedMenuItems.add(item);
            }
            this.menu.clear();
            this.menu.addAll(this.cachedMenuItems);
            this.menu.add(this.insertMenuItem);
            this.needsRecheckStacks = false;
        }
        boolean hasAddButton = false;
        if (!Config.displayEmptySlots && !this.cachedMenuItems.stream().allMatch(RadialMenuItem::isVisible) && inHand.func_190916_E() > 0) {
            hasAddButton = true;
        }
        this.insertMenuItem.setVisible(hasAddButton);
        if (this.cachedMenuItems.stream().noneMatch(RadialMenuItem::isVisible)) {
            this.menu.setCentralText((ITextComponent)new TextComponentTranslation("text.toolbelt.empty", new Object[0]));
        } else {
            this.menu.setCentralText(null);
        }
        this.checkCycleKeybinds();
        this.menu.draw(partialTicks, mouseX, mouseY);
    }

    private boolean trySwap(int slotNumber, ItemStack itemMouseOver) {
        ItemStack inHand = this.field_146297_k.field_71439_g.func_184614_ca();
        if (!Config.isItemStackAllowed(inHand)) {
            return false;
        }
        if (inHand.func_190916_E() > 0 || itemMouseOver.func_190916_E() > 0) {
            SwapItems.swapItem(slotNumber, (EntityPlayer)this.field_146297_k.field_71439_g);
            ToolBelt.channel.sendToServer((Object)new SwapItems(slotNumber));
        }
        this.menu.close();
        return true;
    }

    private void checkCycleKeybinds() {
    }

    public boolean func_73868_f() {
        return false;
    }
}

