/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.client.radial;

import com.google.common.collect.Lists;
import gigaherz.toolbelt.Config;
import gigaherz.toolbelt.client.radial.DrawingContext;
import gigaherz.toolbelt.client.radial.IRadialMenuHost;
import gigaherz.toolbelt.client.radial.RadialMenuItem;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.util.TriConsumer;
import org.lwjgl.glfw.GLFW;

public class GenericRadialMenu {
    public static final float OPEN_ANIMATION_LENGTH = 2.5f;
    public final IRadialMenuHost host;
    private final List<RadialMenuItem> items = Lists.newArrayList();
    private final List<RadialMenuItem> visibleItems = Lists.newArrayList();
    public Vector4f backgroundColor = new Vector4f(0.0f, 0.0f, 0.0f, 0.25f);
    public Vector4f backgroundColorHover = new Vector4f(1.0f, 1.0f, 1.0f, 0.25f);
    private State state = State.INITIALIZING;
    public double startAnimation;
    public float animProgress;
    public float radiusIn;
    public float radiusOut;
    public float itemRadius;
    public float animTop;
    private ITextComponent centralText;
    private static final float PRECISION = 0.0069444445f;
    private static final double TWO_PI = Math.PI * 2;

    public GenericRadialMenu(IRadialMenuHost host) {
        this.host = host;
    }

    public void setCentralText(@Nullable ITextComponent centralText) {
        this.centralText = centralText;
    }

    public ITextComponent getCentralText() {
        return this.centralText;
    }

    public int getHovered() {
        for (int i = 0; i < this.visibleItems.size(); ++i) {
            if (!this.visibleItems.get(i).isHovered()) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public RadialMenuItem getHoveredItem() {
        for (RadialMenuItem item : this.visibleItems) {
            if (!item.isHovered()) continue;
            return item;
        }
        return null;
    }

    public void setHovered(int which) {
        for (int i = 0; i < this.visibleItems.size(); ++i) {
            this.visibleItems.get(i).setHovered(i == which);
        }
    }

    public int getVisibleItemCount() {
        return this.visibleItems.size();
    }

    public void clickItem() {
        switch (this.state) {
            case NORMAL: {
                RadialMenuItem item = this.getHoveredItem();
                if (item == null) break;
                item.onClick();
                return;
            }
        }
        this.onClickOutside();
    }

    public void onClickOutside() {
    }

    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    public boolean isReady() {
        return this.state == State.NORMAL;
    }

    public void visibilityChanged(RadialMenuItem item) {
        this.visibleItems.clear();
        for (RadialMenuItem radialMenuItem : this.items) {
            if (!radialMenuItem.isVisible()) continue;
            this.visibleItems.add(radialMenuItem);
        }
    }

    public void add(RadialMenuItem item) {
        this.items.add(item);
        if (item.isVisible()) {
            this.visibleItems.add(item);
        }
    }

    public void addAll(Collection<? extends RadialMenuItem> cachedMenuItems) {
        this.items.addAll(cachedMenuItems);
        for (RadialMenuItem radialMenuItem : cachedMenuItems) {
            if (!radialMenuItem.isVisible()) continue;
            this.visibleItems.add(radialMenuItem);
        }
    }

    public void clear() {
        this.items.clear();
        this.visibleItems.clear();
    }

    public void close() {
        GuiScreen owner = this.host.getScreen();
        this.state = State.CLOSING;
        this.startAnimation = (double)owner.field_146297_k.field_71441_e.func_82737_E() + (double)owner.field_146297_k.func_184121_ak();
        this.animProgress = 1.0f;
        this.setHovered(-1);
    }

    public void tick() {
        GuiScreen owner = this.host.getScreen();
        if (this.state == State.INITIALIZING) {
            this.startAnimation = (double)owner.field_146297_k.field_71441_e.func_82737_E() + (double)owner.field_146297_k.func_184121_ak();
            this.state = State.OPENING;
            this.animProgress = 0.0f;
        }
    }

    public void draw(float partialTicks, int mouseX, int mouseY) {
        this.updateAnimationState(partialTicks);
        if (this.isClosed()) {
            return;
        }
        if (this.isReady()) {
            this.processMouse(mouseX, mouseY);
        }
        GuiScreen owner = this.host.getScreen();
        FontRenderer fontRenderer = this.host.getFontRenderer();
        ItemRenderer itemRenderer = this.host.getItemRenderer();
        boolean animated = this.state == State.OPENING || this.state == State.CLOSING;
        this.radiusIn = animated ? Math.max(0.1f, 30.0f * this.animProgress) : 30.0f;
        this.radiusOut = this.radiusIn * 2.0f;
        this.itemRadius = (this.radiusIn + this.radiusOut) * 0.5f;
        this.animTop = animated ? (1.0f - this.animProgress) * (float)owner.field_146295_m / 2.0f : 0.0f;
        int x = owner.field_146294_l / 2;
        int y = owner.field_146295_m / 2;
        float z = 0.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)this.animTop, (float)0.0f);
        this.drawBackground(x, y, z, this.radiusIn, this.radiusOut);
        GlStateManager.func_179121_F();
        if (this.isReady()) {
            this.drawItems(x, y, z, owner.field_146294_l, owner.field_146295_m, fontRenderer, itemRenderer);
            ITextComponent currentCentralText = this.centralText;
            for (int i = 0; i < this.visibleItems.size(); ++i) {
                RadialMenuItem item = this.visibleItems.get(i);
                if (!item.isHovered()) continue;
                if (item.getCentralText() == null) break;
                currentCentralText = item.getCentralText();
                break;
            }
            if (currentCentralText != null) {
                String text = currentCentralText.func_150254_d();
                fontRenderer.func_175063_a(text, (float)(owner.field_146294_l - fontRenderer.func_78256_a(text)) / 2.0f, (float)(owner.field_146295_m - fontRenderer.field_78288_b) / 2.0f, -1);
            }
            this.drawTooltips(mouseX, mouseY);
        }
    }

    private void updateAnimationState(float partialTicks) {
        float openAnimation = 0.0f;
        GuiScreen owner = this.host.getScreen();
        switch (this.state) {
            case OPENING: {
                openAnimation = (float)(((double)((float)owner.field_146297_k.field_71441_e.func_82737_E() + partialTicks) - this.startAnimation) / 2.5);
                if (!((double)openAnimation >= 1.0) && this.getVisibleItemCount() != 0) break;
                openAnimation = 1.0f;
                this.state = State.NORMAL;
                break;
            }
            case CLOSING: {
                openAnimation = 1.0f - (float)(((double)((float)owner.field_146297_k.field_71441_e.func_82737_E() + partialTicks) - this.startAnimation) / 2.5);
                if (!(openAnimation <= 0.0f) && this.getVisibleItemCount() != 0) break;
                openAnimation = 0.0f;
                this.state = State.CLOSED;
            }
        }
        this.animProgress = openAnimation;
    }

    private void drawTooltips(int mouseX, int mouseY) {
        GuiScreen owner = this.host.getScreen();
        FontRenderer fontRenderer = this.host.getFontRenderer();
        ItemRenderer itemRenderer = this.host.getItemRenderer();
        for (int i = 0; i < this.visibleItems.size(); ++i) {
            RadialMenuItem item = this.visibleItems.get(i);
            if (!item.isHovered()) continue;
            DrawingContext context = new DrawingContext(owner.field_146294_l, owner.field_146295_m, mouseX, mouseY, 0.0f, fontRenderer, itemRenderer);
            item.drawTooltips(context);
        }
    }

    private void drawItems(int x, int y, float z, int width, int height, FontRenderer font, ItemRenderer itemRenderer) {
        this.iterateVisible((TriConsumer<RadialMenuItem, Float, Float>)((TriConsumer)(item, s, e) -> {
            float middle = (s.floatValue() + e.floatValue()) * 0.5f;
            float posX = (float)x + this.itemRadius * (float)Math.cos(middle);
            float posY = (float)y + this.itemRadius * (float)Math.sin(middle);
            DrawingContext context = new DrawingContext(width, height, posX, posY, z, font, itemRenderer);
            item.draw(context);
        }));
    }

    private void iterateVisible(TriConsumer<RadialMenuItem, Float, Float> consumer) {
        int numItems = this.visibleItems.size();
        for (int i = 0; i < numItems; ++i) {
            float s = (float)this.getAngleFor((double)i - 0.5, numItems);
            float e = (float)this.getAngleFor((double)i + 0.5, numItems);
            RadialMenuItem item = this.visibleItems.get(i);
            consumer.accept((Object)item, (Object)Float.valueOf(s), (Object)Float.valueOf(e));
        }
    }

    private void drawBackground(float x, float y, float z, float radiusIn, float radiusOut) {
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        this.iterateVisible((TriConsumer<RadialMenuItem, Float, Float>)((TriConsumer)(item, s, e) -> {
            Vector4f color = item.isHovered() ? this.backgroundColorHover : this.backgroundColor;
            this.drawPieArc(buffer, x, y, z, radiusIn, radiusOut, s.floatValue(), e.floatValue(), (int)(color.x * 255.0f), (int)(color.y * 255.0f), (int)(color.z * 255.0f), (int)(color.w * 255.0f));
        }));
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    private void drawPieArc(BufferBuilder buffer, float x, float y, float z, float radiusIn, float radiusOut, float startAngle, float endAngle, int r, int g, int b, int a) {
        float angle = endAngle - startAngle;
        int sections = Math.max(1, MathHelper.func_76123_f((float)(angle / 0.0069444445f)));
        angle = endAngle - startAngle;
        for (int i = 0; i < sections; ++i) {
            float angle1 = startAngle + (float)i / (float)sections * angle;
            float angle2 = startAngle + (float)(i + 1) / (float)sections * angle;
            float pos1InX = x + radiusIn * (float)Math.cos(angle1);
            float pos1InY = y + radiusIn * (float)Math.sin(angle1);
            float pos1OutX = x + radiusOut * (float)Math.cos(angle1);
            float pos1OutY = y + radiusOut * (float)Math.sin(angle1);
            float pos2OutX = x + radiusOut * (float)Math.cos(angle2);
            float pos2OutY = y + radiusOut * (float)Math.sin(angle2);
            float pos2InX = x + radiusIn * (float)Math.cos(angle2);
            float pos2InY = y + radiusIn * (float)Math.sin(angle2);
            buffer.func_181662_b((double)pos1OutX, (double)pos1OutY, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)pos1InX, (double)pos1InY, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)pos2InX, (double)pos2InY, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)pos2OutX, (double)pos2OutY, (double)z).func_181669_b(r, g, b, a).func_181675_d();
        }
    }

    public void cyclePrevious() {
        int numItems = this.getVisibleItemCount();
        int which = this.getHovered();
        if (--which < 0) {
            which = numItems - 1;
        }
        this.setHovered(which);
        this.moveMouseToItem(which, numItems);
    }

    public void cycleNext() {
        int numItems = this.getVisibleItemCount();
        int which = this.getHovered();
        if (which < 0) {
            which = 0;
        } else if (++which >= numItems) {
            which = 0;
        }
        this.moveMouseToItem(which, numItems);
        this.setHovered(which);
    }

    private void moveMouseToItem(int which, int numItems) {
        GuiScreen owner = this.host.getScreen();
        int x = owner.field_146294_l / 2;
        int y = owner.field_146295_m / 2;
        float angle = (float)this.getAngleFor(which, numItems);
        this.setMousePosition((double)x + (double)this.itemRadius * Math.cos(angle), (double)y + (double)this.itemRadius * Math.sin(angle));
    }

    private void setMousePosition(double x, double y) {
        GuiScreen owner = this.host.getScreen();
        GLFW.glfwSetCursorPos((long)owner.field_146297_k.field_195558_d.func_198092_i(), (double)((int)(x * (double)owner.field_146297_k.field_195558_d.func_198105_m() / (double)owner.field_146294_l)), (double)((int)(y * (double)owner.field_146297_k.field_195558_d.func_198083_n() / (double)owner.field_146295_m)));
    }

    private void processMouse(int mouseX, int mouseY) {
        double a;
        if (!this.isReady()) {
            return;
        }
        int numItems = this.getVisibleItemCount();
        GuiScreen owner = this.host.getScreen();
        int x = owner.field_146294_l / 2;
        int y = owner.field_146295_m / 2;
        double d = Math.sqrt(Math.pow(mouseX - x, 2.0) + Math.pow(mouseY - y, 2.0));
        double s0 = this.getAngleFor(-0.5, numItems);
        double s1 = this.getAngleFor((double)numItems - 0.5, numItems);
        for (a = Math.atan2(mouseY - y, mouseX - x); a < s0; a += Math.PI * 2) {
        }
        while (a >= s1) {
            a -= Math.PI * 2;
        }
        int hovered = -1;
        for (int i = 0; i < numItems; ++i) {
            float s = (float)this.getAngleFor((double)i - 0.5, numItems);
            float e = (float)this.getAngleFor((double)i + 0.5, numItems);
            if (!(a >= (double)s) || !(a < (double)e) || !(d >= (double)this.radiusIn) || !(d < (double)this.radiusOut) && !Config.clipMouseToCircle && !Config.allowClickOutsideBounds) continue;
            hovered = i;
            break;
        }
        this.setHovered(hovered);
        if (Config.clipMouseToCircle) {
            Minecraft mc = owner.field_146297_k;
            int windowWidth = mc.field_195558_d.func_198105_m();
            int windowHeight = mc.field_195558_d.func_198083_n();
            double[] xPos = new double[1];
            double[] yPos = new double[1];
            GLFW.glfwGetCursorPos((long)mc.field_195558_d.func_198092_i(), (double[])xPos, (double[])yPos);
            double scaledX = xPos[0] - (double)((float)windowWidth / 2.0f);
            double scaledY = yPos[0] - (double)((float)windowHeight / 2.0f);
            double distance = Math.sqrt(scaledX * scaledX + scaledY * scaledY);
            double radius = (double)(this.radiusOut * ((float)windowWidth / (float)owner.field_146294_l)) * 0.975;
            if (distance > radius) {
                double fixedX = scaledX * radius / distance;
                double fixedY = scaledY * radius / distance;
                GLFW.glfwSetCursorPos((long)mc.field_195558_d.func_198092_i(), (double)((int)((double)(windowWidth / 2) + fixedX)), (double)((int)((double)(windowHeight / 2) + fixedY)));
            }
        }
    }

    private double getAngleFor(double i, int numItems) {
        double angle = (i / (double)numItems + 0.25) * (Math.PI * 2) + Math.PI;
        return angle;
    }

    public static enum State {
        INITIALIZING,
        OPENING,
        NORMAL,
        CLOSING,
        CLOSED;

    }
}

