/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.common;

import gigaherz.toolbelt.ToolBelt;
import gigaherz.toolbelt.belt.ItemToolBelt;
import gigaherz.toolbelt.common.ContainerBelt;
import gigaherz.toolbelt.common.ContainerBeltSlot;
import gigaherz.toolbelt.common.GuiBelt;
import gigaherz.toolbelt.common.GuiBeltSlot;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IInteractionObject;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class GuiHandler {
    public static final ResourceLocation BELT = ToolBelt.location("belt");
    public static final ResourceLocation BELT_SLOT = ToolBelt.location("belt_slot");

    public static void openBeltGui(EntityPlayerMP player, int slot) {
        ItemStack heldItem = player.field_71071_by.func_70301_a(slot);
        if (heldItem.func_190916_E() > 0 && heldItem.func_77973_b() instanceof ItemToolBelt) {
            NetworkHooks.openGui((EntityPlayerMP)player, (IInteractionObject)new BeltGui(BELT, slot), data -> data.writeByte(slot));
        }
    }

    public static void openSlotGui(EntityPlayerMP player) {
        NetworkHooks.openGui((EntityPlayerMP)player, (IInteractionObject)new SlotGui(BELT_SLOT), data -> {});
    }

    public static class Client {
        @Nullable
        public static GuiScreen getClientGuiElement(FMLPlayMessages.OpenContainer message) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (BELT.equals((Object)message.getId())) {
                ItemStack heldItem = player.field_71071_by.func_70301_a((int)message.getAdditionalData().readByte());
                if (heldItem.func_190916_E() > 0) {
                    int blockedSlot = -1;
                    if (player.func_184614_ca() == heldItem) {
                        blockedSlot = player.field_71071_by.field_70461_c;
                    }
                    return new GuiBelt((IInventory)player.field_71071_by, blockedSlot, heldItem);
                }
            } else if (BELT_SLOT.equals((Object)message.getId())) {
                return new GuiBeltSlot((EntityPlayer)player);
            }
            return null;
        }
    }

    private static class SlotGui
    implements IInteractionObject {
        private final ResourceLocation id;

        public SlotGui(ResourceLocation id) {
            this.id = id;
        }

        public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer player) {
            return new ContainerBeltSlot(player.field_71071_by, !player.field_70170_p.field_72995_K, player);
        }

        public String func_174875_k() {
            return this.id.toString();
        }

        public ITextComponent func_200200_C_() {
            return new TextComponentString(this.id.toString());
        }

        public boolean func_145818_k_() {
            return false;
        }

        @Nullable
        public ITextComponent func_200201_e() {
            return null;
        }
    }

    private static class BeltGui
    implements IInteractionObject {
        private final ResourceLocation id;
        private final int slot;

        public BeltGui(ResourceLocation id, int slot) {
            this.id = id;
            this.slot = slot;
        }

        public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer player) {
            ItemStack heldItem = player.field_71071_by.func_70301_a(this.slot);
            int blockedSlot = -1;
            if (player.func_184614_ca() == heldItem) {
                blockedSlot = player.field_71071_by.field_70461_c;
            }
            return new ContainerBelt((IInventory)player.field_71071_by, blockedSlot, heldItem);
        }

        public String func_174875_k() {
            return this.id.toString();
        }

        public ITextComponent func_200200_C_() {
            return new TextComponentString(this.id.toString());
        }

        public boolean func_145818_k_() {
            return false;
        }

        @Nullable
        public ITextComponent func_200201_e() {
            return null;
        }
    }
}

