/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.customslots;

import com.google.common.collect.ImmutableSet;
import gigaherz.toolbelt.customslots.CapabilityExtensionSlotItem;
import gigaherz.toolbelt.customslots.IExtensionContainer;
import gigaherz.toolbelt.customslots.IExtensionSlotItem;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public interface IExtensionSlot {
    @Nonnull
    public IExtensionContainer getContainer();

    @Nonnull
    public ResourceLocation getType();

    @Nonnull
    public ItemStack getContents();

    public void setContents(@Nonnull ItemStack var1);

    public void onContentsChanged();

    default public boolean canEquip(@Nonnull ItemStack stack) {
        return (Boolean)stack.getCapability(CapabilityExtensionSlotItem.INSTANCE, null).map(extItem -> IExtensionSlot.isAcceptableSlot(this, stack, extItem) && extItem.canEquip(stack, this)).orElse((Object)false);
    }

    default public boolean canUnequip(@Nonnull ItemStack stack) {
        return (Boolean)stack.getCapability(CapabilityExtensionSlotItem.INSTANCE, null).map(extItem -> extItem.canUnequip(stack, this) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_190941_k, (ItemStack)stack) <= 0).orElse((Object)true);
    }

    public static boolean isAcceptableSlot(@Nonnull IExtensionSlot slot, @Nonnull ItemStack stack, @Nonnull IExtensionSlotItem extItem) {
        ImmutableSet<ResourceLocation> slots = extItem.getAcceptableSlots(stack);
        return slots.contains((Object)CapabilityExtensionSlotItem.ANY_SLOT) || slots.contains((Object)slot.getType());
    }
}

