/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.network;

import gigaherz.toolbelt.BeltFinder;
import gigaherz.toolbelt.Config;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class SwapItems {
    public int swapWith;

    public SwapItems() {
    }

    public SwapItems(int windowId) {
        this.swapWith = windowId;
    }

    public void fromBytes(PacketBuffer buf) {
        this.swapWith = buf.readInt();
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.swapWith);
    }

    public static void encode(SwapItems message, PacketBuffer packet) {
        message.toBytes(packet);
    }

    public static SwapItems decode(PacketBuffer packet) {
        SwapItems message = new SwapItems();
        message.fromBytes(packet);
        return message;
    }

    public static void onMessage(SwapItems message, Supplier<NetworkEvent.Context> context) {
        EntityPlayerMP player = context.get().getSender();
        WorldServer world = (WorldServer)player.field_70170_p;
        world.func_152344_a(() -> SwapItems.swapItem(message.swapWith, (EntityPlayer)player));
    }

    public static void swapItem(int swapWith, EntityPlayer player) {
        BeltFinder.BeltGetter getter = BeltFinder.findBelt(player);
        if (getter == null) {
            return;
        }
        ItemStack stack = getter.getBelt();
        if (stack.func_190916_E() <= 0) {
            return;
        }
        ItemStack inHand = player.func_184614_ca();
        if (!Config.isItemStackAllowed(inHand)) {
            return;
        }
        IItemHandlerModifiable cap = (IItemHandlerModifiable)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(() -> new RuntimeException("No inventory!"));
        if (swapWith < 0) {
            player.func_184611_a(EnumHand.MAIN_HAND, ItemHandlerHelper.insertItem((IItemHandler)cap, (ItemStack)inHand, (boolean)false));
        } else {
            ItemStack inSlot = cap.getStackInSlot(swapWith);
            player.func_184611_a(EnumHand.MAIN_HAND, inSlot);
            cap.setStackInSlot(swapWith, inHand);
        }
        getter.syncToClients();
    }
}

