/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.slot;

import com.google.common.collect.ImmutableList;
import gigaherz.toolbelt.ToolBelt;
import gigaherz.toolbelt.customslots.ExtensionSlotItemHandler;
import gigaherz.toolbelt.customslots.IExtensionContainer;
import gigaherz.toolbelt.customslots.IExtensionSlot;
import gigaherz.toolbelt.network.SyncBeltSlotContents;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class ExtensionSlotBelt
implements IExtensionContainer,
INBTSerializable<NBTTagCompound> {
    private static final ResourceLocation CAPABILITY_ID = new ResourceLocation("toolbelt", "belt_slot");
    @CapabilityInject(value=ExtensionSlotBelt.class)
    public static Capability<ExtensionSlotBelt> CAPABILITY = null;
    public static final ResourceLocation BELT = new ResourceLocation("examplemod", "belt");
    private final EntityLivingBase owner;
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ExtensionSlotBelt.this.belt.onContentsChanged();
        }
    };
    private final ExtensionSlotItemHandler belt = new ExtensionSlotItemHandler(this, BELT, (IItemHandlerModifiable)this.inventory, 0){};
    private final ImmutableList<IExtensionSlot> slots = ImmutableList.of((Object)this.belt);

    public static void register() {
        CapabilityManager.INSTANCE.register(ExtensionSlotBelt.class, (Capability.IStorage)new Capability.IStorage<ExtensionSlotBelt>(){

            @Nullable
            public INBTBase writeNBT(Capability<ExtensionSlotBelt> capability, ExtensionSlotBelt instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<ExtensionSlotBelt> capability, ExtensionSlotBelt instance, EnumFacing side, INBTBase nbt) {
            }
        }, () -> null);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlers());
    }

    public static ExtensionSlotBelt get(EntityLivingBase player) {
        return (ExtensionSlotBelt)player.getCapability(CAPABILITY, null).orElseThrow(() -> new RuntimeException("Capability not attached!"));
    }

    private void syncToSelf() {
        this.syncTo((EntityPlayer)this.owner);
    }

    protected void syncTo(EntityPlayer p) {
        SyncBeltSlotContents message = new SyncBeltSlotContents(p, this);
        ToolBelt.channel.sendTo((Object)message, ((EntityPlayerMP)p).field_71135_a.func_147362_b(), NetworkDirection.PLAY_TO_CLIENT);
    }

    private ExtensionSlotBelt(EntityLivingBase owner) {
        this.owner = owner;
    }

    @Override
    @Nonnull
    public EntityLivingBase getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public ImmutableList<IExtensionSlot> getSlots() {
        return this.slots;
    }

    @Override
    public void onContentsChanged(IExtensionSlot slot) {
    }

    @Nonnull
    public IExtensionSlot getBelt() {
        return this.belt;
    }

    private void tickAllSlots() {
        for (IExtensionSlot slot : this.slots) {
            ((ExtensionSlotItemHandler)slot).onWornTick();
        }
    }

    public void setAll(NonNullList<ItemStack> stacks) {
        ImmutableList<IExtensionSlot> slots = this.getSlots();
        for (int i = 0; i < slots.size(); ++i) {
            ((IExtensionSlot)slots.get(i)).setContents((ItemStack)stacks.get(i));
        }
    }

    public NBTTagCompound serializeNBT() {
        return this.inventory.serializeNBT();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.inventory.deserializeNBT(nbt);
    }

    static class EventHandlers {
        EventHandlers() {
        }

        @SubscribeEvent
        public void attachCapabilities(final AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityPlayer) {
                event.addCapability(CAPABILITY_ID, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                    final ExtensionSlotBelt extensionContainer;
                    final LazyOptional<ExtensionSlotBelt> extensionContainerInstance;
                    {
                        this.extensionContainer = new ExtensionSlotBelt((EntityLivingBase)((EntityPlayer)event.getObject())){

                            @Override
                            public void onContentsChanged(IExtensionSlot slot) {
                                EntityLivingBase owner = this.getOwner();
                                if (owner.field_70170_p instanceof WorldServer) {
                                    WorldServer svr = (WorldServer)owner.field_70170_p;
                                    svr.func_73039_n().getTrackingPlayers((Entity)owner).forEach(this::syncTo);
                                }
                            }
                        };
                        this.extensionContainerInstance = LazyOptional.of(() -> this.extensionContainer);
                    }

                    public NBTTagCompound serializeNBT() {
                        return this.extensionContainer.serializeNBT();
                    }

                    public void deserializeNBT(NBTTagCompound nbt) {
                        this.extensionContainer.deserializeNBT(nbt);
                    }

                    @Nullable
                    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                        if (capability == CAPABILITY) {
                            return this.extensionContainerInstance;
                        }
                        return LazyOptional.empty();
                    }
                });
            }
        }

        @SubscribeEvent
        public void track(EntityJoinWorldEvent event) {
            Entity target = event.getEntity();
            if (target.field_70170_p.field_72995_K) {
                return;
            }
            if (target instanceof EntityPlayer) {
                ExtensionSlotBelt instance = ExtensionSlotBelt.get((EntityLivingBase)target);
                instance.syncToSelf();
            }
        }

        @SubscribeEvent
        public void track(PlayerEvent.StartTracking event) {
            Entity target = event.getTarget();
            if (target.field_70170_p.field_72995_K) {
                return;
            }
            if (target instanceof EntityPlayer) {
                ExtensionSlotBelt instance = ExtensionSlotBelt.get((EntityLivingBase)target);
                instance.syncTo(event.getEntityPlayer());
            }
        }

        @SubscribeEvent
        public void entityTick(TickEvent.PlayerTickEvent event) {
            ExtensionSlotBelt instance = ExtensionSlotBelt.get((EntityLivingBase)event.player);
            instance.tickAllSlots();
        }
    }
}

