/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import gigaherz.toolbelt.ToolBelt;
import gigaherz.toolbelt.belt.ToolBeltItem;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigData {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    private static Set<ItemStack> blackList;
    private static Set<ItemStack> whiteList;
    public static boolean showBeltOnPlayers;
    public static double beltItemScale;
    public static boolean releaseToSwap;
    public static boolean clipMouseToCircle;
    public static boolean allowClickOutsideBounds;
    public static boolean displayEmptySlots;
    public static boolean disableAnvilUpgrading;
    public static CustomBeltSlotMode customBeltSlotMode;
    public static boolean customBeltSlotEnabled;
    public static boolean curiosPresent;
    private static final Pattern itemRegex;

    public static void refreshClient() {
        showBeltOnPlayers = (Boolean)ConfigData.CLIENT.showBeltOnPlayers.get();
        beltItemScale = (Double)ConfigData.CLIENT.beltItemScale.get();
        releaseToSwap = (Boolean)ConfigData.CLIENT.releaseToSwap.get();
        clipMouseToCircle = (Boolean)ConfigData.CLIENT.clipMouseToCircle.get();
        allowClickOutsideBounds = (Boolean)ConfigData.CLIENT.allowClickOutsideBounds.get();
        displayEmptySlots = (Boolean)ConfigData.CLIENT.displayEmptySlots.get();
    }

    public static void refreshServer() {
        disableAnvilUpgrading = (Boolean)ConfigData.SERVER.disableAnvilUpgrading.get();
        customBeltSlotMode = (CustomBeltSlotMode)((Object)ConfigData.SERVER.customBeltSlotMode.get());
        customBeltSlotEnabled = customBeltSlotMode == CustomBeltSlotMode.ON || customBeltSlotMode == CustomBeltSlotMode.AUTO && !curiosPresent;
        blackList = ((List)ConfigData.SERVER.blacklist.get()).stream().map(ConfigData::parseItemStack).collect(Collectors.toSet());
        whiteList = ((List)ConfigData.SERVER.whitelist.get()).stream().map(ConfigData::parseItemStack).collect(Collectors.toSet());
    }

    private static ItemStack parseItemStack(String itemString) {
        Matcher matcher = itemRegex.matcher(itemString);
        if (!matcher.matches()) {
            ToolBelt.logger.warn("Could not parse item " + itemString);
            return ItemStack.field_190927_a;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(matcher.group("item")));
        if (item == null) {
            ToolBelt.logger.warn("Could not parse item " + itemString);
            return ItemStack.field_190927_a;
        }
        return new ItemStack((IItemProvider)item, 1);
    }

    public static boolean isItemStackAllowed(ItemStack stack) {
        if (stack.func_190916_E() <= 0) {
            return true;
        }
        if (whiteList.stream().anyMatch(s -> ItemStack.func_179545_c((ItemStack)s, (ItemStack)stack))) {
            return true;
        }
        if (blackList.stream().anyMatch(s -> ItemStack.func_179545_c((ItemStack)s, (ItemStack)stack))) {
            return false;
        }
        if (stack.func_77973_b() instanceof ToolBeltItem) {
            return false;
        }
        return stack.func_77976_d() == 1;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        blackList = Sets.newHashSet();
        whiteList = Sets.newHashSet();
        showBeltOnPlayers = true;
        beltItemScale = 0.5;
        releaseToSwap = false;
        clipMouseToCircle = true;
        allowClickOutsideBounds = true;
        displayEmptySlots = true;
        disableAnvilUpgrading = false;
        customBeltSlotMode = CustomBeltSlotMode.ON;
        customBeltSlotEnabled = true;
        curiosPresent = false;
        itemRegex = Pattern.compile("^(?<item>([a-zA-Z-0-9_]+:)?[a-zA-Z-0-9_]+)(?:@((?<meta>[0-9]+)|(?<any>any)))?$");
    }

    public static enum CustomBeltSlotMode implements IStringSerializable
    {
        OFF("off"),
        AUTO("auto"),
        ON("on");

        private final String name;

        private CustomBeltSlotMode(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static CustomBeltSlotMode byName(String name) {
            for (CustomBeltSlotMode mode : CustomBeltSlotMode.values()) {
                if (!mode.name.equalsIgnoreCase(name)) continue;
                return mode;
            }
            return ON;
        }

        public static String[] names() {
            return (String[])Arrays.stream(CustomBeltSlotMode.values()).map(CustomBeltSlotMode::func_176610_l).toArray(String[]::new);
        }
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue showBeltOnPlayers;
        public final ForgeConfigSpec.DoubleValue beltItemScale;
        public final ForgeConfigSpec.BooleanValue releaseToSwap;
        public final ForgeConfigSpec.BooleanValue clipMouseToCircle;
        public final ForgeConfigSpec.BooleanValue allowClickOutsideBounds;
        public final ForgeConfigSpec.BooleanValue displayEmptySlots;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Options for customizing the display of tools on the player").push("display");
            this.showBeltOnPlayers = builder.comment("If set to FALSE, the belts and tools will NOT draw on players.").translation("text.toolbelt.config.show_belt_on_players").define("showBeltOnPlayers", true);
            this.beltItemScale = builder.comment("Changes the scale of items on the belt.").translation("text.toolbelt.config.belt_item_scale").defineInRange("beltItemScale", 0.5, 0.1, 2.0);
            builder.pop();
            builder.comment("Options for customizing the radial menu").push("menu");
            this.releaseToSwap = builder.comment("If set to TRUE, releasing the menu key (R) will activate the swap. Requires a click otherwise (default).").translation("text.toolbelt.config.release_to_swap").define("releaseToSwap", false);
            this.clipMouseToCircle = builder.comment("If set to TRUE, the radial menu will try to prevent the mouse from leaving the outer circle.").translation("text.toolbelt.config.clip_mouse_to_circle").define("clipMouseToCircle", false);
            this.allowClickOutsideBounds = builder.comment("If set to TRUE, the radial menu will allow clicking outside the outer circle to activate the items.").translation("text.toolbelt.config.click_outside_bounds").define("allowClickOutsideBounds", false);
            this.displayEmptySlots = builder.comment("If set to TRUE, the radial menu will always display all the slots, even when empty, and will allow choosing which empty slot to insert into.").translation("text.toolbelt.config.display_empty_slots").define("displayEmptySlots", false);
            builder.pop();
        }
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;
        public final ForgeConfigSpec.BooleanValue disableAnvilUpgrading;
        public final ForgeConfigSpec.EnumValue<CustomBeltSlotMode> customBeltSlotMode;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.whitelist = builder.comment("List of items to force-allow placing in the belt. Takes precedence over blacklist.").translation("text.toolbelt.config.whitelist").defineList("whitelist", (List)Lists.newArrayList(), o -> o instanceof String);
            this.blacklist = builder.comment("List of items to disallow from placing in the belt. (whitelist takes precedence)").translation("text.toolbelt.config.blacklist").defineList("blacklist", (List)Lists.newArrayList(), o -> o instanceof String);
            this.disableAnvilUpgrading = builder.comment("If set to TRUE, the internal anvil upgrade will not work, and alternative methods for upgrades will have to be provided externally.").translation("text.toolbelt.config.disable_anvil_update").define("disableAnvilUpgrading", false);
            this.customBeltSlotMode = builder.comment("If AUTO, the belt slot will be disabled if Curios is present. If OFF, the belt slot will be disabled permanently.").translation("text.toolbelt.config.custom_belt_slot_mode").defineEnum("customBeltSlotMode", (Enum)CustomBeltSlotMode.ON);
            builder.pop();
        }
    }
}

