/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.client;

import com.mojang.blaze3d.platform.GlStateManager;
import gigaherz.toolbelt.BeltFinder;
import gigaherz.toolbelt.ConfigData;
import gigaherz.toolbelt.ToolBelt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.CapabilityItemHandler;

public class LayerToolBelt<T extends PlayerEntity, M extends PlayerModel<T>>
extends LayerRenderer<T, M> {
    private static final ResourceLocation TEXTURE_BELT = ToolBelt.location("textures/entity/belt.png");
    private final LivingRenderer<T, M> owner;
    private final ModelBelt beltModel = new ModelBelt();

    public LayerToolBelt(LivingRenderer<T, M> owner) {
        super(owner);
        this.owner = owner;
    }

    public void render(T player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        boolean flag;
        boolean bl = flag = player.func_184591_cq() == HandSide.RIGHT;
        if (!ConfigData.showBeltOnPlayers) {
            return;
        }
        BeltFinder.findBelt(player).ifPresent(getter -> getter.getBelt().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(cap -> {
            ItemStack firstItem = cap.getStackInSlot(0);
            ItemStack secondItem = cap.getStackInSlot(1);
            ItemStack leftItem = flag ? firstItem : secondItem;
            ItemStack rightItem = flag ? secondItem : firstItem;
            GlStateManager.pushMatrix();
            if (player.func_70093_af()) {
                GlStateManager.translatef((float)0.0f, (float)0.2f, (float)0.0f);
            }
            this.translateToBody();
            if (!leftItem.func_190926_b() || !rightItem.func_190926_b()) {
                GlStateManager.pushMatrix();
                if (((PlayerModel)this.func_215332_c()).field_217113_d) {
                    GlStateManager.translatef((float)0.0f, (float)0.75f, (float)0.0f);
                    GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                }
                this.renderHeldItem((LivingEntity)player, rightItem, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HandSide.RIGHT);
                this.renderHeldItem((LivingEntity)player, leftItem, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HandSide.LEFT);
                GlStateManager.popMatrix();
            }
            GlStateManager.translatef((float)0.0f, (float)0.19f, (float)0.0f);
            GlStateManager.scalef((float)0.85f, (float)0.6f, (float)0.78f);
            this.owner.func_110776_a(TEXTURE_BELT);
            this.beltModel.render((PlayerEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, scale);
            GlStateManager.popMatrix();
        }));
    }

    private void translateToBody() {
        ((PlayerModel)this.func_215332_c()).field_78115_e.func_78794_c(0.0625f);
    }

    private void renderHeldItem(LivingEntity player, ItemStack stack, ItemCameraTransforms.TransformType cameraTransform, HandSide handSide) {
        if (stack.func_190926_b()) {
            return;
        }
        GlStateManager.pushMatrix();
        if (handSide == HandSide.LEFT) {
            GlStateManager.translatef((float)-0.271875f, (float)0.7f, (float)-0.1f);
        } else {
            GlStateManager.translatef((float)0.271875f, (float)0.7f, (float)-0.1f);
        }
        GlStateManager.rotatef((float)40.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        double scale = ConfigData.beltItemScale;
        GlStateManager.scaled((double)scale, (double)scale, (double)scale);
        Minecraft.func_71410_x().func_175599_af().func_184392_a(stack, player, cameraTransform, handSide == HandSide.LEFT);
        GlStateManager.popMatrix();
    }

    public boolean func_177142_b() {
        return false;
    }

    private static class ModelBelt
    extends EntityModel<PlayerEntity> {
        final RendererModel belt = new RendererModel((Model)this);
        final RendererModel buckle = new RendererModel((Model)this, 10, 10);
        final RendererModel pocketL = new RendererModel((Model)this, 0, 10);
        final RendererModel pocketR = new RendererModel((Model)this, 0, 10);

        private ModelBelt() {
            this.belt.func_78789_a(-5.0f, 10.0f, -3.0f, 10, 4, 6);
            this.buckle.func_78789_a(-2.5f, 9.5f, -3.5f, 5, 5, 1);
            this.pocketL.func_78789_a(-2.0f, 12.0f, 5.0f, 4, 4, 1);
            this.pocketL.field_78796_g = (float)Math.toRadians(-90.0);
            this.pocketR.func_78789_a(-2.0f, 12.0f, 5.0f, 4, 4, 1);
            this.pocketR.field_78796_g = (float)Math.toRadians(90.0);
        }

        public void render(PlayerEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            GlStateManager.disableRescaleNormal();
            GlStateManager.disableCull();
            this.belt.func_78785_a(scale);
            this.pocketL.func_78785_a(scale);
            this.pocketR.func_78785_a(scale);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)0.8f, (float)1.0f, (float)1.0f);
            this.buckle.func_78785_a(scale);
            GlStateManager.popMatrix();
        }
    }
}

