/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt;

import gigaherz.toolbelt.BeltFinder;
import gigaherz.toolbelt.ConfigData;
import gigaherz.toolbelt.belt.ToolBeltItem;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.ICurioItemHandler;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;

public class BeltFinderCurios
extends BeltFinder {
    @CapabilityInject(value=ICurioItemHandler.class)
    public static void initBaubles(Capability<?> cap) {
        BeltFinder.addFinder(new BeltFinderCurios());
        ConfigData.curiosPresent = true;
    }

    @Override
    public String getName() {
        return "curios";
    }

    @Override
    public void setToSlot(LivingEntity player, int slot, ItemStack stack) {
        CuriosAPI.getCuriosHandler((LivingEntity)player).ifPresent(curios -> {
            CurioStackHandler handler = curios.getStackHandler("belt");
            handler.setStackInSlot(slot, stack);
        });
    }

    @Override
    public Optional<? extends BeltFinder.BeltGetter> findStack(PlayerEntity player) {
        return (Optional)CuriosAPI.getCuriosHandler((LivingEntity)player).map(curios -> {
            CurioStackHandler handler = curios.getStackHandler("belt");
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack inSlot = handler.getStackInSlot(i);
                if (inSlot.func_190916_E() <= 0 || !(inSlot.func_77973_b() instanceof ToolBeltItem)) continue;
                return Optional.of(new CuriosBeltGetter(player, i));
            }
            return Optional.empty();
        }).orElseGet(Optional::empty);
    }

    private static class CuriosBeltGetter
    implements BeltFinder.BeltGetter {
        private final PlayerEntity thePlayer;
        private final int slotNumber;

        private CuriosBeltGetter(PlayerEntity thePlayer, int slotNumber) {
            this.thePlayer = thePlayer;
            this.slotNumber = slotNumber;
        }

        @Override
        public ItemStack getBelt() {
            return (ItemStack)CuriosAPI.getCuriosHandler((LivingEntity)this.thePlayer).map(curios -> {
                CurioStackHandler handler = curios.getStackHandler("belt");
                return handler.getStackInSlot(this.slotNumber);
            }).orElse((Object)ItemStack.field_190927_a);
        }

        @Override
        public void syncToClients() {
        }
    }
}

