/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt;

import gigaherz.toolbelt.BeltFinder;
import gigaherz.toolbelt.ConfigData;
import gigaherz.toolbelt.belt.ToolBeltItem;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class BeltFinderCurios
extends BeltFinder {
    @CapabilityInject(value=ICuriosItemHandler.class)
    public static void initBaubles(Capability<?> cap) {
        BeltFinder.addFinder(new BeltFinderCurios());
        ConfigData.curiosPresent = true;
    }

    @Override
    public String getName() {
        return "curios";
    }

    @Override
    public void setToSlot(LivingEntity player, int slot, ItemStack stack) {
        player.getCapability(CuriosCapability.INVENTORY).ifPresent(curios -> curios.getStacksHandler("belt").ifPresent(handler -> handler.getStacks().setStackInSlot(slot, stack)));
    }

    @Override
    public Optional<? extends BeltFinder.BeltGetter> findStack(PlayerEntity player) {
        return player.getCapability(CuriosCapability.INVENTORY).resolve().flatMap(curios -> curios.getStacksHandler("belt")).flatMap(handler -> {
            IDynamicStackHandler stacks = handler.getStacks();
            for (int i = 0; i < stacks.getSlots(); ++i) {
                ItemStack inSlot = stacks.getStackInSlot(i);
                if (inSlot.func_190916_E() <= 0 || !(inSlot.func_77973_b() instanceof ToolBeltItem)) continue;
                return Optional.of(new CuriosBeltGetter(player, i));
            }
            return Optional.empty();
        });
    }

    private static class CuriosBeltGetter
    implements BeltFinder.BeltGetter {
        private final PlayerEntity thePlayer;
        private final int slotNumber;

        private CuriosBeltGetter(PlayerEntity thePlayer, int slotNumber) {
            this.thePlayer = thePlayer;
            this.slotNumber = slotNumber;
        }

        @Override
        public ItemStack getBelt() {
            return this.thePlayer.getCapability(CuriosCapability.INVENTORY).map(curios -> curios.getStacksHandler("belt").map(handler -> handler.getStacks().getStackInSlot(this.slotNumber)).orElse(ItemStack.field_190927_a)).orElse(ItemStack.field_190927_a);
        }

        @Override
        public void syncToClients() {
        }
    }
}

