/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt;

import gigaherz.toolbelt.ConfigData;
import gigaherz.toolbelt.belt.ToolBeltItem;
import gigaherz.toolbelt.client.ClientEvents;
import gigaherz.toolbelt.common.BeltContainer;
import gigaherz.toolbelt.common.BeltScreen;
import gigaherz.toolbelt.common.BeltSlotContainer;
import gigaherz.toolbelt.common.BeltSlotScreen;
import gigaherz.toolbelt.customslots.ExtensionSlotItemCapability;
import gigaherz.toolbelt.network.BeltContentsChange;
import gigaherz.toolbelt.network.ContainerSlotsHack;
import gigaherz.toolbelt.network.OpenBeltSlotInventory;
import gigaherz.toolbelt.network.SwapItems;
import gigaherz.toolbelt.network.SyncBeltSlotContents;
import gigaherz.toolbelt.slot.BeltExtensionSlot;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypeMessage;

@Mod(value="toolbelt")
public class ToolBelt {
    public static final String MODID = "toolbelt";
    @ObjectHolder(value="toolbelt:belt")
    public static ToolBeltItem belt;
    @ObjectHolder(value="toolbelt:pouch")
    public static Item pouch;
    public static ToolBelt instance;
    public static final Logger logger;
    private static final String PROTOCOL_VERSION = "1.0";
    public static SimpleChannel channel;

    public ToolBelt() {
        instance = this;
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addGenericListener(Item.class, this::registerItems);
        modEventBus.addGenericListener(ContainerType.class, this::registerContainers);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::loadComplete);
        modEventBus.addListener(this::modConfig);
        modEventBus.addListener(this::imcEnqueue);
        MinecraftForge.EVENT_BUS.addListener(this::anvilChange);
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, ConfigData.SERVER_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, ConfigData.CLIENT_SPEC);
    }

    public void modConfig(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == ConfigData.CLIENT_SPEC) {
            ConfigData.refreshClient();
        } else if (config.getSpec() == ConfigData.SERVER_SPEC) {
            ConfigData.refreshServer();
        }
    }

    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ToolBeltItem(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i)).setRegistryName("belt"), (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78040_i)).setRegistryName("pouch")});
    }

    public void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new ContainerType[]{(ContainerType)new ContainerType(BeltSlotContainer::new).setRegistryName("belt_slot_container"), (ContainerType)IForgeContainerType.create(BeltContainer::new).setRegistryName("belt_container")});
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        int messageNumber = 0;
        channel.messageBuilder(SwapItems.class, messageNumber++).encoder(SwapItems::encode).decoder(SwapItems::new).consumer(SwapItems::handle).add();
        channel.messageBuilder(BeltContentsChange.class, messageNumber++).encoder(BeltContentsChange::encode).decoder(BeltContentsChange::new).consumer(BeltContentsChange::handle).add();
        channel.messageBuilder(OpenBeltSlotInventory.class, messageNumber++).encoder(OpenBeltSlotInventory::encode).decoder(OpenBeltSlotInventory::new).consumer(OpenBeltSlotInventory::handle).add();
        channel.messageBuilder(ContainerSlotsHack.class, messageNumber++).encoder(ContainerSlotsHack::encode).decoder(ContainerSlotsHack::new).consumer(ContainerSlotsHack::handle).add();
        channel.messageBuilder(SyncBeltSlotContents.class, messageNumber++).encoder(SyncBeltSlotContents::encode).decoder(SyncBeltSlotContents::new).consumer(SyncBeltSlotContents::handle).add();
        logger.debug("Final message number: " + messageNumber);
        ExtensionSlotItemCapability.register();
        BeltExtensionSlot.register();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            ScreenManager.func_216911_a(BeltContainer.TYPE, BeltScreen::new);
            ScreenManager.func_216911_a(BeltSlotContainer.TYPE, BeltSlotScreen::new);
        });
    }

    private void imcEnqueue(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("belt").icon(ToolBelt.location("gui/empty_belt_slot_background")).size(1).build());
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> ClientEvents::initKeybinds);
    }

    public void anvilChange(AnvilUpdateEvent ev) {
        if (ConfigData.disableAnvilUpgrading) {
            return;
        }
        ItemStack left = ev.getLeft();
        ItemStack right = ev.getRight();
        if (left.func_190916_E() <= 0 || left.func_77973_b() != belt) {
            return;
        }
        if (right.func_190916_E() <= 0 || right.func_77973_b() != pouch) {
            return;
        }
        int cost = ToolBeltItem.getUpgradeXP(left);
        if (cost < 0) {
            ev.setCanceled(true);
            return;
        }
        ev.setCost(cost);
        ev.setMaterialCost(1);
        ev.setOutput(ToolBeltItem.upgrade(left));
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MODID, path);
    }

    static {
        logger = LogManager.getLogger((String)MODID);
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)ToolBelt.location("general")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }
}

