/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import gigaherz.toolbelt.BeltFinder;
import gigaherz.toolbelt.ConfigData;
import gigaherz.toolbelt.ToolBelt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.items.CapabilityItemHandler;

public class LayerToolBelt
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private static final ResourceLocation TEXTURE_BELT = ToolBelt.location("textures/entity/belt.png");
    private final LivingRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> owner;
    private final ModelBelt beltModel = new ModelBelt();

    public LayerToolBelt(LivingRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> owner) {
        super(owner);
        this.owner = owner;
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int lightness, AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag;
        boolean bl = flag = player.func_184591_cq() == HandSide.RIGHT;
        if (!ConfigData.showBeltOnPlayers) {
            return;
        }
        BeltFinder.findBelt((PlayerEntity)player).ifPresent(getter -> getter.getBelt().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(cap -> {
            ItemStack firstItem = cap.getStackInSlot(0);
            ItemStack secondItem = cap.getStackInSlot(1);
            ItemStack leftItem = flag ? firstItem : secondItem;
            ItemStack rightItem = flag ? secondItem : firstItem;
            matrixStack.func_227860_a_();
            this.translateToBody(matrixStack);
            if (!leftItem.func_190926_b() || !rightItem.func_190926_b()) {
                matrixStack.func_227860_a_();
                if (((PlayerModel)this.func_215332_c()).field_217114_e) {
                    matrixStack.func_227861_a_(0.0, 0.75, 0.0);
                    matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
                }
                this.renderHeldItem((LivingEntity)player, rightItem, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HandSide.RIGHT, matrixStack, buffer, lightness);
                this.renderHeldItem((LivingEntity)player, leftItem, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HandSide.LEFT, matrixStack, buffer, lightness);
                matrixStack.func_227865_b_();
            }
            matrixStack.func_227861_a_(0.0, (double)0.19f, 0.0);
            matrixStack.func_227862_a_(0.85f, 0.6f, 0.78f);
            LayerToolBelt.func_229141_a_((EntityModel)this.beltModel, (ResourceLocation)TEXTURE_BELT, (MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, (int)lightness, (LivingEntity)player, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.func_227865_b_();
        }));
    }

    private void translateToBody(MatrixStack matrixStack) {
        ((PlayerModel)this.func_215332_c()).field_78115_e.func_228307_a_(matrixStack);
    }

    private void renderHeldItem(LivingEntity player, ItemStack stack, ItemCameraTransforms.TransformType transformType, HandSide handSide, MatrixStack matrixStack, IRenderTypeBuffer buffer, int lightness) {
        if (stack.func_190926_b()) {
            return;
        }
        matrixStack.func_227860_a_();
        if (handSide == HandSide.LEFT) {
            matrixStack.func_227861_a_((double)-0.271875f, (double)0.7f, (double)-0.1f);
        } else {
            matrixStack.func_227861_a_((double)0.271875f, (double)0.7f, (double)-0.1f);
        }
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(40.0f));
        float scale = ConfigData.beltItemScale;
        matrixStack.func_227862_a_(scale, scale, scale);
        Minecraft.func_71410_x().func_175597_ag().func_228397_a_(player, stack, transformType, handSide == HandSide.LEFT, matrixStack, buffer, lightness);
        matrixStack.func_227865_b_();
    }

    private static class ModelBelt
    extends EntityModel<PlayerEntity> {
        final ModelRenderer belt = new ModelRenderer((Model)this);
        final ModelRenderer buckle = new ModelRenderer((Model)this, 10, 10);
        final ModelRenderer pocketL = new ModelRenderer((Model)this, 0, 10);
        final ModelRenderer pocketR = new ModelRenderer((Model)this, 0, 10);

        private ModelBelt() {
            this.belt.func_228300_a_(-5.0f, 10.0f, -3.0f, 10.0f, 4.0f, 6.0f);
            this.buckle.func_228300_a_(-2.5f, 9.5f, -3.5f, 5.0f, 5.0f, 1.0f);
            this.pocketL.func_228300_a_(-2.0f, 12.0f, 5.0f, 4.0f, 4.0f, 1.0f);
            this.pocketL.field_78796_g = (float)Math.toRadians(-90.0);
            this.pocketR.func_228300_a_(-2.0f, 12.0f, 5.0f, 4.0f, 4.0f, 1.0f);
            this.pocketR.field_78796_g = (float)Math.toRadians(90.0);
        }

        public void setRotationAngles(PlayerEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        }

        public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder vertexBuilder, int p_225598_3_, int p_225598_4_, float p_225598_5_, float p_225598_6_, float p_225598_7_, float p_225598_8_) {
            RenderSystem.disableRescaleNormal();
            RenderSystem.disableCull();
            this.belt.func_228309_a_(matrixStack, vertexBuilder, p_225598_3_, p_225598_4_, p_225598_5_, p_225598_6_, p_225598_7_, p_225598_8_);
            this.pocketL.func_228309_a_(matrixStack, vertexBuilder, p_225598_3_, p_225598_4_, p_225598_5_, p_225598_6_, p_225598_7_, p_225598_8_);
            this.pocketR.func_228309_a_(matrixStack, vertexBuilder, p_225598_3_, p_225598_4_, p_225598_5_, p_225598_6_, p_225598_7_, p_225598_8_);
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.8f, 1.0f, 1.0f);
            this.buckle.func_228309_a_(matrixStack, vertexBuilder, p_225598_3_, p_225598_4_, p_225598_5_, p_225598_6_, p_225598_7_, p_225598_8_);
            matrixStack.func_227865_b_();
            RenderSystem.enableCull();
            RenderSystem.enableRescaleNormal();
        }
    }
}

