/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.customslots.example;

import com.google.common.collect.ImmutableList;
import gigaherz.toolbelt.customslots.IExtensionContainer;
import gigaherz.toolbelt.customslots.IExtensionSlot;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class VanillaLivingEquipment
implements IExtensionContainer {
    public static final ResourceLocation HEAD = new ResourceLocation("minecraft", EquipmentSlotType.HEAD.func_188450_d());
    public static final ResourceLocation CHEST = new ResourceLocation("minecraft", EquipmentSlotType.CHEST.func_188450_d());
    public static final ResourceLocation LEGS = new ResourceLocation("minecraft", EquipmentSlotType.LEGS.func_188450_d());
    public static final ResourceLocation FEET = new ResourceLocation("minecraft", EquipmentSlotType.FEET.func_188450_d());
    public static final ResourceLocation OFFHAND = new ResourceLocation("minecraft", EquipmentSlotType.OFFHAND.func_188450_d());
    public static final ResourceLocation MAINHAND = new ResourceLocation("minecraft", EquipmentSlotType.MAINHAND.func_188450_d());
    private final LivingEntity owner;
    private final ImmutableList<IExtensionSlot> slots = ImmutableList.of((Object)new Slot(HEAD, EquipmentSlotType.HEAD), (Object)new Slot(CHEST, EquipmentSlotType.CHEST), (Object)new Slot(LEGS, EquipmentSlotType.LEGS), (Object)new Slot(FEET, EquipmentSlotType.FEET), (Object)new Slot(OFFHAND, EquipmentSlotType.OFFHAND), (Object)new Slot(MAINHAND, EquipmentSlotType.MAINHAND));

    public VanillaLivingEquipment(LivingEntity owner) {
        this.owner = owner;
    }

    @Override
    @Nonnull
    public ImmutableList<IExtensionSlot> getSlots() {
        return this.slots;
    }

    @Override
    public void onContentsChanged(IExtensionSlot slot) {
    }

    @Override
    @Nonnull
    public LivingEntity getOwner() {
        return this.owner;
    }

    private class Slot
    implements IExtensionSlot {
        private final ResourceLocation id;
        private final EquipmentSlotType slot;

        private Slot(ResourceLocation id, EquipmentSlotType slot) {
            this.id = id;
            this.slot = slot;
        }

        @Override
        @Nonnull
        public IExtensionContainer getContainer() {
            return VanillaLivingEquipment.this;
        }

        @Override
        @Nonnull
        public ResourceLocation getType() {
            return this.id;
        }

        @Override
        @Nonnull
        public ItemStack getContents() {
            return VanillaLivingEquipment.this.owner.func_184582_a(this.slot);
        }

        @Override
        public void setContents(@Nonnull ItemStack stack) {
            VanillaLivingEquipment.this.owner.func_184201_a(this.slot, stack);
        }

        @Override
        public void onContentsChanged() {
            VanillaLivingEquipment.this.onContentsChanged(this);
        }

        @Override
        public boolean canEquip(@Nonnull ItemStack stack) {
            if (stack.func_77973_b().canEquip(stack, this.slot, (Entity)VanillaLivingEquipment.this.owner)) {
                return true;
            }
            return IExtensionSlot.super.canEquip(stack);
        }
    }
}

