/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexiyorlov.tp.api;

public class IntColor {
    private int red;
    private int green;
    private int blue;
    private int alpha;
    private int packedColor;

    public IntColor(int color, int alpha) {
        this.red = color >> 16 & 0xFF;
        this.green = color >> 8 & 0xFF;
        this.blue = color & 0xFF;
        this.packedColor = color;
        this.alpha = alpha;
    }

    public IntColor(int intColor) {
        this(intColor, 255);
    }

    public IntColor(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        this.packedColor = 65536 * red + 256 * green + blue;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getGreen() {
        return this.green;
    }

    public int getRed() {
        return this.red;
    }

    public int getPackedColor() {
        return this.packedColor;
    }
}

