/*
 * Decompiled with CFR 0.152.
 */
package alexiy.projectile.preview;

import alexiy.projectile.preview.ClientEvents;
import alexiy.projectile.preview.PathParticle;
import alexiy.projectile.preview.RenderPath;
import alexiy.projectile.preview.api.InvisibleEntity;
import alexiy.projectile.preview.api.PreviewPlugin;
import alexiy.projectile.preview.api.PreviewProvider;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(acceptedMinecraftVersions="[1.12]", modid="trajectory_preview", name="Trajectory Preview", version="0.3", clientSideOnly=true)
public class TP {
    static final String ID = "trajectory_preview";
    static final String VERSION = "0.3";
    static final String NAME = "Trajectory Preview";
    static HashSet<PreviewProvider> previewProviders = new HashSet(2);
    private Set<ASMDataTable.ASMData> asmData;

    @Mod.EventHandler
    public void preload(FMLPreInitializationEvent preInitializationEvent) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.asmData = preInitializationEvent.getAsmData().getAll(PreviewPlugin.class.getCanonicalName());
        this.asmData.removeIf(asmData1 -> {
            String requiredMod = (String)asmData1.getAnnotationInfo().get("mod");
            return !Loader.isModLoaded((String)requiredMod);
        });
        Set set = preInitializationEvent.getAsmData().getAll(InvisibleEntity.class.getCanonicalName());
        set.forEach(asmData1 -> {
            try {
                Class<?> entityClass = Class.forName(asmData1.getClassName());
                RenderingRegistry.registerEntityRenderingHandler(entityClass, RenderPath::new);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.out.println("Entity class not found: " + noClassDefFoundError.getMessage());
            }
        });
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent initializationEvent) {
        for (ASMDataTable.ASMData asmDatum : this.asmData) {
            String classname = asmDatum.getClassName();
            try {
                Class<?> clas = Class.forName(classname);
                Object object = clas.newInstance();
                if (!(object instanceof PreviewProvider)) continue;
                PreviewProvider multipleAmmoUser = (PreviewProvider)object;
                previewProviders.add(multipleAmmoUser);
                multipleAmmoUser.prepare();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Mod.EventHandler
    public void postload(FMLPostInitializationEvent postInitializationEvent) {
        Minecraft.func_71410_x().field_71452_i.func_178929_a(51, (IParticleFactory)new PathParticle.Factory());
    }

    @SubscribeEvent
    public void changeOptions(ConfigChangedEvent.OnConfigChangedEvent configChangedEvent) {
        if (configChangedEvent.getModID().equals(ID)) {
            ConfigManager.sync((String)ID, (Config.Type)Config.Type.INSTANCE);
        }
    }
}

