/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexiyorlov.tp;

import io.github.alexiyorlov.tp.ConfigScreen;
import io.github.alexiyorlov.tp.PType;
import io.github.alexiyorlov.tp.PathParticle;
import io.github.alexiyorlov.tp.api.IntColor;
import io.github.alexiyorlov.tp.api.PreviewEntity;
import io.github.alexiyorlov.tp.api.PreviewPlugin;
import io.github.alexiyorlov.tp.api.PreviewProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.Type;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
@Mod(value="trajectory_preview")
public class TrajectoryPreview {
    static final String ID = "trajectory_preview";
    static HashSet<PreviewProvider> previewProviders = new HashSet(2);
    static PType particleType;
    static ForgeConfigSpec.ConfigValue<String> primaryDotColor;
    static ForgeConfigSpec.ConfigValue<String> secondaryDotColor;
    static ForgeConfigSpec.DoubleValue pathStart;

    public TrajectoryPreview() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        IEventBus eventBus = context.getModEventBus();
        eventBus.register((Object)this);
        Pair pair = new ForgeConfigSpec.Builder().configure(builder -> {
            primaryDotColor = builder.define("Primary preview dot color", (Object)"75aaff");
            secondaryDotColor = builder.define("Secondary preview dot color", (Object)"e7ed49");
            pathStart = builder.defineInRange("Start preview after such distance", 2.0, 1.0, 256.0);
            return builder.build();
        });
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (ForgeConfigSpec)pair.getRight());
        Type type = Type.getType(PreviewPlugin.class);
        Set<ModFileScanData.AnnotationData> list = ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> type.equals((Object)a.getAnnotationType())).collect(Collectors.toSet());
        list.forEach(annotationData -> {
            try {
                Class<?> plugin = Class.forName(annotationData.getClassType().getClassName());
                Object object = plugin.newInstance();
                if (object instanceof PreviewProvider) {
                    PreviewProvider previewProvider = (PreviewProvider)object;
                    previewProvider.prepare();
                    previewProviders.add(previewProvider);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        });
    }

    @SubscribeEvent
    public static void renderTrajectory(RenderGameOverlayEvent.Post renderGameOverlayEvent) {
        if (renderGameOverlayEvent.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ClientPlayerEntity playerEntity = minecraft.field_71439_g;
            ParticleManager particleManager = minecraft.field_71452_i;
            ClientWorld world = minecraft.field_71441_e;
            ItemStack itemStack = playerEntity.func_184614_ca();
            Item item = itemStack.func_77973_b();
            if (!itemStack.func_190926_b()) {
                Class<? extends PreviewEntity<? extends Entity>> previewEntity = null;
                for (PreviewProvider previewProvider : previewProviders) {
                    Class<? extends PreviewEntity<? extends Entity>> cl = previewProvider.getPreviewEntityFor((PlayerEntity)playerEntity, item);
                    if (cl == null) continue;
                    previewEntity = cl;
                    break;
                }
                if (previewEntity != null) {
                    try {
                        PreviewEntity entity = (PreviewEntity)previewEntity.getConstructor(World.class).newInstance(world);
                        Object target = entity.initializeEntity((PlayerEntity)playerEntity, itemStack);
                        if (target != null) {
                            Entity e = (Entity)entity;
                            e.func_70107_b(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
                            e.func_213317_d(target.func_213322_ci());
                            e.field_70177_z = ((Entity)target).field_70177_z;
                            e.field_70125_A = ((Entity)target).field_70125_A;
                            e.field_70127_C = ((Entity)target).field_70127_C;
                            e.field_70126_B = ((Entity)target).field_70126_B;
                            world.func_217376_c(e);
                            ArrayList<Vec3d> trajectory = new ArrayList<Vec3d>(128);
                            int cycle = 0;
                            while (e.func_70089_S()) {
                                entity.simulateShot(target);
                                if (cycle > 512) break;
                                Vec3d newPoint = new Vec3d(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_());
                                if ((double)MathHelper.func_76133_a((double)playerEntity.func_195048_a(newPoint)) > (Double)pathStart.get()) {
                                    trajectory.add(newPoint);
                                }
                                cycle = (short)(cycle + 1);
                            }
                            IntColor colorFirst = new IntColor(Integer.parseInt((String)primaryDotColor.get(), 16));
                            IntColor color2 = new IntColor(Integer.parseInt((String)secondaryDotColor.get(), 16));
                            for (Vec3d vec3d : trajectory) {
                                double distanceFromPlayer = Math.sqrt(playerEntity.func_195048_a(vec3d));
                                Vec3d end = (Vec3d)trajectory.get(trajectory.size() - 1);
                                double totalDistance = Math.sqrt(playerEntity.func_195048_a(end));
                                float pointScale = (float)(distanceFromPlayer / totalDistance);
                                Particle point = particleManager.func_199280_a((IParticleData)ParticleTypes.field_197624_q, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.0, 0.0, 0.0);
                                if (point == null) continue;
                                if (trajectory.indexOf(vec3d) % 2 == 0) {
                                    point.func_70538_b((float)colorFirst.getRed() / 255.0f, (float)colorFirst.getGreen() / 255.0f, (float)colorFirst.getBlue() / 255.0f);
                                } else {
                                    point.func_70538_b((float)color2.getRed() / 255.0f, (float)color2.getGreen() / 255.0f, (float)color2.getBlue() / 255.0f);
                                }
                                point.func_70541_f(pointScale);
                                point.func_187112_i();
                            }
                        }
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onSetup(FMLClientSetupEvent clientSetupEvent) {
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)particleType, (IParticleFactory)new PathParticle.Factory());
        ModLoadingContext.get().getActiveContainer().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (minecraft, screen) -> new ConfigScreen((ITextComponent)new StringTextComponent(ID), (Screen)screen));
    }

    @SubscribeEvent
    public void registerPaticle(RegistryEvent.Register<ParticleType<?>> registryEvent) {
        particleType = (PType)((Object)Registry.func_218322_a((Registry)Registry.field_212632_u, (ResourceLocation)new ResourceLocation(ID, "preview_point"), (Object)((Object)new PType(false))));
    }
}

