/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexiyorlov.tp.basic;

import io.github.alexiyorlov.tp.api.InvisibleEntity;
import io.github.alexiyorlov.tp.api.PreviewEntity;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

@InvisibleEntity
public class BowArrowPreview
extends Entity
implements PreviewEntity<AbstractArrowEntity> {
    protected Entity shooter;
    private boolean inGround;

    public BowArrowPreview(World worldIn) {
        super(EntityType.field_200790_d, worldIn);
    }

    @Override
    public AbstractArrowEntity initializeEntity(PlayerEntity player, ItemStack associatedItem) {
        int maxduration;
        int difference;
        float arrowVelocity;
        int timeleft = player.func_184605_cv();
        if (timeleft > 0 && (double)(arrowVelocity = BowItem.func_185059_b((int)(difference = (maxduration = player.func_184614_ca().func_77988_m()) - timeleft))) >= 0.1) {
            ArrowEntity entityArrow = new ArrowEntity(this.field_70170_p, (LivingEntity)player);
            entityArrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 3.0f * arrowVelocity, 0.0f);
            this.shooter = player;
            return entityArrow;
        }
        return null;
    }

    protected float waterDrag() {
        return 0.6f;
    }

    @Override
    public void simulateShot(AbstractArrowEntity simulatedEntity) {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState iblockstate;
        super.func_70071_h_();
        Vec3d motion = this.func_213322_ci();
        double value = motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)value);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)motion.field_72450_a, (double)motion.field_72449_c) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)motion.field_72448_b, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!(iblockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()))).isAir((IBlockReader)this.field_70170_p, blockpos) && !(voxelshape = iblockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b()) {
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()))) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.inGround) {
            this.func_70106_y();
        } else {
            Entity entity;
            Vec3d vec3d1 = new Vec3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            Vec3d vec3d = new Vec3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()).func_178787_e(motion);
            BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vec3d1, vec3d, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            vec3d1 = new Vec3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            vec3d = new Vec3d(this.func_226277_ct_() + motion.field_72450_a, this.func_226278_cu_() + motion.field_72448_b, this.func_226281_cx_() + motion.field_72449_c);
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                vec3d = new Vec3d(raytraceresult.func_216347_e().field_72450_a, raytraceresult.func_216347_e().field_72448_b, raytraceresult.func_216347_e().field_72449_c);
            }
            if ((entity = this.findEntityOnPath(vec3d1, vec3d)) instanceof PlayerEntity) {
                PlayerEntity entityplayer = (PlayerEntity)entity;
                if (this.shooter instanceof PlayerEntity && !((PlayerEntity)this.shooter).func_96122_a(entityplayer)) {
                    raytraceresult = null;
                }
            }
            if (entity != null) {
                this.func_70106_y();
            }
            if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                this.func_70106_y();
            }
            this.func_70107_b(this.func_226277_ct_() + motion.field_72450_a, this.func_226278_cu_() + motion.field_72448_b, this.func_226281_cx_() + motion.field_72449_c);
            float f4 = MathHelper.func_76133_a((double)value);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)motion.field_72450_a, (double)motion.field_72449_c) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)motion.field_72448_b, (double)f4) * 57.29577951308232);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f1 = 0.99f;
            if (this.func_70090_H()) {
                f1 = this.waterDrag();
            }
            this.func_213293_j(motion.field_72450_a * (double)f1, motion.field_72448_b * (double)f1, motion.field_72449_c * (double)f1);
            if (!this.func_189652_ae()) {
                this.func_70024_g(0.0, -0.05f, 0.0);
            }
            this.func_145775_I();
        }
    }

    @Nullable
    private Entity findEntityOnPath(Vec3d start, Vec3d end) {
        Entity entity = null;
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), entity1 -> !entity1.func_175149_v() && entity1.func_70089_S() && entity1.func_70067_L());
        double d0 = 0.0;
        for (Entity entity12 : list) {
            double d1;
            AxisAlignedBB axisalignedbb;
            Optional raytraceresult;
            if (entity12 == this.shooter || !(raytraceresult = (axisalignedbb = entity12.func_174813_aQ().func_186662_g((double)0.3f)).func_216365_b(start, end)).isPresent() || !((d1 = start.func_72436_e((Vec3d)raytraceresult.get())) < d0) && d0 != 0.0) continue;
            entity = entity12;
            d0 = d1;
        }
        return entity;
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
    }
}

