/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.block;

import info.u_team.useful_railroads.block.CustomTileEntityPoweredRailBlock;
import info.u_team.useful_railroads.init.UsefulRailroadsTileEntityTypes;
import info.u_team.useful_railroads.item.TeleportRailBlockItem;
import info.u_team.useful_railroads.tileentity.TeleportRailTileEntity;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TeleportRailBlock
extends CustomTileEntityPoweredRailBlock {
    public TeleportRailBlock(String name) {
        super(name, () -> UsefulRailroadsTileEntityTypes.TELEPORT_RAIL);
    }

    @Override
    protected BlockItem createBlockItem(Item.Properties blockItemProperties) {
        return new TeleportRailBlockItem(this, blockItemProperties);
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return this.openContainer(world, pos, player, true);
    }

    @Override
    public void onMinecartPass(BlockState state, World world, BlockPos pos, AbstractMinecartEntity cart) {
        if (world.field_72995_K) {
            return;
        }
        if (!((Boolean)state.func_177229_b((IProperty)PoweredRailBlock.field_176569_M)).booleanValue()) {
            return;
        }
        this.isTileEntityFromType((IBlockReader)world, pos).map(TeleportRailTileEntity.class::cast).ifPresent(tileEntity -> tileEntity.teleport(pos, cart));
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!world.field_72995_K && !player.func_184812_l_()) {
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this.getItemStack((IBlockReader)world, pos));
            itemEntity.func_174869_p();
            world.func_217376_c((Entity)itemEntity);
        }
        super.func_176208_a(world, pos, state, player);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.getItemStack(world, pos);
    }

    private ItemStack getItemStack(IBlockReader world, BlockPos pos) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TeleportRailTileEntity) {
            TeleportRailTileEntity teleportRailTileEntity = (TeleportRailTileEntity)tileEntity;
            CompoundNBT compound = new CompoundNBT();
            teleportRailTileEntity.writeNBT(compound);
            if (!compound.isEmpty()) {
                stack.func_77983_a("BlockEntityTag", (INBT)compound);
            }
        }
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        CompoundNBT compound = stack.func_179543_a("BlockEntityTag");
        boolean compoundExists = compound != null;
        String langKey = "container.usefulrailroads.teleport_rail.";
        if (compoundExists && compound.func_74764_b("location")) {
            CompoundNBT locationCompound = compound.func_74775_l("location");
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"container.usefulrailroads.teleport_rail.dimension", (Object[])new Object[0]) + ": " + TextFormatting.DARK_GREEN + locationCompound.func_74779_i("dimension")));
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"container.usefulrailroads.teleport_rail.x", (Object[])new Object[0]) + ": " + TextFormatting.DARK_GREEN + locationCompound.func_74762_e("x")));
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"container.usefulrailroads.teleport_rail.y", (Object[])new Object[0]) + ": " + TextFormatting.DARK_GREEN + locationCompound.func_74762_e("y")));
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"container.usefulrailroads.teleport_rail.z", (Object[])new Object[0]) + ": " + TextFormatting.DARK_GREEN + locationCompound.func_74762_e("z")));
        } else {
            tooltip.add(new TranslationTextComponent("block.usefulrailroads.teleport_rail.missing_setup", new Object[0]).func_211708_a(TextFormatting.RED));
            tooltip.add(new TranslationTextComponent("block.usefulrailroads.teleport_rail.how_to_setup", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
        if (compoundExists) {
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"container.usefulrailroads.teleport_rail.fuel", (Object[])new Object[0]) + ": " + TextFormatting.DARK_AQUA + compound.func_74762_e("fuel")));
        }
    }
}

