/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.block;

import info.u_team.useful_railroads.block.CustomAdvancedTileEntityRailBlock;
import info.u_team.useful_railroads.init.UsefulRailroadsTileEntityTypes;
import info.u_team.useful_railroads.tileentity.BufferStopTileEntity;
import info.u_team.useful_railroads.util.ItemHandlerUtil;
import info.u_team.useful_railroads.util.VoxelShapeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class BufferStopBlock
extends CustomAdvancedTileEntityRailBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    private static final Map<Direction, VoxelShape> VOXEL_SHAPES = BufferStopBlock.createVoxelShape();

    private static List<Pair<Vec3d, Vec3d>> createSideShapeVec(int bracketStart, int bracketEnd, int supportStart, int supportEnd, int stopperStart, int stopperEnd) {
        ArrayList<Pair<Vec3d, Vec3d>> list = new ArrayList<Pair<Vec3d, Vec3d>>();
        for (int i = 0; i < 10; ++i) {
            list.add(VoxelShapeUtil.createVectorPair(bracketStart, 2 + i, 14 - i, bracketEnd, 3 + i, 16 - i));
        }
        list.add(VoxelShapeUtil.createVectorPair(stopperStart, 11.0, 0.0, stopperEnd, 16.0, 1.0));
        list.add(VoxelShapeUtil.createVectorPair(supportStart, 2.0, 2.0, supportEnd, 14.0, 6.0));
        return list;
    }

    private static Map<Direction, VoxelShape> createVoxelShape() {
        ArrayList<Pair<Vec3d, Vec3d>> northShape = new ArrayList<Pair<Vec3d, Vec3d>>();
        northShape.addAll(BufferStopBlock.createSideShapeVec(2, 3, 2, 4, 0, 5));
        northShape.addAll(BufferStopBlock.createSideShapeVec(13, 14, 12, 14, 11, 16));
        northShape.add(VoxelShapeUtil.createVectorPair(0.0, 12.0, 1.0, 16.0, 15.0, 3.0));
        return VoxelShapeUtil.getHorizontalRotations(northShape).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, valueEntry -> VoxelShapes.func_216384_a((VoxelShape)field_185590_a, (VoxelShape[])((VoxelShape[])VoxelShapeUtil.createVoxelShapeFromVector((List)valueEntry.getValue()).stream().toArray(VoxelShape[]::new)))));
    }

    public BufferStopBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200942_a().func_200943_b(1.5f).func_200947_a(SoundType.field_185852_e), (Supplier<? extends TileEntityType<?>>)UsefulRailroadsTileEntityTypes.BUFFER_STOP);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)SHAPE, (Comparable)RailShape.NORTH_SOUTH)).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return VOXEL_SHAPES.getOrDefault(state.func_177229_b((IProperty)FACING), VOXEL_SHAPES.get(Direction.NORTH));
    }

    public void onMinecartPass(BlockState state, World world, BlockPos pos, AbstractMinecartEntity cart) {
        cart.func_213293_j(0.0, 0.0, 0.0);
        boolean powered = (Boolean)state.func_177229_b((IProperty)POWERED);
        if (!powered) {
            Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
            Vec3d vec = cart.func_174791_d().func_72441_c((double)direction.func_82601_c() * 1.1, 0.0, (double)direction.func_82599_e() * 1.1);
            cart.func_70012_b(vec.func_82615_a(), vec.func_82617_b(), vec.func_82616_c(), cart.field_70177_z, cart.field_70125_A);
        }
        if (world.field_72995_K || !powered) {
            return;
        }
        Optional tileEntityOptional = this.isTileEntityFromType((IBlockReader)world, pos);
        tileEntityOptional.map(tileEntity -> tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).ifPresent(lazyOptional -> lazyOptional.ifPresent(handler -> {
            cart.func_184226_ay();
            ArrayList drops = new ArrayList();
            cart.captureDrops(drops);
            cart.func_94095_a(DamageSource.field_76376_m);
            drops.stream().map(ItemEntity::func_92059_d).forEach(stack -> {
                ItemStack stackLeft = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
                if (!stackLeft.func_190926_b()) {
                    BufferStopBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stackLeft);
                }
            });
        }));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (context.getEntity() instanceof AbstractMinecartEntity) {
            Direction.AxisDirection axisDirection;
            Vec3d motion = context.getEntity().func_213322_ci();
            Direction oppositeDirection = ((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d();
            Direction.Axis axis = oppositeDirection.func_176740_k();
            if (this.isRightCollision(axis, Direction.Axis.X, axisDirection = oppositeDirection.func_176743_c(), motion.func_82615_a()) || this.isRightCollision(axis, Direction.Axis.Z, axisDirection, motion.func_82616_c())) {
                return VoxelShapes.func_197880_a();
            }
        }
        return state.func_196954_c(world, pos);
    }

    private final boolean isRightCollision(Direction.Axis axis, Direction.Axis axisToCheck, Direction.AxisDirection axisDirection, double motion) {
        return axis == axisToCheck && Math.abs(motion) > 0.01 && (axisDirection == Direction.AxisDirection.NEGATIVE && motion < 0.0 || axisDirection == Direction.AxisDirection.POSITIVE && motion > 0.0);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_195992_f().func_176734_d();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)SHAPE, (Comparable)(direction.func_176740_k() == Direction.Axis.Z ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST))).func_206870_a((IProperty)FACING, (Comparable)direction);
    }

    protected BlockState func_208489_a(World worldIn, BlockPos pos, BlockState state, boolean placing) {
        return state;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() == newState.func_177230_c()) {
            RailShape newShape = (RailShape)newState.func_177229_b((IProperty)SHAPE);
            Direction newDirection = (Direction)newState.func_177229_b((IProperty)FACING);
            if (newShape != state.func_177229_b((IProperty)SHAPE)) {
                if (newDirection.func_176740_k() == Direction.Axis.Z && newShape != RailShape.NORTH_SOUTH) {
                    world.func_175656_a(pos, (BlockState)newState.func_206870_a((IProperty)SHAPE, (Comparable)RailShape.NORTH_SOUTH));
                } else if (newDirection.func_176740_k() == Direction.Axis.X && newShape != RailShape.EAST_WEST) {
                    world.func_175656_a(pos, (BlockState)newState.func_206870_a((IProperty)SHAPE, (Comparable)RailShape.EAST_WEST));
                }
            }
        } else {
            Optional tileEntityOptional = this.isTileEntityFromType((IBlockReader)world, pos);
            tileEntityOptional.map(BufferStopTileEntity::getMinecartSlots).ifPresent(minecartSlots -> ItemHandlerUtil.getStackStream((IItemHandler)minecartSlots).forEach(stack -> BufferStopBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack)));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.updatePower(world, state, pos);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
        this.updatePower(world, state, pos);
    }

    private void updatePower(World world, BlockState state, BlockPos pos) {
        boolean powered = this.isPowered(world, pos);
        if (powered != (Boolean)state.func_177229_b((IProperty)POWERED)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered)));
        }
    }

    private boolean isPowered(World world, BlockPos pos) {
        return Stream.of(Direction.values()).anyMatch(direction -> this.isPowered(world, pos, (Direction)direction));
    }

    private boolean isPowered(World world, BlockPos pos, Direction direction) {
        BlockPos relativePos = pos.func_177972_a(direction);
        int value = world.func_175651_c(relativePos, direction);
        if (value >= 15) {
            return true;
        }
        BlockState relativeState = world.func_180495_p(relativePos);
        return Math.max(value, relativeState.func_177230_c() == Blocks.field_150488_af ? (Integer)relativeState.func_177229_b((IProperty)RedstoneWireBlock.field_176351_O) : 0) > 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public float getRailMaxSpeed(BlockState state, World world, BlockPos pos, AbstractMinecartEntity cart) {
        return 0.0f;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{SHAPE, FACING, POWERED});
    }

    public boolean canMakeSlopes(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public boolean isFlexibleRail(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }
}

