/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.data.builder;

import com.google.gson.JsonObject;
import info.u_team.useful_railroads.init.UsefulRailroadsRecipeSerializers;
import info.u_team.useful_railroads.recipe.FuelRecipe;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;

public class FuelRecipeBuilder {
    private final FuelRecipe.Serializer<?> serializer;
    private final Ingredient ingredient;
    private final int fuel;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    private String group;

    public static FuelRecipeBuilder teleportRailFuel(Ingredient ingredient, int fuel) {
        return new FuelRecipeBuilder((FuelRecipe.Serializer)UsefulRailroadsRecipeSerializers.TELEPORT_RAIL_FUEL.get(), ingredient, fuel);
    }

    public static FuelRecipeBuilder trackBuilderFuel(Ingredient ingredient, int fuel) {
        return new FuelRecipeBuilder((FuelRecipe.Serializer)UsefulRailroadsRecipeSerializers.TRACK_BUILDER_FUEL.get(), ingredient, fuel);
    }

    protected FuelRecipeBuilder(FuelRecipe.Serializer<?> serializer, Ingredient ingredient, int fuel) {
        this.serializer = serializer;
        this.ingredient = ingredient;
        this.fuel = fuel;
    }

    public FuelRecipeBuilder addCriterion(String name, ICriterionInstance criterion) {
        this.advancementBuilder.func_200275_a(name, criterion);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer, String save) {
        this.build(consumer, new ResourceLocation(save));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        this.validate(id);
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)new RecipeUnlockedTrigger.Instance(id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumer.accept(new Result(this.serializer, id, this.group == null ? "" : this.group, this.ingredient, this.fuel, this.advancementBuilder, new ResourceLocation(id.func_110624_b(), "recipes/" + id.func_110623_a())));
    }

    private void validate(ResourceLocation id) {
        if (this.advancementBuilder.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final FuelRecipe.Serializer<?> serializer;
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final int fuel;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public Result(FuelRecipe.Serializer<?> serializer, ResourceLocation id, String group, Ingredient ingredient, int fuel, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
            this.serializer = serializer;
            this.id = id;
            this.group = group;
            this.ingredient = ingredient;
            this.fuel = fuel;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("ingredient", this.ingredient.func_200304_c());
            json.addProperty("fuel", (Number)this.fuel);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

