/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.data.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import info.u_team.u_team_core.data.CommonBlockStatesProvider;
import info.u_team.u_team_core.data.CommonProvider;
import info.u_team.u_team_core.data.GenerationData;
import info.u_team.useful_railroads.block.BufferStopBlock;
import info.u_team.useful_railroads.block.CustomPoweredRailBlock;
import info.u_team.useful_railroads.block.DirectionRailBlock;
import info.u_team.useful_railroads.init.UsefulRailroadsBlocks;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.IGeneratedBlockstate;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class UsefulRailroadsBlockStatesProvider
extends CommonBlockStatesProvider {
    private final Constructor<VariantBlockStateBuilder.PartialBlockstate> PARTIAL_BLOCK_STATE_CONSTRUCTOR = ObfuscationReflectionHelper.findConstructor(VariantBlockStateBuilder.PartialBlockstate.class, (Class[])new Class[]{Block.class, Map.class, VariantBlockStateBuilder.class});
    private final Constructor<VariantBlockStateBuilder> VARIANT_BLOCK_STATE_BUILDER_CONSTRUCTOR = ObfuscationReflectionHelper.findConstructor(VariantBlockStateBuilder.class, (Class[])new Class[]{Block.class});

    public UsefulRailroadsBlockStatesProvider(GenerationData data) {
        super(data);
    }

    protected void registerStatesAndModels() {
        this.customFlatPoweredRail((CustomPoweredRailBlock)UsefulRailroadsBlocks.HIGHSPEED_RAIL.get(), (ModelFile)this.flatRail("highspeed_rail"), (ModelFile)this.flatRail("highspeed_powered_rail"));
        this.customFlatPoweredRail((CustomPoweredRailBlock)UsefulRailroadsBlocks.SPEED_CLAMP_RAIL.get(), (ModelFile)this.flatRail("clamp_rail"), (ModelFile)this.flatRail("clamp_powered_rail"));
        this.forAllFlatRailStates(this.getUncheckedVariantBuilder(UsefulRailroadsBlocks.DIRECTION_RAIL.get()), state -> {
            RailShape shape = (RailShape)state.func_177229_b((IProperty)DirectionRailBlock.field_176568_b);
            boolean powered = (Boolean)state.func_177229_b((IProperty)DirectionRailBlock.field_176569_M);
            boolean positiveAxis = (Boolean)state.func_177229_b((IProperty)DirectionRailBlock.AXIS_DIRECTION);
            return ConfiguredModel.builder().modelFile((ModelFile)(powered ? this.flatRail("direction_powered_rail") : this.flatRail("direction_rail"))).rotationY((shape == RailShape.EAST_WEST ? -90 : 0) + (positiveAxis ? 180 : 0)).build();
        });
        this.simpleBlock(UsefulRailroadsBlocks.INTERSECTION_RAIL.get(), (ModelFile)this.flatRail("intersection_rail"));
        this.customFlatPoweredRail((CustomPoweredRailBlock)UsefulRailroadsBlocks.TELEPORT_RAIL.get(), (ModelFile)this.flatRail("teleport_rail"), (ModelFile)this.flatRail("teleport_powered_rail"));
        this.getVariantBuilder(UsefulRailroadsBlocks.BUFFER_STOP.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)new ModelFile.ExistingModelFile(this.modLoc("block/buffer_stop"), this.models().existingFileHelper)).rotationY(((int)((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)).func_185119_l() + 180) % 360).build(), new IProperty[]{BufferStopBlock.POWERED, BufferStopBlock.SHAPE});
    }

    private void customFlatPoweredRail(CustomPoweredRailBlock block, ModelFile normal, ModelFile powered) {
        this.customFlatPoweredRail(block, blockState -> (Boolean)blockState.func_177229_b((IProperty)CustomPoweredRailBlock.field_176569_M) != false ? powered : normal);
    }

    private void customFlatPoweredRail(CustomPoweredRailBlock block, Function<BlockState, ModelFile> modelFunc) {
        this.forAllFlatRailStates(this.getUncheckedVariantBuilder((Block)block), state -> {
            RailShape shape = (RailShape)state.func_177229_b((IProperty)CustomPoweredRailBlock.field_176568_b);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(shape == RailShape.EAST_WEST ? 90 : 0).build();
        });
    }

    private VariantBlockStateBuilder forAllFlatRailStates(VariantBlockStateBuilder builder, Function<BlockState, ConfiguredModel[]> mapper) {
        HashSet seen = new HashSet();
        if (!(builder.getOwner() instanceof CustomPoweredRailBlock)) {
            throw new IllegalArgumentException("This method only allow custom powered rail blocks");
        }
        builder.getOwner().func_176194_O().func_177619_a().forEach(fullState -> {
            RailShape shape;
            VariantBlockStateBuilder.PartialBlockstate partialState = this.newPartialBlockState(builder.getOwner(), Maps.newLinkedHashMap((Map)fullState.func_206871_b()), builder);
            if (seen.add(partialState) && ((shape = (RailShape)fullState.func_177229_b((IProperty)CustomPoweredRailBlock.field_176568_b)) == RailShape.NORTH_SOUTH || shape == RailShape.EAST_WEST)) {
                builder.setModels(partialState, (ConfiguredModel[])mapper.apply((BlockState)fullState));
            }
        });
        return builder;
    }

    private BlockModelBuilder flatRail(String name) {
        return (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/rail_flat")).texture("rail", this.modLoc("block/" + name));
    }

    private VariantBlockStateBuilder.PartialBlockstate newPartialBlockState(Block owner, Map<IProperty<?>, Comparable<?>> setStates, VariantBlockStateBuilder outerBuilder) {
        try {
            return this.PARTIAL_BLOCK_STATE_CONSTRUCTOR.newInstance(owner, setStates, outerBuilder);
        }
        catch (Exception ex) {
            CommonProvider.LOGGER.fatal(this.marker, "Cannot create new PartialBlockstate with reflection.", (Throwable)ex);
            return null;
        }
    }

    private VariantBlockStateBuilder newVariantBlockStateBuilder(Block block) {
        try {
            return this.VARIANT_BLOCK_STATE_BUILDER_CONSTRUCTOR.newInstance(block);
        }
        catch (Exception ex) {
            CommonProvider.LOGGER.fatal(this.marker, "Cannot create new VariantBlockStateBuilder with reflection.", (Throwable)ex);
            return null;
        }
    }

    private VariantBlockStateBuilder getUncheckedVariantBuilder(Block block) {
        if (this.registeredBlocks.containsKey(block)) {
            IGeneratedBlockstate old = (IGeneratedBlockstate)this.registeredBlocks.get(block);
            Preconditions.checkState((boolean)(old instanceof VariantBlockStateBuilder));
            return (VariantBlockStateBuilder)old;
        }
        VariantBlockStateBuilder ret = this.newVariantBlockStateBuilder(block);
        this.registeredBlocks.put(block, () -> {
            JsonObject variants = new JsonObject();
            ret.getModels().entrySet().stream().sorted(Map.Entry.comparingByKey(VariantBlockStateBuilder.PartialBlockstate.comparingByProperties())).forEach(entry -> variants.add(((VariantBlockStateBuilder.PartialBlockstate)entry.getKey()).toString(), ((BlockStateProvider.ConfiguredModelList)entry.getValue()).toJSON()));
            JsonObject main = new JsonObject();
            main.add("variants", (JsonElement)variants);
            return main;
        });
        return ret;
    }
}

