/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import info.u_team.u_team_core.recipeserializer.URecipeSerializer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class FuelRecipe
implements IRecipe<IInventory> {
    protected final Ingredient ingredient;
    protected final int fuel;
    protected final ResourceLocation id;
    protected final String group;

    public FuelRecipe(ResourceLocation id, String group, Ingredient ingredient, int fuel) {
        this.id = id;
        this.group = group;
        this.ingredient = ingredient;
        this.fuel = fuel;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_77569_a(IInventory inv, World world) {
        return this.ingredient.test(inv.func_70301_a(0));
    }

    public int getFuel() {
        return this.fuel;
    }

    public static class Serializer<T extends FuelRecipe>
    extends URecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T read(ResourceLocation id, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Ingredient ingredient = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
            int fuel = JSONUtils.func_151203_m((JsonObject)json, (String)"fuel");
            return this.factory.create(id, group, ingredient, fuel);
        }

        public T read(ResourceLocation id, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            int fuel = buffer.readInt();
            return this.factory.create(id, group, ingredient, fuel);
        }

        public void write(PacketBuffer buffer, T recipe) {
            buffer.func_180714_a(((FuelRecipe)recipe).group);
            ((FuelRecipe)recipe).ingredient.func_199564_a(buffer);
            buffer.writeInt(((FuelRecipe)recipe).fuel);
        }

        public static interface IFactory<T extends FuelRecipe> {
            public T create(ResourceLocation var1, String var2, Ingredient var3, int var4);
        }
    }
}

