/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.block;

import info.u_team.u_team_core.api.registry.IBlockItemProvider;
import info.u_team.useful_railroads.init.UsefulRailroadsItemGroups;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.Property;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class CustomPoweredRailBlock
extends PoweredRailBlock
implements IBlockItemProvider {
    protected final BlockItem blockItem = this.createBlockItem(new Item.Properties().func_200916_a((ItemGroup)UsefulRailroadsItemGroups.GROUP));
    protected final double minSpeed = 0.01;

    public CustomPoweredRailBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.7f).func_200947_a(SoundType.field_185852_e), true);
    }

    protected BlockItem createBlockItem(Item.Properties blockItemProperties) {
        return new BlockItem((Block)this, blockItemProperties);
    }

    public BlockItem getBlockItem() {
        return this.blockItem;
    }

    public void onMinecartPass(BlockState state, World world, BlockPos pos, AbstractMinecartEntity cart) {
        this.moveAlongTrack(pos, state, cart);
    }

    protected void moveAlongTrack(BlockPos pos, BlockState state, AbstractMinecartEntity cart) {
        AbstractRailBlock railBlock = (AbstractRailBlock)state.func_177230_c();
        RailShape railDirection = railBlock.getRailDirection(state, (IBlockReader)cart.field_70170_p, pos, cart);
        boolean powered = railBlock == this ? (Boolean)state.func_177229_b((Property)PoweredRailBlock.field_176569_M) : false;
        double currentSpeed = CustomPoweredRailBlock.getPlaneSqrtDistance(cart.func_213322_ci());
        if (currentSpeed < 0.01) {
            if (cart.shouldDoRailFunctions() && powered) {
                this.doPushOffWall(pos, cart, railDirection, cart.func_213322_ci());
            }
            this.doPassengerPush(cart);
        } else if (cart.shouldDoRailFunctions()) {
            if (powered) {
                this.doPoweredMovement(pos, state, cart, railDirection);
            } else {
                this.doUnpoweredMovement(cart);
            }
        }
    }

    protected void doPassengerPush(AbstractMinecartEntity cart) {
        Vector3d passengerMotion;
        double passengerDistanceSqr;
        Entity passenger;
        Entity entity = passenger = cart.func_184188_bt().isEmpty() ? null : (Entity)cart.func_184188_bt().get(0);
        if (passenger instanceof PlayerEntity && (passengerDistanceSqr = CustomPoweredRailBlock.getPlaneSqrDistance(passengerMotion = passenger.func_213322_ci())) > 1.0E-4) {
            cart.func_213317_d(cart.func_213322_ci().func_72441_c(passengerMotion.field_72450_a * 0.1, 0.0, passengerMotion.field_72449_c * 0.1));
        }
    }

    protected void doUnpoweredMovement(AbstractMinecartEntity cart) {
        double currentSpeed = CustomPoweredRailBlock.getPlaneSqrtDistance(cart.func_213322_ci());
        if (currentSpeed < 0.01) {
            cart.func_213317_d(Vector3d.field_186680_a);
        } else {
            cart.func_213317_d(cart.func_213322_ci().func_216372_d(0.5, 0.0, 0.5));
        }
    }

    protected void doPoweredMovement(BlockPos pos, BlockState state, AbstractMinecartEntity cart, RailShape railDirection) {
        this.controlSpeed(pos, state, cart);
    }

    protected void doPushOffWall(BlockPos pos, AbstractMinecartEntity cart, RailShape railDirection, Vector3d cartMotion) {
        double xCartMotion = cartMotion.field_72450_a;
        double zCartMotion = cartMotion.field_72449_c;
        if (railDirection == RailShape.EAST_WEST) {
            if (CustomPoweredRailBlock.isNormalCube(cart.field_70170_p, pos.func_177976_e())) {
                xCartMotion = 0.01;
            } else if (CustomPoweredRailBlock.isNormalCube(cart.field_70170_p, pos.func_177974_f())) {
                xCartMotion = -0.01;
            }
        } else if (railDirection == RailShape.NORTH_SOUTH) {
            if (CustomPoweredRailBlock.isNormalCube(cart.field_70170_p, pos.func_177978_c())) {
                zCartMotion = 0.01;
            } else if (CustomPoweredRailBlock.isNormalCube(cart.field_70170_p, pos.func_177968_d())) {
                zCartMotion = -0.01;
            }
        } else {
            return;
        }
        cart.func_213293_j(xCartMotion, cartMotion.field_72448_b, zCartMotion);
    }

    protected void controlSpeed(BlockPos pos, BlockState state, AbstractMinecartEntity cart) {
        Vector3d cartMotion = cart.func_213322_ci();
        double cartDistance = CustomPoweredRailBlock.getPlaneSqrtDistance(cartMotion);
        cart.func_213317_d(cartMotion.func_72441_c(cartMotion.field_72450_a / cartDistance * 0.06, 0.0, cartMotion.field_72449_c / cartDistance * 0.06));
    }

    protected void speedUpCart(AbstractMinecartEntity cart, double accel, double speedClamp) {
        Vector3d motion = cart.func_213322_ci();
        double speed = motion.func_72433_c();
        double newSpeed = MathHelper.func_151237_a((double)(speed + accel), (double)(-speedClamp), (double)speedClamp);
        this.setCartSpeed(cart, newSpeed, motion);
    }

    protected void setCartSpeed(AbstractMinecartEntity cart, double speed) {
        this.setCartSpeed(cart, speed, cart.func_213322_ci());
    }

    protected void setCartSpeed(AbstractMinecartEntity cart, double speed, Vector3d direction) {
        Vector3d directionNormalised = direction.func_72432_b();
        this.setCartSpeed(cart, directionNormalised.func_216369_h(new Vector3d(speed, speed, speed)));
    }

    protected void setCartSpeed(AbstractMinecartEntity cart, double velX, double velY, double velZ) {
        this.setCartSpeed(cart, new Vector3d(velX, velY, velZ));
    }

    protected void setCartSpeed(AbstractMinecartEntity cart, Vector3d vel) {
        cart.func_213317_d(vel);
        cart.func_213315_a(MoverType.SELF, vel);
    }

    private static boolean isNormalCube(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_215686_e((IBlockReader)world, pos);
    }

    private static double getPlaneSqrtDistance(Vector3d vec) {
        return Math.sqrt(CustomPoweredRailBlock.getPlaneSqrDistance(vec));
    }

    private static double getPlaneSqrDistance(Vector3d vec) {
        return vec.field_72450_a * vec.field_72450_a + vec.field_72449_c * vec.field_72449_c;
    }
}

