/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.inventory;

import info.u_team.useful_railroads.init.UsefulRailroadsRecipeTypes;
import info.u_team.useful_railroads.init.UsefulRailroadsTags;
import info.u_team.useful_railroads.inventory.BlockTagItemStackHandler;
import info.u_team.useful_railroads.inventory.FuelItemHandler;
import info.u_team.useful_railroads.recipe.TrackBuilderFuelRecipe;
import info.u_team.useful_railroads.util.TrackBuilderMode;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ITag;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TrackBuilderInventoryWrapper {
    protected final BlockTagItemStackHandler railInventory = new BlockTagItemStackHandler((ITag<Item>)UsefulRailroadsTags.Items.TRACK_BUILDER_RAILS, 15);
    protected final BlockTagItemStackHandler groundInventory = new BlockTagItemStackHandler((ITag<Item>)UsefulRailroadsTags.Items.TRACK_BUILDER_GROUND_BLOCKS, 30);
    protected final BlockTagItemStackHandler tunnelInventory = new BlockTagItemStackHandler((ITag<Item>)UsefulRailroadsTags.Items.TRACK_BUILDER_TUNNEL_BLOCKS, 45);
    protected final BlockTagItemStackHandler redstoneTorchInventory = new BlockTagItemStackHandler((ITag<Item>)UsefulRailroadsTags.Items.TRACK_BUILDER_REDSTONE_TORCHES, 5);
    protected final BlockTagItemStackHandler torchInventory = new BlockTagItemStackHandler((ITag<Item>)UsefulRailroadsTags.Items.TRACK_BUILDER_TORCHES, 4);
    protected final IItemHandler fuelInventory;
    protected int fuel = 0;
    protected TrackBuilderMode mode = TrackBuilderMode.MODE_NOAIR;

    private TrackBuilderInventoryWrapper(Supplier<World> worldSupplier) {
        this.fuelInventory = new FuelItemHandler<TrackBuilderFuelRecipe>(UsefulRailroadsRecipeTypes.TRACK_BUILDER_FUEL, worldSupplier, fuelAdder -> this.fuel += fuelAdder);
    }

    public BlockTagItemStackHandler getRailInventory() {
        return this.railInventory;
    }

    public BlockTagItemStackHandler getGroundInventory() {
        return this.groundInventory;
    }

    public BlockTagItemStackHandler getTunnelInventory() {
        return this.tunnelInventory;
    }

    public BlockTagItemStackHandler getRedstoneTorchInventory() {
        return this.redstoneTorchInventory;
    }

    public BlockTagItemStackHandler getTorchInventory() {
        return this.torchInventory;
    }

    public IItemHandler getFuelInventory() {
        return this.fuelInventory;
    }

    public void readItemStack() {
    }

    public void writeItemStack() {
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int fuel) {
        this.fuel = fuel;
    }

    public TrackBuilderMode getMode() {
        return this.mode;
    }

    public void setMode(TrackBuilderMode mode) {
        this.mode = mode;
    }

    public static class Server
    extends TrackBuilderInventoryWrapper {
        private final ItemStack stack;

        public Server(ItemStack stack, Supplier<World> worldSupplier) {
            super(worldSupplier);
            this.stack = stack;
            this.readItemStack();
        }

        @Override
        public void readItemStack() {
            this.readItemHandler(this.railInventory, "rail");
            this.readItemHandler(this.groundInventory, "ground");
            this.readItemHandler(this.tunnelInventory, "tunnel");
            this.readItemHandler(this.redstoneTorchInventory, "redstone_torch");
            this.readItemHandler(this.torchInventory, "torch");
            CompoundNBT compound = this.stack.func_77978_p();
            if (compound != null) {
                this.fuel = compound.func_74762_e("fuel");
                this.mode = TrackBuilderMode.byName(compound.func_74779_i("mode"));
            }
        }

        @Override
        public void writeItemStack() {
            CompoundNBT compound;
            this.writeItemHandler(this.railInventory, "rail");
            this.writeItemHandler(this.groundInventory, "ground");
            this.writeItemHandler(this.tunnelInventory, "tunnel");
            this.writeItemHandler(this.redstoneTorchInventory, "redstone_torch");
            this.writeItemHandler(this.torchInventory, "torch");
            if (this.fuel > 0) {
                compound = this.stack.func_196082_o();
                compound.func_74768_a("fuel", this.fuel);
            } else {
                compound = this.stack.func_77978_p();
                if (compound != null) {
                    compound.func_82580_o("fuel");
                }
            }
            if (this.mode != TrackBuilderMode.MODE_NOAIR) {
                compound = this.stack.func_196082_o();
                compound.func_74778_a("mode", this.mode.getName());
            } else {
                compound = this.stack.func_77978_p();
                if (compound != null) {
                    compound.func_82580_o("mode");
                }
            }
        }

        private void readItemHandler(ItemStackHandler handler, String childCompoundName) {
            CompoundNBT childCompound = this.stack.func_179543_a(childCompoundName);
            if (childCompound != null) {
                handler.deserializeNBT(childCompound);
            }
        }

        private void writeItemHandler(ItemStackHandler handler, String childCompoundName) {
            if (IntStream.range(0, handler.getSlots()).mapToObj(arg_0 -> ((ItemStackHandler)handler).getStackInSlot(arg_0)).allMatch(ItemStack::func_190926_b)) {
                this.stack.func_196083_e(childCompoundName);
            } else {
                this.stack.func_196082_o().func_218657_a(childCompoundName, (INBT)handler.serializeNBT());
            }
        }
    }

    public static class Client
    extends TrackBuilderInventoryWrapper {
        public Client(int fuel, TrackBuilderMode mode, Supplier<World> worldSupplier) {
            super(worldSupplier);
            this.fuel = fuel;
            this.mode = mode;
        }
    }
}

