/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.tileentity;

import info.u_team.u_team_core.api.sync.IInitSyncedTileEntity;
import info.u_team.u_team_core.tileentity.UTileEntity;
import info.u_team.u_team_core.util.world.WorldUtil;
import info.u_team.useful_railroads.config.CommonConfig;
import info.u_team.useful_railroads.container.TeleportRailContainer;
import info.u_team.useful_railroads.init.UsefulRailroadsRecipeTypes;
import info.u_team.useful_railroads.init.UsefulRailroadsTileEntityTypes;
import info.u_team.useful_railroads.inventory.FuelItemHandler;
import info.u_team.useful_railroads.recipe.TeleportRailFuelRecipe;
import info.u_team.useful_railroads.util.Location;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class TeleportRailTileEntity
extends UTileEntity
implements IInitSyncedTileEntity {
    private final Location location = Location.getOrigin();
    private int fuel;
    private int cost;
    private final FuelItemHandler<TeleportRailFuelRecipe> fuelSlot = new FuelItemHandler<TeleportRailFuelRecipe>(UsefulRailroadsRecipeTypes.TELEPORT_RAIL_FUEL, () -> ((TeleportRailTileEntity)this).func_145831_w(), () -> this.fuel < 10000, fuelAdder -> {
        this.fuel += fuelAdder;
        this.func_70296_d();
    });
    private final LazyOptional<FuelItemHandler<TeleportRailFuelRecipe>> fuelSlotOptional = LazyOptional.of(() -> this.fuelSlot);

    public TeleportRailTileEntity() {
        super((TileEntityType)UsefulRailroadsTileEntityTypes.TELEPORT_RAIL.get());
    }

    private void checkCost() {
        if (this.cost == 0) {
            this.cost = this.calculateCost();
        }
    }

    private int calculateCost() {
        int calculatedCost = 0;
        if (!this.location.getRegistryKey().equals((Object)this.field_145850_b.func_234923_W_())) {
            calculatedCost += ((Integer)CommonConfig.getInstance().teleportRailDimensionCost.get()).intValue();
        }
        double calculatedDistance = Math.log(this.field_174879_c.func_177951_i((Vector3i)this.location.getPos())) / Math.log(((Integer)CommonConfig.getInstance().teleportRailLogDivisionCost.get()).intValue());
        if ((calculatedCost += MathHelper.func_76128_c((double)(calculatedDistance *= calculatedDistance))) == 0) {
            return 1;
        }
        return calculatedCost;
    }

    public void teleport(BlockPos pos, AbstractMinecartEntity cart) {
        Entity entity;
        this.checkCost();
        cart.func_213293_j(0.0, 0.0, 0.0);
        Entity entity2 = entity = cart.func_184188_bt().isEmpty() ? null : (Entity)cart.func_184188_bt().get(0);
        if (this.fuel < this.cost) {
            if (entity instanceof PlayerEntity) {
                ((PlayerEntity)entity).func_146105_b((ITextComponent)new TranslationTextComponent("block.usefulrailroads.teleport_rail.not_enough_fuel", new Object[]{this.cost}).func_240699_a_(TextFormatting.RED), true);
            }
            return;
        }
        this.fuel -= this.cost;
        this.func_70296_d();
        ServerWorld teleportWorld = cart.func_184102_h().func_71218_a(this.location.getRegistryKey());
        if (teleportWorld == null) {
            return;
        }
        cart.func_184102_h().func_212871_a_((Runnable)new TickDelayedTask(0, () -> {
            Vector3d teleportPos = Vector3d.func_237489_a_((Vector3i)this.location.getPos());
            if (entity != null) {
                entity.func_213319_R();
                WorldUtil.teleportEntity((Entity)entity, (ServerWorld)teleportWorld, (double)teleportPos.func_82615_a(), (double)teleportPos.func_82617_b(), (double)teleportPos.func_82616_c(), (float)entity.field_70177_z, (float)entity.field_70125_A, (boolean)false);
            }
            WorldUtil.teleportEntity((Entity)cart, (ServerWorld)teleportWorld, (double)teleportPos.func_82615_a(), (double)teleportPos.func_82617_b(), (double)teleportPos.func_82616_c(), (float)cart.field_70177_z, (float)cart.field_70125_A, (boolean)false);
            if (entity != null) {
                entity.func_184205_a(teleportWorld.func_217461_a(cart.func_110124_au()), true);
            }
        }));
    }

    public void writeNBT(CompoundNBT compound) {
        compound.func_218657_a("location", (INBT)this.location.serializeNBT());
        if (this.fuel != 0) {
            compound.func_74768_a("fuel", this.fuel);
        }
    }

    public void readNBT(BlockState state, CompoundNBT compound) {
        this.location.deserializeNBT(compound.func_74775_l("location"));
        this.fuel = compound.func_74762_e("fuel");
    }

    public void sendInitialDataBuffer(PacketBuffer buffer) {
        this.checkCost();
        this.location.serialize(buffer);
        buffer.writeInt(this.fuel);
        buffer.writeInt(this.cost);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleInitialDataBuffer(PacketBuffer buffer) {
        this.location.deserialize(buffer);
        this.fuel = buffer.readInt();
        this.cost = buffer.readInt();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction direction) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && direction != Direction.UP) {
            return this.fuelSlotOptional.cast();
        }
        return super.getCapability(capability, direction);
    }

    public FuelItemHandler<TeleportRailFuelRecipe> getFuelSlot() {
        return this.fuelSlot;
    }

    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new TeleportRailContainer(id, playerInventory, this);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.usefulrailroads.teleport_rail");
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int fuel) {
        this.fuel = fuel;
    }

    public Location getLocation() {
        return this.location;
    }

    public int getCost() {
        return this.cost;
    }
}

