/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.entity;

import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.entity.IPlayerEventListener;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.lib.network.RequestPlayerUpdatePacket;
import de.teamlapen.lib.network.UpdateEntityPacket;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EntityEventHandler {
    private final Capability[] listeners;

    public EntityEventHandler(Capability[] listeners) {
        this.listeners = listeners;
    }

    @SubscribeEvent
    public void onChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        for (Capability listener : this.listeners) {
            ((IPlayerEventListener)event.player.getCapability(listener, null)).onChangedDimension(event.fromDim, event.toDim);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity().func_130014_f_().field_72995_K && event.getEntity() instanceof EntityPlayer && ((EntityPlayer)event.getEntity()).func_175144_cb() && HelperRegistry.getSyncablePlayerCaps().size() > 0) {
            VampLib.dispatcher.sendToServer(new RequestPlayerUpdatePacket());
        }
        if (event.getEntity() instanceof EntityPlayer) {
            for (Capability listener : this.listeners) {
                ((IPlayerEventListener)event.getEntity().getCapability(listener, null)).onJoinWorld();
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            for (Capability listener : this.listeners) {
                boolean cancel = ((IPlayerEventListener)event.getEntity().getCapability(listener, null)).onEntityAttacked(event.getSource(), event.getAmount());
                if (!cancel) continue;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            for (Capability listener : this.listeners) {
                ((IPlayerEventListener)event.getEntity().getCapability(listener, null)).onDeath(event.getSource());
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            for (Capability listener : this.listeners) {
                ((IPlayerEventListener)event.getEntity().getCapability(listener, null)).onUpdate();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        for (Capability listener : this.listeners) {
            ((IPlayerEventListener)event.getEntity().getCapability(listener, null)).onPlayerClone(event.getOriginal(), event.isWasDeath());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        for (Capability listener : this.listeners) {
            ((IPlayerEventListener)event.player.getCapability(listener, null)).onPlayerLoggedIn();
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        for (Capability listener : this.listeners) {
            ((IPlayerEventListener)event.player.getCapability(listener, null)).onPlayerLoggedOut();
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        for (Capability listener : this.listeners) {
            ((IPlayerEventListener)event.player.getCapability(listener, null)).onUpdatePlayer(event.phase);
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityCreature && HelperRegistry.getSyncableEntityCaps().size() > 0 || event.getTarget() instanceof ISyncable || event.getTarget() instanceof EntityPlayer && HelperRegistry.getSyncablePlayerCaps().size() > 0) {
            UpdateEntityPacket packet = UpdateEntityPacket.createJoinWorldPacket(event.getTarget());
            VampLib.dispatcher.sendTo(packet, (EntityPlayerMP)event.getEntityPlayer());
        }
    }
}

