/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import de.teamlapen.lib.VampLib;
import de.teamlapen.vampirism.VampirismMod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UtilLib {
    public static String entityToString(Entity e) {
        if (e == null) {
            return "Entity is null";
        }
        return e.toString();
    }

    public static boolean doesBlockHaveSolidTopSurface(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawTexturedModalRect(float zLevel, int x, int y, int textureX, int textureY, int width, int height, int texWidth, int texHeight) {
        float f = 1.0f / (float)texWidth;
        float f1 = 1.0f / (float)texHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)x, (double)(y + height), (double)zLevel).func_187315_a((double)((float)textureX * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)y, (double)zLevel).func_187315_a((double)((float)(textureX + width) * f), (double)((float)textureY * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a((double)((float)textureX * f), (double)((float)textureY * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static RayTraceResult getPlayerLookingSpot(EntityPlayer player, double restriction) {
        float scale = 1.0f;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * scale;
        float yaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * scale;
        double x = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)scale;
        double y = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)scale + 1.62;
        double z = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)scale;
        Vec3d vector1 = new Vec3d(x, y, z);
        float cosYaw = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float cosPitch = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float sinPitch = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float pitchAdjustedSinYaw = sinYaw * cosPitch;
        float pitchAdjustedCosYaw = cosYaw * cosPitch;
        double distance = 500.0;
        if (restriction == 0.0 && player instanceof EntityPlayerMP) {
            distance = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        } else if (restriction > 0.0) {
            distance = restriction;
        }
        Vec3d vector2 = vector1.func_72441_c((double)pitchAdjustedSinYaw * distance, (double)sinPitch * distance, (double)pitchAdjustedCosYaw * distance);
        return player.func_130014_f_().func_72933_a(vector1, vector2);
    }

    public static BlockPos getRandomPosInBox(World w, AxisAlignedBB box) {
        int x = (int)box.field_72340_a + w.field_73012_v.nextInt((int)(box.field_72336_d - box.field_72340_a) + 1);
        int z = (int)box.field_72339_c + w.field_73012_v.nextInt((int)(box.field_72334_f - box.field_72339_c) + 1);
        int y = w.func_189649_b(x, z) + 5;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        while ((double)y > box.field_72338_b && !w.func_180495_p((BlockPos)pos).func_185915_l()) {
            pos.func_181079_c(x, --y, z);
        }
        if ((double)y < box.field_72338_b || (double)y > box.field_72337_e - 1.0) {
            pos.func_181079_c(x, (int)box.field_72338_b + w.field_73012_v.nextInt((int)(box.field_72337_e - box.field_72338_b) + 1), z);
        }
        return pos.func_177984_a();
    }

    public static int countPlayerLoadedChunks(World world) {
        ArrayList chunks = Lists.newArrayList();
        int i = 0;
        for (EntityPlayer entityplayer : world.field_73010_i) {
            if (entityplayer.func_175149_v()) continue;
            int x = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
            int z = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
            for (int dx = -8; dx <= 8; ++dx) {
                for (int dz = -8; dz <= 8; ++dz) {
                    ChunkPos chunkpos = new ChunkPos(dx + x, dz + z);
                    if (chunks.contains(chunkpos)) continue;
                    ++i;
                    chunks.add(chunkpos);
                }
            }
        }
        return i;
    }

    @Nonnull
    public static Vec3d getItemPosition(EntityLivingBase entity, boolean mainHand) {
        boolean left = (mainHand ? entity.func_184591_cq() : entity.func_184591_cq().func_188468_a()) == EnumHandSide.LEFT;
        boolean firstPerson = entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175144_cb() && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0;
        Vec3d dir = firstPerson ? entity.func_189651_aD() : Vec3d.func_189984_a((Vec2f)new Vec2f(entity.field_70125_A, entity.field_70761_aq));
        dir = dir.func_178785_b(0.62831855f * (left ? 1.0f : -1.0f)).func_186678_a(0.75);
        return dir.func_72441_c(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
    }

    public static Entity spawnEntityBehindEntity(EntityLivingBase p, ResourceLocation id) {
        BlockPos behind = UtilLib.getPositionBehindEntity(p, 2.0f);
        EntityLiving e = (EntityLiving)EntityList.func_188429_b((ResourceLocation)id, (World)p.func_130014_f_());
        e.func_70107_b((double)behind.func_177958_n(), p.field_70163_u, (double)behind.func_177952_p());
        if (e.func_70601_bi() && e.func_70058_J()) {
            p.func_130014_f_().func_72838_d((Entity)e);
            return e;
        }
        int y = p.func_130014_f_().func_175645_m(behind).func_177956_o();
        e.func_70107_b((double)behind.func_177958_n(), (double)y, (double)behind.func_177952_p());
        if (e.func_70601_bi() && e.func_70058_J()) {
            p.func_130014_f_().func_72838_d((Entity)e);
            UtilLib.onInitialSpawn((Entity)e);
            return e;
        }
        e.func_70106_y();
        return null;
    }

    private static void onInitialSpawn(Entity e) {
        if (e instanceof EntityLiving) {
            ((EntityLiving)e).func_180482_a(e.func_130014_f_().func_175649_E(e.func_180425_c()), null);
        }
    }

    public static BlockPos getPositionBehindEntity(EntityLivingBase p, float distance) {
        float yaw = p.field_70759_as;
        float cosYaw = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        double x = p.field_70165_t + (double)(sinYaw * distance);
        double z = p.field_70161_v + (double)(cosYaw * distance);
        return new BlockPos(x, p.field_70163_u, z);
    }

    public static boolean spawnEntityInWorld(World world, AxisAlignedBB box, Entity e, int maxTry, @Nonnull List<EntityLivingBase> avoidedEntities) {
        if (!world.func_175663_a((int)box.field_72340_a, (int)box.field_72338_b, (int)box.field_72339_c, (int)box.field_72336_d, (int)box.field_72337_e, (int)box.field_72334_f, true)) {
            return false;
        }
        boolean flag = false;
        int i = 0;
        BlockPos backupPos = null;
        while (!flag && i++ < maxTry) {
            BlockPos c = UtilLib.getRandomPosInBox(world, box);
            if (!world.func_175697_a(c, 5) || !WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntitySpawnPlacementRegistry.func_180109_a(e.getClass()), (World)world, (BlockPos)c)) continue;
            e.func_70107_b((double)c.func_177958_n(), (double)c.func_177956_o() + 0.2, (double)c.func_177952_p());
            if (e instanceof EntityLiving && (!((EntityLiving)e).func_70601_bi() || !((EntityLiving)e).func_70058_J())) continue;
            backupPos = c;
            for (EntityLivingBase p : avoidedEntities) {
                if (p.func_70068_e(e) < 500.0 && p.func_70685_l(e)) continue;
                flag = true;
            }
        }
        if (!flag && backupPos != null) {
            e.func_70107_b((double)backupPos.func_177958_n(), (double)backupPos.func_177956_o() + 0.2, (double)backupPos.func_177952_p());
            flag = true;
        }
        if (flag) {
            world.func_72838_d(e);
            UtilLib.onInitialSpawn(e);
            return true;
        }
        return false;
    }

    @Nullable
    public static Entity spawnEntityInWorld(World world, AxisAlignedBB box, ResourceLocation id, int maxTry, @Nonnull List<EntityLivingBase> avoidedEntities) {
        Entity e = EntityList.func_188429_b((ResourceLocation)id, (World)world);
        if (UtilLib.spawnEntityInWorld(world, box, e, maxTry, avoidedEntities)) {
            return e;
        }
        if (e != null) {
            e.func_70106_y();
        }
        return null;
    }

    public static boolean teleportTo(EntityLiving entity, double x, double y, double z, boolean sound) {
        double d3 = entity.field_70165_t;
        double d4 = entity.field_70163_u;
        double d5 = entity.field_70161_v;
        entity.field_70165_t = x;
        entity.field_70163_u = y;
        entity.field_70161_v = z;
        boolean flag = false;
        BlockPos blockPos = entity.func_180425_c();
        if (entity.func_130014_f_().func_175667_e(blockPos)) {
            boolean flag1 = false;
            while (!flag1 && blockPos.func_177956_o() > 0) {
                IBlockState blockState = entity.func_130014_f_().func_180495_p(blockPos.func_177977_b());
                if (blockState.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                entity.field_70163_u -= 1.0;
                blockPos = blockPos.func_177977_b();
            }
            if (flag1) {
                entity.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (entity.func_130014_f_().func_184143_b(entity.func_174813_aQ()) && !entity.func_130014_f_().func_72953_d(entity.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            entity.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (entity.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            float f1 = (entity.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            float f2 = (entity.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (entity.field_70165_t - d3) * d6 + (entity.func_70681_au().nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            double d8 = d4 + (entity.field_70163_u - d4) * d6 + entity.func_70681_au().nextDouble() * (double)entity.field_70131_O;
            double d9 = d5 + (entity.field_70161_v - d5) * d6 + (entity.func_70681_au().nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            entity.func_130014_f_().func_175688_a(EnumParticleTypes.PORTAL, d7, d8, d9, (double)f, (double)f1, (double)f2, new int[0]);
        }
        if (sound) {
            entity.func_130014_f_().func_184134_a(d3, d4, d5, SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
            entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return true;
    }

    public static void spawnParticles(World world, EnumParticleTypes particleType, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int amount, float maxOffset, int ... extra) {
        double x = xCoord;
        double y = yCoord;
        double z = zCoord;
        for (int i = 0; i < amount; ++i) {
            world.func_175688_a(particleType, x, y, z, xSpeed, ySpeed, zSpeed, extra);
            Random ran = world.field_73012_v;
            x = xCoord + ran.nextGaussian() * (double)maxOffset;
            y = yCoord + ran.nextGaussian() * (double)maxOffset;
            z = zCoord + ran.nextGaussian() * (double)maxOffset;
        }
    }

    public static void spawnParticlesAroundEntity(EntityLivingBase e, EnumParticleTypes particleType, double maxDistance, int amount) {
        int short1 = amount;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0) - 0.5;
            float f = (e.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            float f1 = (e.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            float f2 = (e.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            double d7 = e.field_70165_t + maxDistance * d6 + (e.func_70681_au().nextDouble() - 0.5) * (double)e.field_70130_N * 2.0;
            double d8 = e.field_70163_u + maxDistance / 2.0 * d6 + e.func_70681_au().nextDouble() * (double)e.field_70131_O;
            double d9 = e.field_70161_v + maxDistance * d6 + (e.func_70681_au().nextDouble() - 0.5) * (double)e.field_70130_N * 2.0;
            e.func_130014_f_().func_175688_a(particleType, d7, d8, d9, (double)f, (double)f1, (double)f2, new int[0]);
        }
    }

    public static void sendMessageToAllExcept(EntityPlayer player, ITextComponent message) {
        for (Object o : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            if (o.equals(player)) continue;
            ((EntityPlayer)o).func_145747_a(message);
        }
    }

    public static void sendMessageToAll(ITextComponent message) {
        UtilLib.sendMessageToAllExcept(null, message);
    }

    public static boolean canReallySee(EntityLivingBase entity, EntityLivingBase target, boolean alsoRaytrace) {
        if (alsoRaytrace && !entity.func_70685_l((Entity)target)) {
            return false;
        }
        Vec3d look1 = new Vec3d(-Math.sin((double)(entity.field_70759_as / 180.0f) * Math.PI), 0.0, Math.cos((double)(entity.field_70759_as / 180.0f) * Math.PI));
        Vec3d dist = new Vec3d(target.field_70165_t - entity.field_70165_t, 0.0, target.field_70161_v - entity.field_70161_v);
        double alpha = Math.acos((look1 = look1.func_72432_b()).func_72430_b(dist = dist.func_72432_b()));
        return alpha < 1.7453292519943295;
    }

    @Nonnull
    public static <T> T getNull() {
        return null;
    }

    public static void write(NBTTagCompound nbt, String base, BlockPos pos) {
        nbt.func_74768_a(base + "_x", pos.func_177958_n());
        nbt.func_74768_a(base + "_y", pos.func_177956_o());
        nbt.func_74768_a(base + "_z", pos.func_177952_p());
    }

    public static BlockPos readPos(NBTTagCompound nbt, String base) {
        return new BlockPos(nbt.func_74762_e(base + "_x"), nbt.func_74762_e(base + "_y"), nbt.func_74762_e(base + "_z"));
    }

    public static String[] prefix(String prefix, String ... strings) {
        String[] result = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            result[i] = prefix + strings[i];
        }
        return result;
    }

    public static Predicate getPredicateForClass(Class clazz) {
        return clazz::isInstance;
    }

    public static AxisAlignedBB createBB(BlockPos center, int distance, boolean fullY) {
        return new AxisAlignedBB((double)(center.func_177958_n() - distance), fullY ? 0.0 : (double)(center.func_177956_o() - distance), (double)(center.func_177952_p() - distance), (double)(center.func_177958_n() + distance), fullY ? 256.0 : (double)(center.func_177956_o() + distance), (double)(center.func_177952_p() + distance));
    }

    public static boolean isNonNull(Object ... objects) {
        for (Object o : objects) {
            if (o != null) continue;
            return false;
        }
        return true;
    }

    private static ChunkPos isBiomeAt(World world, int x, int z, List<Biome> biomes) {
        BlockPos pos = world.func_72959_q().func_180630_a(x, z, 32, biomes, new Random());
        if (pos != null) {
            return new ChunkPos(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        }
        return null;
    }

    public static ChunkPos findNearBiome(World world, BlockPos center, int maxDist, List<Biome> biomes, ICommandSender listener) {
        long start = System.currentTimeMillis();
        maxDist = maxDist / 20 * 20;
        long maxop = ((long)maxDist * (long)maxDist + (long)maxDist) / 2L;
        for (int i = 0; i < maxDist; i += 4) {
            ChunkPos loc;
            int cz;
            int cx = -i;
            for (cz = -i; cz <= i; ++cz) {
                if (cz % 4 != 0) continue;
                loc = UtilLib.isBiomeAt(world, center.func_177958_n() + (cx << 4), center.func_177952_p() + (cz << 4), biomes);
                if (loc != null) {
                    VampLib.log.d("UtilLib", "Took %d ms to find a vampire biome %d %d", (int)(System.currentTimeMillis() - start), loc.field_77276_a, loc.field_77275_b);
                    return loc;
                }
                if (cz != i || cx >= 0) continue;
                cz = -i;
                cx = i;
            }
            cz = -i;
            for (int cx2 = -i + 1; cx2 < i; ++cx2) {
                if (cx2 % 4 != 0) continue;
                loc = UtilLib.isBiomeAt(world, center.func_177958_n() + (cx2 << 4), center.func_177952_p() + (cz << 4), biomes);
                if (loc != null) {
                    VampLib.log.d("UtilLib", "Took %d ms to find a vampire biome %d %d", (int)(System.currentTimeMillis() - start), loc.field_77276_a, loc.field_77275_b);
                    return loc;
                }
                if (cx != i - 1 || cz >= 0) continue;
                cz = i;
                cx = i - 1;
            }
            if (listener == null || i * 10 % maxDist != 0) continue;
            long op = ((long)i * (long)i + (long)i) / 2L;
            double perc = (double)op / (double)maxop * 100.0;
            VampirismMod.log.i("UtilLib", "Search %s percent finished", (int)perc);
        }
        VampLib.log.d("UtilLib", "Took %d ms to not find a vampire biome", (int)(System.currentTimeMillis() - start));
        return null;
    }

    public static boolean isPlayerOp(EntityPlayer player) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH()) != null;
    }

    public static boolean isSameInstanceAsServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance() != null;
    }

    public static String translate(String key) {
        if (I18n.func_94522_b((String)key)) {
            return I18n.func_74838_a((String)key);
        }
        return I18n.func_150826_b((String)key);
    }

    public static String translateFormatted(String key, Object ... format) {
        String s = UtilLib.translate(key);
        try {
            return String.format(s, format);
        }
        catch (IllegalFormatException e) {
            VampLib.log.e("Translate", e, "Formatting Error for %s and arguments(%s)", key, format);
            return "Formatting Error: " + e.getMessage();
        }
    }

    public static String aiTaskListToStringDebug(EntityAITasks tasks) {
        Collection c = (Collection)ReflectionHelper.getPrivateValue(EntityAITasks.class, (Object)tasks, (String[])new String[]{"executingTaskEntries"});
        Iterator var1 = c.iterator();
        if (!var1.hasNext()) {
            return "[]";
        }
        StringBuilder var2 = new StringBuilder();
        var2.append('[');
        while (true) {
            Object var3;
            var2.append((Object)((var3 = var1.next()) == c ? "(this Collection)" : ((EntityAITasks.EntityAITaskEntry)var3).field_75733_a));
            if (!var1.hasNext()) {
                return var2.append(']').toString();
            }
            var2.append(',').append(' ');
        }
    }

    public static NBTTagCompound checkNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static float[] getColorComponents(int color) {
        int i = (color & 0xFF0000) >> 16;
        int j = (color & 0xFF00) >> 8;
        int k = color & 0xFF;
        return new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
    }

    @Nonnull
    public static int[] bbToInt(@Nonnull AxisAlignedBB bb) {
        return new int[]{(int)bb.field_72340_a, (int)bb.field_72338_b, (int)bb.field_72339_c, (int)bb.field_72336_d, (int)bb.field_72337_e, (int)bb.field_72334_f};
    }

    @Nonnull
    public static AxisAlignedBB intToBB(int[] array) {
        return new AxisAlignedBB((double)array[0], (double)array[1], (double)array[2], (double)array[3], (double)array[4], (double)array[5]);
    }
}

