/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.event;

import de.teamlapen.vampirism.api.entity.IVillageCaptureEntity;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.world.IVampirismVillage;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class VampirismVillageEvent
extends Event {
    @Nullable
    private final IVampirismVillage village;

    public VampirismVillageEvent(@Nullable IVampirismVillage village) {
        this.village = village;
    }

    @Nullable
    public IVampirismVillage getVillage() {
        return this.village;
    }

    public static class UpdateBoundingBox
    extends VampirismVillageEvent {
        @Nonnull
        private final StructureBoundingBox bb;

        public UpdateBoundingBox(@Nullable IVampirismVillage village, @Nonnull StructureBoundingBox bb) {
            super(village);
            this.bb = bb;
        }

        @Nonnull
        public StructureBoundingBox getBoundingBox() {
            return this.bb;
        }
    }

    @Event.HasResult
    public static class InitiateCapture
    extends VampirismVillageEvent {
        @Nonnull
        private final World world;
        @Nullable
        private final IPlayableFaction<?> controllingFaction;
        @Nonnull
        private final IPlayableFaction<?> capturingFaction;

        public InitiateCapture(@Nonnull IVampirismVillage village, @Nonnull World world, @Nullable IPlayableFaction<?> controllingFaction, @Nonnull IPlayableFaction<?> capturingFaction) {
            super(village);
            this.world = world;
            this.controllingFaction = controllingFaction;
            this.capturingFaction = capturingFaction;
        }

        @Nonnull
        public World getWorld() {
            return this.world;
        }

        @Nullable
        public IPlayableFaction<?> getControllingFaction() {
            return this.controllingFaction;
        }

        @Nonnull
        public IPlayableFaction<?> getCapturingFaction() {
            return this.capturingFaction;
        }

        @Override
        @Nonnull
        public IVampirismVillage getVillage() {
            return super.getVillage();
        }
    }

    public static class ReplaceBlock
    extends VampirismVillageEvent {
        @Nonnull
        private final World world;
        @Nonnull
        private final IBlockState state;
        @Nonnull
        private final IPlayableFaction<?> faction;
        @Nonnull
        private final BlockPos pos;

        public ReplaceBlock(@Nullable IVampirismVillage village, @Nonnull World world, @Nonnull IBlockState b, @Nonnull BlockPos pos, @Nonnull IPlayableFaction<?> controllingFaction) {
            super(village);
            this.world = world;
            this.state = b;
            this.faction = controllingFaction;
            this.pos = pos;
        }

        @Nonnull
        public World getWorld() {
            return this.world;
        }

        @Nonnull
        public IBlockState getState() {
            return this.state;
        }

        @Nonnull
        public IPlayableFaction<?> getFaction() {
            return this.faction;
        }

        @Nonnull
        public BlockPos getBlockPos() {
            return this.pos;
        }
    }

    public static class SpawnFactionVillager
    extends VampirismVillageEvent {
        @Nonnull
        private final IPlayableFaction<?> faction;
        @Nonnull
        private final EntityVillager seed;
        private EntityVillager newVillager;
        private boolean poisonousBlood;

        public SpawnFactionVillager(@Nullable IVampirismVillage village, @Nonnull EntityVillager seed, @Nonnull IPlayableFaction<?> faction) {
            super(village);
            this.faction = faction;
            this.seed = seed;
        }

        @Nonnull
        public IPlayableFaction<?> getFaction() {
            return this.faction;
        }

        @Nonnull
        public EntityVillager getSeed() {
            return this.seed;
        }

        @Nullable
        public EntityVillager getVillager() {
            return this.newVillager;
        }

        public void setVillager(EntityVillager villager) {
            this.newVillager = villager;
        }

        public boolean hasPoisonousBlood() {
            return this.poisonousBlood;
        }

        public void setPoisonousBlood(boolean poisonous) {
            this.poisonousBlood = poisonous;
        }
    }

    public static class SpawnCaptureEntity
    extends VampirismVillageEvent {
        @Nonnull
        private final IFaction<?> faction;
        private ResourceLocation entity;

        public SpawnCaptureEntity(@Nullable IVampirismVillage village, @Nonnull IFaction<?> f) {
            super(village);
            this.faction = f;
        }

        @Nonnull
        public IFaction<?> getFaction() {
            return this.faction;
        }

        public void setEntity(ResourceLocation entity) {
            this.entity = entity;
        }

        @Nullable
        public ResourceLocation getEntity() {
            return this.entity;
        }
    }

    @Event.HasResult
    public static class VillagerCaptureFinish
    extends VampirismVillageEvent {
        @Nonnull
        private final List<EntityVillager> villager;
        @Nullable
        private final IPlayableFaction<?> controllingFaction;
        @Nonnull
        private final IPlayableFaction<?> capturingFaction;
        @Nonnull
        private final AxisAlignedBB affectedArea;

        public VillagerCaptureFinish(@Nonnull IVampirismVillage village, @Nonnull List<EntityVillager> villagerIn, @Nullable IPlayableFaction<?> controllingFactionIn, @Nonnull IPlayableFaction<?> capturingFactionIn, @Nonnull AxisAlignedBB affectedAreaIn) {
            super(village);
            this.villager = villagerIn;
            this.controllingFaction = controllingFactionIn;
            this.capturingFaction = capturingFactionIn;
            this.affectedArea = affectedAreaIn;
        }

        @Nonnull
        public List<EntityVillager> getVillager() {
            return this.villager;
        }

        @Nullable
        public IPlayableFaction<?> getControllingFaction() {
            return this.controllingFaction;
        }

        @Nonnull
        public IPlayableFaction<?> getCapturingFaction() {
            return this.capturingFaction;
        }

        @Nonnull
        public AxisAlignedBB getAffectedArea() {
            return this.affectedArea;
        }

        @Override
        @Nonnull
        public IVampirismVillage getVillage() {
            return super.getVillage();
        }
    }

    @Cancelable
    public static class MakeAggressive
    extends VampirismVillageEvent {
        private final EntityVillager oldVillager;
        @Nullable
        private IVillageCaptureEntity captureVillager;

        public MakeAggressive(@Nullable IVampirismVillage village, @Nonnull EntityVillager villager) {
            super(village);
            this.oldVillager = villager;
        }

        @Nullable
        public IVillageCaptureEntity getAggressiveVillager() {
            return this.captureVillager;
        }

        public EntityVillager getOldVillager() {
            return this.oldVillager;
        }

        public void setAgressiveVillager(@Nullable IVillageCaptureEntity captureVillager) {
            if (captureVillager != null && !(captureVillager instanceof EntityVillager)) {
                throw new IllegalArgumentException("Aggressive villager must be a instanceof EntityVillager");
            }
            this.captureVillager = captureVillager;
        }
    }

    @Event.HasResult
    public static class SpawnNewVillager
    extends VampirismVillageEvent {
        @Nonnull
        private final EntityVillager seedVillager;
        @Nullable
        private EntityVillager newVillager;
        private boolean willBeConverted;
        private final IPlayableFaction<?> faction;

        public SpawnNewVillager(@Nonnull IVampirismVillage village, @Nonnull EntityVillager seedVillager, boolean willBeConverted, IPlayableFaction<?> faction) {
            super(village);
            this.seedVillager = seedVillager;
            this.willBeConverted = willBeConverted;
            this.faction = faction;
        }

        public EntityVillager getNewVillager() {
            return this.newVillager;
        }

        public void setNewVillager(EntityVillager newVillager) {
            this.newVillager = newVillager;
        }

        @Nonnull
        public EntityVillager getSeedVillager() {
            return this.seedVillager;
        }

        public boolean isWillBeConverted() {
            return this.willBeConverted;
        }

        public void setWillBeConverted(boolean willBeConverted) {
            this.willBeConverted = willBeConverted;
        }

        public IPlayableFaction<?> getFaction() {
            return this.faction;
        }
    }
}

