/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.general;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BloodConversionRegistry {
    private static final Map<ResourceLocation, Integer> blood_items = new HashMap<ResourceLocation, Integer>();
    private static final Map<ResourceLocation, Function<ItemStack, Integer>> blood_item_special = new HashMap<ResourceLocation, Function<ItemStack, Integer>>();
    private static final Map<String, Float> fluids = new HashMap<String, Float>();

    public static int getImpureBloodValue(@Nonnull ItemStack item) {
        if (blood_item_special.containsKey(item.func_77973_b().getRegistryName())) {
            return blood_item_special.get(item.func_77973_b().getRegistryName()).apply(item);
        }
        if (blood_items.containsKey(item.func_77973_b().getRegistryName())) {
            return blood_items.get(item.func_77973_b().getRegistryName());
        }
        return 0;
    }

    public static float getFluidBloodConversionFactor(String fluidname) {
        if (fluids.containsKey(fluidname)) {
            return fluids.get(fluidname).floatValue();
        }
        return 0.0f;
    }

    public static int getFluidBloodEquivalent(String fluid, int amount) {
        return (int)(BloodConversionRegistry.getFluidBloodConversionFactor(fluid) * (float)amount);
    }

    @Nullable
    public static FluidStack getFluidBloodEquivalent(FluidStack fluidStack) {
        String name = fluidStack.getFluid().getName();
        int conv = BloodConversionRegistry.getFluidBloodEquivalent(name, fluidStack.amount);
        if (conv == 0) {
            return null;
        }
        return new FluidStack(FluidRegistry.getFluid((String)"vampirismblood"), conv);
    }

    public static void registerFluidConversionRatio(String fluidname, float ratio) {
        fluids.put(fluidname, Float.valueOf(ratio));
    }

    public static void registerItem(ResourceLocation itemId, int amount) {
        blood_items.put(itemId, amount);
    }

    public static void registerItem(ResourceLocation itemId, Function<ItemStack, Integer> function) {
        blood_item_special.put(itemId, function);
    }
}

