/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.blocks.VampirismBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class BlockWeaponTable
extends VampirismBlock {
    public static final String regName = "weapon_table";
    public static final int MAX_LAVA = 5;
    public static final int MB_PER_META = 200;
    public static final PropertyInteger LAVA = PropertyInteger.func_177719_a((String)"lava", (int)0, (int)5);
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 0.93, 0.6, 1.0);

    public BlockWeaponTable() {
        super(regName, Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LAVA, (Comparable)Integer.valueOf(0)));
        this.func_149711_c(3.0f);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAVA);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)ModBlocks.weapon_table), 1);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LAVA, (Comparable)Integer.valueOf(meta));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            IFluidHandlerItem fluidHandler;
            int lava = (Integer)state.func_177229_b((IProperty)LAVA);
            boolean flag = false;
            ItemStack heldItem = playerIn.func_184586_b(hand);
            if (lava < 5 && (fluidHandler = FluidUtil.getFluidHandler((ItemStack)heldItem)) != null) {
                FluidStack drained;
                FluidStack missing = new FluidStack(FluidRegistry.LAVA, (5 - lava) * 200);
                FluidStack drainable = fluidHandler.drain(missing, false);
                if (drainable == null) {
                    missing.amount = 1000;
                    drainable = fluidHandler.drain(missing, false);
                }
                if (drainable != null && drainable.amount >= 200 && (drained = fluidHandler.drain(missing, true)) != null) {
                    IBlockState changed = state.func_177226_a((IProperty)LAVA, (Comparable)Integer.valueOf(Math.min(5, lava + drained.amount / 200)));
                    worldIn.func_175656_a(pos, changed);
                    flag = true;
                    playerIn.func_184611_a(hand, fluidHandler.getContainer());
                }
            }
            if (!flag) {
                if (this.canUse(playerIn)) {
                    playerIn.openGui((Object)VampirismMod.instance, 6, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                } else {
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("tile.vampirism.weapon_table.cannot_use", new Object[0]));
                }
            }
        }
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LAVA});
    }

    private boolean canUse(EntityPlayer player) {
        IPlayableFaction faction = FactionPlayerHandler.get(player).getCurrentFaction();
        if (faction != null && faction.equals(VReference.HUNTER_FACTION)) {
            return faction.getPlayerCapability(player).getSkillHandler().isSkillEnabled(HunterSkills.weapon_table);
        }
        return false;
    }
}

