/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.core;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.network.InputEventPacket;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModKeys {
    private static final String CATEGORY = "keys.vampirism.category";
    private static final String SUCK_BLOOD = "keys.vampirism.suck";
    private static final String TOGGLE_ACTIONS = "keys.vampirism.action";
    private static final String SELECT_SKILLS = "keys.vampirism.select_skills";
    private static final String SWITCH_VISION = "keys.vampirism.vision";
    private static final String BLOOD_POTION_CRAFTING = "keys.vampirism.blood_potion_crafting";
    private static final String ACTIVATE_ACTION1 = "keys.vampirism.action1";
    private static final String ACTIVATE_ACTION2 = "keys.vampirism.action2";
    private static KeyBinding SUCK = new KeyBinding("keys.vampirism.suck", (IKeyConflictContext)KeyConflictContext.IN_GAME, 47, "keys.vampirism.category");
    private static KeyBinding ACTION = new KeyBinding("keys.vampirism.action", 19, "keys.vampirism.category");
    private static KeyBinding SKILL = new KeyBinding("keys.vampirism.select_skills", 25, "keys.vampirism.category");
    private static KeyBinding VISION = new KeyBinding("keys.vampirism.vision", (IKeyConflictContext)KeyConflictContext.IN_GAME, 49, "keys.vampirism.category");
    private static KeyBinding BLOOD_POTION = new KeyBinding("keys.vampirism.blood_potion_crafting", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, 48, "keys.vampirism.category");
    private static KeyBinding ACTION1 = new KeyBinding("keys.vampirism.action1", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, 2, "keys.vampirism.category");
    private static KeyBinding ACTION2 = new KeyBinding("keys.vampirism.action2", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, 3, "keys.vampirism.category");
    private boolean suckKeyDown = false;

    @Nonnull
    public static KeyBinding getKeyBinding(@Nonnull KEY key) {
        assert (key != null);
        switch (key) {
            case SUCK: {
                return SUCK;
            }
            case ACTION: {
                return ACTION;
            }
            case SKILL: {
                return SKILL;
            }
            case VISION: {
                return VISION;
            }
            case BLOOD_POTION: {
                return BLOOD_POTION;
            }
            case ACTION1: {
                return ACTION1;
            }
            case ACTION2: {
                return ACTION2;
            }
        }
        VampirismMod.log.e("ModKeys", "Keybinding %s does not exist", new Object[]{key});
        return ACTION;
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new ModKeys());
        ClientRegistry.registerKeyBinding((KeyBinding)ACTION);
        ClientRegistry.registerKeyBinding((KeyBinding)SUCK);
        ClientRegistry.registerKeyBinding((KeyBinding)SKILL);
        ClientRegistry.registerKeyBinding((KeyBinding)VISION);
        ClientRegistry.registerKeyBinding((KeyBinding)BLOOD_POTION);
        ClientRegistry.registerKeyBinding((KeyBinding)ACTION1);
        ClientRegistry.registerKeyBinding((KeyBinding)ACTION2);
    }

    private ModKeys() {
    }

    @SubscribeEvent
    public void handleInputEvent(InputEvent event) {
        KEY keyPressed = this.getPressedKeyBinding();
        if (!this.suckKeyDown && keyPressed == KEY.SUCK) {
            RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
            this.suckKeyDown = true;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (mouseOver != null && !player.func_175149_v() && FactionPlayerHandler.get((EntityPlayer)player).isInFaction(VReference.VAMPIRE_FACTION) && !VampirePlayer.get((EntityPlayer)player).getActionHandler().isActionActive(VampireActions.bat)) {
                if (mouseOver.field_72308_g != null) {
                    VampirismMod.dispatcher.sendToServer(new InputEventPacket("sb", "" + mouseOver.field_72308_g.func_145782_y()));
                } else if (mouseOver.field_72313_a == RayTraceResult.Type.BLOCK) {
                    BlockPos pos = mouseOver.func_178782_a();
                    VampirismMod.dispatcher.sendToServer(new InputEventPacket("db", "" + pos.func_177958_n() + ":" + pos.func_177956_o() + ":" + pos.func_177952_p()));
                } else {
                    VampirismMod.dispatcher.sendToServer(new InputEventPacket("sb", "-1"));
                }
            }
        } else if (keyPressed == KEY.ACTION) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (FactionPlayerHandler.get((EntityPlayer)player).getCurrentFaction() != null) {
                player.openGui((Object)VampirismMod.instance, 0, player.func_130014_f_(), player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p());
            }
        } else if (keyPressed == KEY.SKILL) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (FactionPlayerHandler.get((EntityPlayer)player).getCurrentFaction() != null) {
                player.openGui((Object)VampirismMod.instance, 1, player.func_130014_f_(), player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p());
            }
        } else if (keyPressed == KEY.VISION) {
            VampirismMod.dispatcher.sendToServer(new InputEventPacket("vvt", ""));
        } else if (keyPressed == KEY.BLOOD_POTION) {
            VampirismMod.dispatcher.sendToServer(new InputEventPacket("ob", ""));
        } else if (keyPressed == KEY.ACTION1) {
            FactionPlayerHandler factionHandler = FactionPlayerHandler.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            this.toggleBoundAction(factionHandler.getCurrentFactionPlayer(), factionHandler.getBoundAction1());
        } else if (keyPressed == KEY.ACTION2) {
            FactionPlayerHandler factionHandler = FactionPlayerHandler.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            this.toggleBoundAction(factionHandler.getCurrentFactionPlayer(), factionHandler.getBoundAction2());
        }
        if (this.suckKeyDown && !GameSettings.func_100015_a((KeyBinding)SUCK)) {
            this.suckKeyDown = false;
            VampirismMod.dispatcher.sendToServer(new InputEventPacket("esb", ""));
        }
    }

    private KEY getPressedKeyBinding() {
        if (SUCK.func_151468_f()) {
            return KEY.SUCK;
        }
        if (ACTION.func_151468_f()) {
            return KEY.ACTION;
        }
        if (SKILL.func_151468_f()) {
            return KEY.SKILL;
        }
        if (VISION.func_151468_f()) {
            return KEY.VISION;
        }
        if (BLOOD_POTION.func_151468_f()) {
            return KEY.BLOOD_POTION;
        }
        if (ACTION1.func_151468_f()) {
            return KEY.ACTION1;
        }
        if (ACTION2.func_151468_f()) {
            return KEY.ACTION2;
        }
        return KEY.UNKNOWN;
    }

    private void toggleBoundAction(@Nullable IFactionPlayer player, @Nullable ResourceLocation key) {
        if (player != null) {
            if (key == null) {
                player.getRepresentingPlayer().func_146105_b((ITextComponent)new TextComponentTranslation("text.vampirism.action.not_bound", new Object[]{"/vampirism bind-action"}), true);
            } else {
                IAction action = (IAction)VampirismAPI.actionManager().getRegistry().getValue(key);
                if (action == null) {
                    VampirismMod.log.i("ModKeys", "Bound action %s not found", key);
                } else if (!action.getFaction().equals(player.getFaction())) {
                    player.getRepresentingPlayer().func_146105_b((ITextComponent)new TextComponentTranslation("text.vampirism.action.only_faction", new Object[]{UtilLib.translate(action.getFaction().getUnlocalizedName())}), true);
                } else {
                    VampirismMod.dispatcher.sendToServer(new InputEventPacket("ta", "" + key));
                }
            }
        }
    }

    public static enum KEY {
        SUCK,
        UNKNOWN,
        ACTION,
        SKILL,
        VISION,
        BLOOD_POTION,
        ACTION1,
        ACTION2;

    }
}

