/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render;

import de.teamlapen.lib.lib.client.render.RenderUtil;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerVampirePlayerHead
implements LayerRenderer<AbstractClientPlayer> {
    private final RenderPlayer playerRenderer;
    private final ResourceLocation[] eyeOverlays;
    private final ResourceLocation[] fangOverlays;

    public LayerVampirePlayerHead(RenderPlayer playerRendererIn) {
        int i;
        this.playerRenderer = playerRendererIn;
        this.eyeOverlays = new ResourceLocation[16];
        for (i = 0; i < this.eyeOverlays.length; ++i) {
            this.eyeOverlays[i] = new ResourceLocation("vampirism:textures/entity/vanilla/eyes" + i + ".png");
        }
        this.fangOverlays = new ResourceLocation[7];
        for (i = 0; i < this.fangOverlays.length; ++i) {
            this.fangOverlays[i] = new ResourceLocation("vampirism:textures/entity/vanilla/fangs" + i + ".png");
        }
    }

    public void doRenderLayer(AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (Configs.disable_vampireEyes) {
            return;
        }
        VampirePlayer vampirePlayer = VampirePlayer.get((EntityPlayer)player);
        if (vampirePlayer.getLevel() > 0 && !vampirePlayer.isDisguised() && !player.func_82150_aj()) {
            int eyeType = Math.max(0, Math.min(vampirePlayer.getEyeType(), this.eyeOverlays.length - 1));
            int fangType = Math.max(0, Math.min(vampirePlayer.getFangType(), this.fangOverlays.length - 1));
            GlStateManager.func_179094_E();
            if (player.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            this.playerRenderer.func_110776_a(this.fangOverlays[fangType]);
            this.playerRenderer.func_177087_b().field_78116_c.func_78785_a(scale);
            if (vampirePlayer.getGlowingEyes()) {
                RenderUtil.renderGlowing(this.playerRenderer, this.playerRenderer.func_177087_b().field_78116_c, this.eyeOverlays[eyeType], 240.0f, player, scale);
            } else {
                this.renderNormalEyes(eyeType, scale);
            }
            GlStateManager.func_179121_F();
        }
    }

    public boolean func_177142_b() {
        return true;
    }

    private void renderNormalEyes(int eyeType, float scale) {
        this.playerRenderer.func_110776_a(this.eyeOverlays[eyeType]);
        this.playerRenderer.func_177087_b().field_78116_c.func_78785_a(scale);
    }
}

