/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IVampirismEntityRegistry;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.entity.EntityAreaParticleCloud;
import de.teamlapen.vampirism.entity.EntityBlindingBat;
import de.teamlapen.vampirism.entity.EntityCrossbowArrow;
import de.teamlapen.vampirism.entity.EntityDarkBloodProjectile;
import de.teamlapen.vampirism.entity.EntityGhost;
import de.teamlapen.vampirism.entity.EntitySoulOrb;
import de.teamlapen.vampirism.entity.EntityThrowableItem;
import de.teamlapen.vampirism.entity.converted.EntityConvertedCreature;
import de.teamlapen.vampirism.entity.converted.EntityConvertedHorse;
import de.teamlapen.vampirism.entity.converted.EntityConvertedSheep;
import de.teamlapen.vampirism.entity.converted.EntityConvertedVillager;
import de.teamlapen.vampirism.entity.hunter.EntityAdvancedHunter;
import de.teamlapen.vampirism.entity.hunter.EntityAggressiveVillager;
import de.teamlapen.vampirism.entity.hunter.EntityBasicHunter;
import de.teamlapen.vampirism.entity.hunter.EntityHunterFactionVillager;
import de.teamlapen.vampirism.entity.hunter.EntityHunterTrainer;
import de.teamlapen.vampirism.entity.hunter.EntityHunterTrainerDummy;
import de.teamlapen.vampirism.entity.minions.vampire.EntityVampireMinionSaveable;
import de.teamlapen.vampirism.entity.special.EntityDraculaHalloween;
import de.teamlapen.vampirism.entity.vampire.EntityAdvancedVampire;
import de.teamlapen.vampirism.entity.vampire.EntityBasicVampire;
import de.teamlapen.vampirism.entity.vampire.EntityDummyBittenAnimal;
import de.teamlapen.vampirism.entity.vampire.EntityVampireBaron;
import de.teamlapen.vampirism.entity.vampire.EntityVampireFactionVillager;
import de.teamlapen.vampirism.util.REFERENCE;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModEntities {
    public static final String BASIC_HUNTER_NAME = "vampire_hunter";
    public static final String BASIC_VAMPIRE_NAME = "vampire";
    public static final String DRACULA_NAME = "dracula";
    public static final String GHOST_NAME = "ghost";
    public static final String VAMPIRE_BARON = "vampire_baron";
    public static final String VAMPIRE_MINION_REMOTE_NAME = "vampire_minion_r";
    public static final String VAMPIRE_MINION_SAVEABLE_NAME = "vampire_minion_s";
    public static final String DEAD_MOB_NAME = "dead_mob";
    public static final String BLINDING_BAT_NAME = "blinding_bat";
    public static final String DUMMY_CREATURE = "dummy_creature";
    public static final String PORTAL_GUARD = "portal_guard";
    public static final String CONVERTED_CREATURE = "converted_creature";
    public static final String CONVERTED_SHEEP = "converted_sheep";
    public static final String HUNTER_TRAINER = "hunter_trainer";
    public static final String ADVANCED_HUNTER = "advanced_hunter";
    public static final String ADVANCED_VAMPIRE = "advanced_vampire";
    public static final String CROSSBOW_ARROW = "crossbow_arrow";
    public static final String PARTICLE_CLOUD = "particle_cloud";
    public static final String THROWABLE_ITEM = "throwable_item";
    public static final String SPECIAL_DRACULA_HALLOWEEN = "special_dracula_halloween";
    public static final String DARK_BLOOD_PROJECTILE = "dark_blood_projectile";
    public static final String SOUL_ORB = "soul_orb";
    public static final String VILLAGER_HUNTER_FACTION = "villager_hunter_faction";
    public static final String VILLAGER_VAMPIRE_FACTION = "villager_vampire_faction";
    public static final String VILLAGER_ANGRY = "villager_angry";
    public static final String VILLAGER_CONVERTED = "villager_converted";
    public static final String HUNTER_TRAINER_DUMMY = "hunter_trainer_dummy";
    public static final String HORSE_CONVERTED = "converted_horse";
    public static final List<String> spawnableEntityNames = new ArrayList<String>();
    private static final Map<String, String> OLD_TO_NEW_MAP = Maps.newHashMap();
    private static int modEntityId = 0;

    static void registerCustomExtendedCreatures() {
        IVampirismEntityRegistry registry = VampirismAPI.entityRegistry();
    }

    static void registerConvertibles() {
        String base = "vampirism:textures/entity/vanilla/%s_overlay.png";
        IVampirismEntityRegistry registry = VampirismAPI.entityRegistry();
        registry.addConvertible(EntityCow.class, String.format(base, "cow"));
        registry.addConvertible(EntityPig.class, String.format(base, "pig"));
        registry.addConvertible(EntityOcelot.class, String.format(base, "cat"));
        registry.addConvertible(EntityHorse.class, String.format(base, "horse"), new EntityConvertedHorse.ConvertingHandler());
        registry.addConvertible(EntityPolarBear.class, String.format(base, "polarbear"));
        registry.addConvertible(EntityRabbit.class, String.format(base, "rabbit"));
        registry.addConvertible(EntitySheep.class, String.format(base, "sheep"), new EntityConvertedSheep.ConvertingHandler());
        registry.addConvertible(EntityVillager.class, null, new EntityConvertedVillager.ConvertingHandler());
        registry.addConvertible(EntityLlama.class, String.format(base, "llama"));
    }

    static void registerEntities(IForgeRegistry<EntityEntry> registry) {
        Biome[] biomes = ModEntities.getZombieBiomes();
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityBlindingBat.class, BLINDING_BAT_NAME, BLINDING_BAT_NAME, EntityLiving.SpawnPlacementType.IN_AIR, false).build());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityGhost.class, GHOST_NAME, GHOST_NAME, EntityLiving.SpawnPlacementType.ON_GROUND, true).build());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityConvertedCreature.class, CONVERTED_CREATURE, "converted.creature", EntityLiving.SpawnPlacementType.ON_GROUND, false).build());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityConvertedSheep.class, CONVERTED_SHEEP, "converted.sheep", EntityLiving.SpawnPlacementType.ON_GROUND, false).build());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityBasicHunter.class, BASIC_HUNTER_NAME, "vampireHunter", EntityLiving.SpawnPlacementType.ON_GROUND, true).build());
        EntityEntryBuilder<EntityBasicVampire> basicVampire = ModEntities.prepareEntityEntry(EntityBasicVampire.class, BASIC_VAMPIRE_NAME, BASIC_VAMPIRE_NAME, EntityLiving.SpawnPlacementType.ON_GROUND, true);
        ModEntities.addSpawn(basicVampire, EnumCreatureType.MONSTER, Balance.mobProps.VAMPIRE_SPAWN_CHANCE, 1, 2, biomes);
        registry.register((IForgeRegistryEntry)basicVampire.build());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityHunterTrainer.class, HUNTER_TRAINER, HUNTER_TRAINER, EntityLiving.SpawnPlacementType.ON_GROUND, true).build());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityAdvancedHunter.class, ADVANCED_HUNTER, ADVANCED_HUNTER, EntityLiving.SpawnPlacementType.ON_GROUND, true).build());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityVampireBaron.class, VAMPIRE_BARON, "vampireBaron", EntityLiving.SpawnPlacementType.ON_GROUND, true).build());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityVampireMinionSaveable.class, VAMPIRE_MINION_SAVEABLE_NAME, "vampireMinionS", EntityLiving.SpawnPlacementType.ON_GROUND, false).build());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityDummyBittenAnimal.class, DUMMY_CREATURE, DUMMY_CREATURE, EntityLiving.SpawnPlacementType.ON_GROUND, false).build());
        EntityEntryBuilder<EntityAdvancedVampire> advancedVampire = ModEntities.prepareEntityEntry(EntityAdvancedVampire.class, ADVANCED_VAMPIRE, ADVANCED_VAMPIRE, EntityLiving.SpawnPlacementType.ON_GROUND, true);
        ModEntities.addSpawn(advancedVampire, EnumCreatureType.MONSTER, Balance.mobProps.ADVANCED_VAMPIRE_SPAWN_PROBE, 1, 1, biomes);
        registry.register((IForgeRegistryEntry)advancedVampire.build());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityConvertedVillager.class, VILLAGER_CONVERTED, "converted.villager", EntityLiving.SpawnPlacementType.ON_GROUND, false).build());
        OLD_TO_NEW_MAP.put(new ResourceLocation("vampirism", "converted_villager").toString(), new ResourceLocation("vampirism", VILLAGER_CONVERTED).toString());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityAggressiveVillager.class, VILLAGER_ANGRY, "hunter_villager", EntityLiving.SpawnPlacementType.ON_GROUND, false).build());
        OLD_TO_NEW_MAP.put(new ResourceLocation("vampirism", "hunter_villager").toString(), new ResourceLocation("vampirism", VILLAGER_ANGRY).toString());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityCrossbowArrow.class, CROSSBOW_ARROW, CROSSBOW_ARROW, EntityLiving.SpawnPlacementType.IN_AIR, false).build());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityAreaParticleCloud.class, PARTICLE_CLOUD, PARTICLE_CLOUD, EntityLiving.SpawnPlacementType.IN_AIR, false).build());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityThrowableItem.class, THROWABLE_ITEM, THROWABLE_ITEM, EntityLiving.SpawnPlacementType.IN_AIR, false).build());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityDraculaHalloween.class, SPECIAL_DRACULA_HALLOWEEN, null, EntityLiving.SpawnPlacementType.ON_GROUND, false).build());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityDarkBloodProjectile.class, DARK_BLOOD_PROJECTILE, null, EntityLiving.SpawnPlacementType.IN_AIR, false).build());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntitySoulOrb.class, SOUL_ORB, null, EntityLiving.SpawnPlacementType.ON_GROUND, false).build());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityHunterFactionVillager.class, VILLAGER_HUNTER_FACTION, null, EntityLiving.SpawnPlacementType.ON_GROUND, false).build());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityVampireFactionVillager.class, VILLAGER_VAMPIRE_FACTION, null, EntityLiving.SpawnPlacementType.ON_GROUND, false).build());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityHunterTrainerDummy.class, HUNTER_TRAINER_DUMMY, HUNTER_TRAINER_DUMMY, EntityLiving.SpawnPlacementType.ON_GROUND, false).build());
        registry.register((IForgeRegistryEntry)ModEntities.prepareEntityEntry(EntityConvertedHorse.class, HORSE_CONVERTED, null, EntityLiving.SpawnPlacementType.ON_GROUND, false).build());
    }

    static Biome[] getZombieBiomes() {
        List allBiomes = ForgeRegistries.BIOMES.getValues();
        ArrayList zombieBiomes = Lists.newArrayList();
        zombieBiomes.addAll(allBiomes);
        zombieBiomes.remove(Biomes.field_76789_p);
        zombieBiomes.remove(Biomes.field_76788_q);
        zombieBiomes.remove(Biomes.field_76778_j);
        zombieBiomes.remove(Biomes.field_76779_k);
        Iterator iterator = zombieBiomes.iterator();
        while (iterator.hasNext()) {
            Biome b = (Biome)iterator.next();
            if (b == null || b.func_150562_l().getName().startsWith("net.minecraft.") || b.func_150562_l().getName().startsWith("de.teamlapen.")) continue;
            Iterator iterator2 = b.func_76747_a(EnumCreatureType.MONSTER).iterator();
            boolean zombie = false;
            while (iterator2.hasNext()) {
                if (!((Biome.SpawnListEntry)iterator2.next()).field_76300_b.equals(EntityZombie.class)) continue;
                zombie = true;
                break;
            }
            if (zombie) continue;
            VampirismMod.log.d("ModEntities", "In biome %s no vampire will spawn", b);
            iterator.remove();
        }
        return zombieBiomes.toArray(new Biome[zombieBiomes.size()]);
    }

    public static IFixableData getEntityIDFixer() {
        return new IFixableData(){

            @Nonnull
            public NBTTagCompound func_188217_a(@Nonnull NBTTagCompound compound) {
                String s = (String)OLD_TO_NEW_MAP.get(compound.func_74779_i("id"));
                if (s != null) {
                    compound.func_74778_a("id", s);
                }
                return compound;
            }

            public int func_188216_a() {
                return 5;
            }
        };
    }

    public static IFixableData getPlayerCapabilityFixer() {
        return new IFixableData(){

            @Nonnull
            public NBTTagCompound func_188217_a(@Nonnull NBTTagCompound compound) {
                if (compound.func_74764_b("ForgeCaps")) {
                    NBTTagCompound vampire;
                    NBTTagCompound caps = compound.func_74775_l("ForgeCaps");
                    if (caps.func_74764_b("vampirism:IVampirePlayer")) {
                        vampire = caps.func_74775_l("vampirism:IVampirePlayer");
                        caps.func_74782_a(REFERENCE.VAMPIRE_PLAYER_KEY.toString(), (NBTBase)vampire);
                        caps.func_82580_o("vampirism:IVampirePlayer");
                    }
                    if (caps.func_74764_b("vampirism:IHunterPlayer")) {
                        vampire = compound.func_74775_l("vampirism:IHunterPlayer");
                        compound.func_74782_a(REFERENCE.HUNTER_PLAYER_KEY.toString(), (NBTBase)vampire);
                        compound.func_82580_o("vampirism:IHunterPlayer");
                    }
                    if (caps.func_74764_b("vampirism:IFactionPlayerHandler")) {
                        vampire = caps.func_74775_l("vampirism:IFactionPlayerHandler");
                        caps.func_74782_a(REFERENCE.FACTION_PLAYER_HANDLER_KEY.toString(), (NBTBase)vampire);
                        caps.func_82580_o("vampirism:IFactionPlayerHandler");
                    }
                }
                return compound;
            }

            public int func_188216_a() {
                return 1;
            }
        };
    }

    public static IFixableData getEntityCapabilityFixer() {
        return new IFixableData(){

            @Nonnull
            public NBTTagCompound func_188217_a(@Nonnull NBTTagCompound compound) {
                NBTTagCompound caps;
                if (compound.func_74764_b("ForgeCaps") && (caps = compound.func_74775_l("ForgeCaps")).func_74764_b("vampirism:IExtendedCreature")) {
                    NBTTagCompound vampire = caps.func_74775_l("vampirism:IExtendedCreature");
                    caps.func_74782_a(REFERENCE.EXTENDED_CREATURE_KEY.toString(), (NBTBase)vampire);
                    caps.func_82580_o("vampirism:IExtendedCreature");
                }
                return compound;
            }

            public int func_188216_a() {
                return 1;
            }
        };
    }

    private static <T extends Entity> EntityEntryBuilder<T> addSpawn(EntityEntryBuilder<T> builder, EnumCreatureType type, int weight, int min, int max, Biome ... biomes) {
        return builder.spawn(type, weight, min, max, biomes);
    }

    private static <T extends Entity> EntityEntryBuilder<T> prepareEntityEntry(Class<T> clazz, String id, @Nullable String oldName, EntityLiving.SpawnPlacementType placementType, boolean egg) {
        ResourceLocation n = new ResourceLocation("vampirism", id);
        if (oldName != null) {
            OLD_TO_NEW_MAP.put("vampirism." + oldName, n.toString());
        }
        EntityEntryBuilder builder = EntityEntryBuilder.create().entity(clazz).id(n, modEntityId++).name("vampirism." + id).tracker(80, 1, true);
        if (egg) {
            builder.egg(9115043, id.hashCode());
        }
        EntitySpawnPlacementRegistry.setPlacementType(clazz, (EntityLiving.SpawnPlacementType)placementType);
        return builder;
    }

    static void fixMapping(RegistryEvent.MissingMappings.Mapping<EntityEntry> m) {
        if (new ResourceLocation("vampirism", "hunter_villager").equals((Object)m.key)) {
            m.ignore();
        } else if (new ResourceLocation("vampirism", "converted_villager").equals((Object)m.key)) {
            m.ignore();
        }
    }
}

