/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.util.ParticleHandler;
import de.teamlapen.vampirism.client.render.particle.FlyingBloodEntityParticle;
import de.teamlapen.vampirism.client.render.particle.FlyingBloodParticle;
import de.teamlapen.vampirism.client.render.particle.GenericParticle;
import de.teamlapen.vampirism.client.render.particle.HalloweenParticle;
import de.teamlapen.vampirism.client.render.particle.HealingParticle;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleCloud;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModParticles {
    public static final ResourceLocation FLYING_BLOOD = new ResourceLocation("vampirism", "flying_blood");
    public static final ResourceLocation FLYING_BLOOD_ENTITY = new ResourceLocation("vampirism", "flying_blood_entity");
    public static final ResourceLocation HALLOWEEN = new ResourceLocation("vampirism", "halloween");
    public static final ResourceLocation HEAL = new ResourceLocation("vampirism", "heal");
    public static final ResourceLocation CLOUD = new ResourceLocation("vampirism", "cloud");
    public static final ResourceLocation GENERIC_PARTICLE = new ResourceLocation("vampirism", "generic");

    public static void init() {
        ParticleHandler.registerParticle(GENERIC_PARTICLE, new ParticleHandler.ICustomParticleFactory(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public Particle createParticle(World world, double posX, double posY, double posZ, Object ... param) {
                GenericParticle particle = new GenericParticle(world, posX, posY, posZ, (Integer)param[0], (Integer)param[1], (Integer)param[2]);
                if (param.length > 3) {
                    particle.scaleSpeed((Double)param[3]);
                }
                return particle;
            }

            @Override
            @Nonnull
            public NBTTagCompound createParticleInfo(Object ... param) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("0", ((Integer)param[0]).intValue());
                nbt.func_74768_a("1", ((Integer)param[1]).intValue());
                nbt.func_74768_a("2", ((Integer)param[2]).intValue());
                if (param.length > 3) {
                    nbt.func_74780_a("3", ((Double)param[3]).doubleValue());
                }
                return nbt;
            }

            @Override
            @Nonnull
            public Object[] readParticleInfo(NBTTagCompound nbt) {
                Object[] data = new Object[nbt.func_74764_b("3") ? 4 : 3];
                data[0] = nbt.func_74762_e("0");
                data[1] = nbt.func_74762_e("1");
                data[2] = nbt.func_74762_e("2");
                if (data.length > 3) {
                    data[3] = nbt.func_74769_h("3");
                }
                return data;
            }
        });
        ParticleHandler.registerParticle(FLYING_BLOOD, new ParticleHandler.ICustomParticleFactory(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public Particle createParticle(World world, double posX, double posY, double posZ, Object ... param) {
                if (param.length > 4) {
                    return new FlyingBloodParticle(world, posX, posY, posZ, (Double)param[0], (Double)param[1], (Double)param[2], (Integer)param[3], (Integer)param[4]);
                }
                return new FlyingBloodParticle(world, posX, posY, posZ, (Double)param[0], (Double)param[1], (Double)param[2], (Integer)param[3]);
            }

            @Override
            @Nonnull
            public NBTTagCompound createParticleInfo(Object ... param) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74780_a("0", ((Double)param[0]).doubleValue());
                nbt.func_74780_a("1", ((Double)param[1]).doubleValue());
                nbt.func_74780_a("2", ((Double)param[2]).doubleValue());
                nbt.func_74768_a("3", ((Integer)param[3]).intValue());
                if (param.length > 4) {
                    nbt.func_74768_a("4", ((Integer)param[4]).intValue());
                }
                return nbt;
            }

            @Override
            @Nonnull
            @SideOnly(value=Side.CLIENT)
            public Object[] readParticleInfo(NBTTagCompound nbt) {
                Object[] data = new Object[nbt.func_74764_b("4") ? 5 : 4];
                data[0] = nbt.func_74769_h("0");
                data[1] = nbt.func_74769_h("1");
                data[2] = nbt.func_74769_h("2");
                data[3] = nbt.func_74762_e("3");
                if (data.length > 4) {
                    data[4] = nbt.func_74762_e("4");
                }
                return data;
            }
        });
        ParticleHandler.registerParticle(FLYING_BLOOD_ENTITY, new ParticleHandler.ICustomParticleFactory(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public Particle createParticle(World world, double posX, double posY, double posZ, Object ... param) {
                return new FlyingBloodEntityParticle(world, posX, posY, posZ, (Entity)param[0], (Boolean)param[1]);
            }

            @Override
            @Nonnull
            public NBTTagCompound createParticleInfo(Object ... param) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("0", ((Entity)param[0]).func_145782_y());
                nbt.func_74757_a("1", ((Boolean)param[1]).booleanValue());
                return nbt;
            }

            @Override
            @Nonnull
            @SideOnly(value=Side.CLIENT)
            public Object[] readParticleInfo(NBTTagCompound nbt) {
                int i = nbt.func_74762_e("0");
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                if (world == null) {
                    return null;
                }
                Entity e = world.func_73045_a(i);
                if (e == null) {
                    return null;
                }
                Object[] data = new Object[]{e, nbt.func_74767_n("1")};
                return data;
            }
        });
        ParticleHandler.registerParticle(HALLOWEEN, new ParticleHandler.ICustomParticleFactory(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public Particle createParticle(World world, double posX, double posY, double posZ, Object ... param) {
                return new HalloweenParticle(world, posX, posY, posZ);
            }

            @Override
            @Nonnull
            public NBTTagCompound createParticleInfo(Object ... param) {
                return new NBTTagCompound();
            }

            @Override
            @Nonnull
            public Object[] readParticleInfo(NBTTagCompound nbt) {
                return new Object[0];
            }
        });
        ParticleHandler.registerParticle(HEAL, new ParticleHandler.ICustomParticleFactory(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public Object[] readParticleInfo(NBTTagCompound nbt) {
                return new Object[0];
            }

            @Override
            public NBTTagCompound createParticleInfo(Object ... param) {
                return new NBTTagCompound();
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public Particle createParticle(World world, double posX, double posY, double posZ, Object ... param) {
                return new HealingParticle(world, posX, posY, posZ);
            }
        });
        ParticleHandler.registerParticle(CLOUD, new ParticleHandler.ICustomParticleFactory(){

            @Override
            @SideOnly(value=Side.CLIENT)
            @Nonnull
            public Object[] readParticleInfo(NBTTagCompound nbt) {
                Object[] data = new Object[]{nbt.func_74769_h("0"), nbt.func_74769_h("1"), nbt.func_74769_h("2")};
                return data;
            }

            @Override
            @Nonnull
            public NBTTagCompound createParticleInfo(Object ... param) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74780_a("0", ((Double)param[0]).doubleValue());
                nbt.func_74780_a("1", ((Double)param[1]).doubleValue());
                nbt.func_74780_a("2", ((Double)param[2]).doubleValue());
                return nbt;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public Particle createParticle(World world, double posX, double posY, double posZ, Object ... param) {
                return new ParticleCloud.Factory().func_178902_a(EnumParticleTypes.CLOUD.func_179348_c(), world, posX, posY, posZ, ((Double)param[0]).doubleValue(), ((Double)param[1]).doubleValue(), ((Double)param[2]).doubleValue(), new int[0]);
            }
        });
    }
}

