/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.lib.util.VersionChecker;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.server.command.CommandTreeBase;
import net.minecraftforge.server.command.CommandTreeHelp;
import org.apache.commons.lang3.ArrayUtils;

public class VampirismCommand
extends BasicCommand {
    public VampirismCommand() {
        if (VampirismMod.inDev) {
            this.aliases.add("v");
        }
        final IPlayableFaction[] pfactions = VampirismAPI.factionRegistry().getPlayableFactions();
        final String[] pfaction_names = new String[pfactions.length];
        for (int i = 0; i < pfactions.length; ++i) {
            pfaction_names[i] = pfactions[i].name();
        }
        this.addSubcommand((ICommand)new SubCommand(3){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
                String cat = args == null || args.length == 0 ? "all" : args[0];
                if ("help".equals(cat)) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("You can reset Vampirism balance values to the default values. If you have not modified them, this is recommend after every update of Vampirism"));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Use '/vampirism resetBalance all' to reset all categories or specify a category with '/vampirism resetBalance <category>' (Tab completion is supported)"));
                    return;
                }
                boolean p = Balance.resetAndReload(cat);
                if (p) {
                    1.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.vampirism.base.reset_balance.success", (Object[])new Object[]{cat});
                } else {
                    1.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.vampirism.base.reset_balance.not_found", (Object[])new Object[]{cat});
                }
            }

            public String func_71517_b() {
                return "resetBalance";
            }

            public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
                return args.length == 1 ? 1.func_71530_a((String[])args, (String[])this.getCategories()) : Arrays.asList(this.getCategories());
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b() + " <all/[category]/help>";
            }

            private String[] getCategories() {
                Set<String> categories = Balance.getCategories().keySet();
                String[] result = categories.toArray(new String[categories.size() + 2]);
                result[result.length - 1] = "all";
                result[result.length - 2] = "help";
                return result;
            }
        });
        this.addSubcommand((ICommand)new SubCommand(2){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                int level;
                if (args.length < 2 || args.length > 3) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                EntityPlayerMP player = args.length == 3 ? 2.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[2]) : 2.func_71521_c((ICommandSender)sender);
                try {
                    level = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    throw new NumberInvalidException();
                }
                for (int i = 0; i < pfaction_names.length; ++i) {
                    if (!pfaction_names[i].equalsIgnoreCase(args[0])) continue;
                    IPlayableFaction newFaction = pfactions[i];
                    FactionPlayerHandler handler = FactionPlayerHandler.get((EntityPlayer)player);
                    if (level == 0 && !handler.canLeaveFaction()) {
                        throw new CommandException("command.vampirism.base.level.cant_leave", new Object[]{new TextComponentTranslation(handler.getCurrentFaction().getUnlocalizedName(), new Object[0])});
                    }
                    if (level > 14) {
                        level = 14;
                    }
                    if (!handler.setFactionAndLevel(newFaction, level)) {
                        throw new CommandException("commands.vampirism.failed_to_execute", new Object[0]);
                    }
                    ITextComponent msg = player.func_145748_c_().func_150257_a((ITextComponent)new TextComponentString(" is now a " + pfaction_names[i] + " level " + level));
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148539_a(msg);
                    return;
                }
                throw new CommandException("command.vampirism.base.level.faction_not_found", new Object[]{args[0]});
            }

            public String func_71517_b() {
                return "level";
            }

            public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
                return args.length == 1 ? 2.func_71530_a((String[])args, (String[])pfaction_names) : Arrays.asList(pfaction_names);
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b() + " " + ArrayUtils.toString((Object)pfaction_names) + " <level> [<player>]";
            }
        });
        this.addSubcommand((ICommand)new SubCommand(2){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                if (args.length > 1) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                EntityPlayerMP player = args.length == 1 ? 3.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]) : 3.func_71521_c((ICommandSender)sender);
                IFactionPlayerHandler handler = VampirismAPI.getFactionPlayerHandler((EntityPlayer)player);
                int currentLevel = handler.getCurrentLevel();
                if (currentLevel == 0) {
                    throw new CommandException("command.vampirism.base.levelup.nofaction", new Object[0]);
                }
                if (currentLevel == handler.getCurrentFaction().getHighestReachableLevel() || currentLevel == 14) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.vampirism.base.levelup.max", new Object[0]));
                } else if (handler.setFactionLevel(handler.getCurrentFaction(), currentLevel + 1)) {
                    ITextComponent msg = player.func_145748_c_().func_150257_a((ITextComponent)new TextComponentString(" is now a " + handler.getCurrentFaction().name() + " level " + (currentLevel + 1)));
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148539_a(msg);
                } else {
                    throw new CommandException("commands.vampirism.failed_to_execute", new Object[0]);
                }
            }

            public String func_71517_b() {
                return "levelup";
            }

            public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
                return args.length == 1 ? 3.func_71530_a((String[])args, (String[])server.func_71213_z()) : Collections.emptyList();
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b() + " [<player>]";
            }
        });
        this.addSubcommand((ICommand)new SubCommand(0){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayerMP player = 4.func_71521_c((ICommandSender)sender);
                if (args.length != 1) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                try {
                    int type = Integer.parseInt(args[0]);
                    if (!VampirePlayer.get((EntityPlayer)player).setEyeType(type)) {
                        throw new NumberInvalidException("command.vampirism.base.eye.types", new Object[]{15});
                    }
                    4.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.vampirism.base.eye.success", (Object[])new Object[]{type});
                }
                catch (NumberFormatException e) {
                    throw new NumberInvalidException();
                }
            }

            public String func_71517_b() {
                return "eye";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b() + " <id [0-" + 15 + "]> ";
            }
        });
        this.addSubcommand((ICommand)new SubCommand(0){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayerMP player = 5.func_71521_c((ICommandSender)sender);
                if (args.length != 1) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                try {
                    int type = Integer.parseInt(args[0]);
                    if (!VampirePlayer.get((EntityPlayer)player).setFangType(type)) {
                        throw new NumberInvalidException("command.vampirism.base.fang.types", new Object[]{6});
                    }
                    5.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.vampirism.base.fang.success", (Object[])new Object[]{type});
                }
                catch (NumberFormatException e) {
                    throw new NumberInvalidException();
                }
            }

            public String func_71517_b() {
                return "fang";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b() + " <id [0-" + 6 + "]> ";
            }
        });
        this.addSubcommand((ICommand)new SubCommand(0){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayerMP player = 6.func_71521_c((ICommandSender)sender);
                if (args.length != 1) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                String arg = args[0];
                if ("true".equals(arg) || "1".equals(arg)) {
                    VampirePlayer.get((EntityPlayer)player).setGlowingEyes(true);
                    6.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.vampirism.base.glowing_eyes.enabled", (Object[])new Object[]{true});
                } else if ("false".equals(arg) || "0".equals(arg)) {
                    VampirePlayer.get((EntityPlayer)player).setGlowingEyes(false);
                    6.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.vampirism.base.glowing_eyes.disabled", (Object[])new Object[]{false});
                } else {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
            }

            public String func_71517_b() {
                return "glowingEye";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b() + " true/false ";
            }
        });
        this.addSubcommand((ICommand)new SubCommand(3){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
                if (Configs.disable_vampireForest) {
                    7.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.vampirism.base.vampire_biome.disabled", (Object[])new Object[0]);
                } else {
                    int maxDist = 150;
                    if (args.length > 0) {
                        try {
                            maxDist = Integer.parseInt(args[0]);
                        }
                        catch (NumberFormatException e) {
                            VampirismMod.log.w("CheckVampireBiome", "Failed to parse max dist %s", args[0]);
                            7.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.vampirism.base.vampire_biome.parse_dist", (Object[])new Object[]{maxDist});
                        }
                        if (!(maxDist <= 500 || args.length > 1 && "yes".equals(args[1]))) {
                            7.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.vampirism.base.vampire_biome.time_warning", (Object[])new Object[]{this.func_71517_b(), maxDist});
                            return;
                        }
                    }
                    ArrayList<Biome> biomes = new ArrayList<Biome>();
                    biomes.add(ModBiomes.vampireForest);
                    7.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.vampirism.base.vampire_biome.searching", (Object[])new Object[0]);
                    ChunkPos pos = UtilLib.findNearBiome(sender.func_130014_f_(), sender.func_180425_c(), maxDist, biomes, sender);
                    if (pos == null) {
                        7.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.vampirism.base.vampire_biome.not_found", (Object[])new Object[0]);
                    } else {
                        7.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.vampirism.base.vampire_biome.found", (Object[])new Object[]{new TextComponentString("[" + pos.func_180334_c() + "," + pos.func_180333_d() + "]")});
                    }
                }
            }

            public String func_71517_b() {
                return "checkForVampireBiome";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b() + " <maxRadius in chunks>";
            }
        });
        this.addSubcommand((ICommand)new SubCommand(0){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
                if (!VampirismMod.instance.getVersionInfo().isNewVersionAvailable()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("There is no new version available"));
                    return;
                }
                VersionChecker.Version newVersion = VampirismMod.instance.getVersionInfo().getNewVersion();
                List<String> changes = newVersion.getChanges();
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Vampirism " + newVersion.name + "(" + "1.12.2" + ")"));
                for (String c : changes) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("-" + c));
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                String template = UtilLib.translate("text.vampirism.update_message");
                String homepage = VampirismMod.instance.getVersionInfo().getHomePage();
                template = template.replaceAll("@download@", newVersion.getUrl() == null ? homepage : newVersion.getUrl()).replaceAll("@forum@", homepage);
                ITextComponent component = ITextComponent.Serializer.func_150699_a((String)template);
                sender.func_145747_a(component);
            }

            public String func_71517_b() {
                return "changelog";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }
        });
        this.addSubcommand((ICommand)new SubCommand(0){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
                if (sender instanceof EntityPlayer) {
                    EntityPlayer p = (EntityPlayer)sender;
                    sender.func_145747_a((ITextComponent)new TextComponentString("Dimension ID: " + p.func_130014_f_().field_73011_w.getDimension()));
                }
            }

            public String func_71517_b() {
                return "currentDimension";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }
        });
        this.addSubcommand((ICommand)new SubCommand(3){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                boolean enabled = VampirismMod.log.isDebug();
                VampirismMod.log.setDebug(!enabled);
                String msg = enabled ? "command.vampirism.base.debug.true" : "command.vampirism.base.debug.false";
                10.func_152373_a((ICommandSender)sender, (ICommand)this, (String)msg, (Object[])new Object[0]);
            }

            public String func_71517_b() {
                return "debug";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }
        });
        this.addSubcommand((ICommand)new SubCommand(0){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayerMP player = 11.func_71521_c((ICommandSender)sender);
                if (args.length == 2) {
                    ResourceLocation id = new ResourceLocation(args[1]);
                    if ("null".equals(args[1])) {
                        id = null;
                    }
                    if (id == null || VampirismAPI.actionManager().getRegistry().containsKey(id)) {
                        if ("1".equals(args[0])) {
                            FactionPlayerHandler.get((EntityPlayer)player).setBoundAction1(id, true);
                        } else if ("2".equals(args[0])) {
                            FactionPlayerHandler.get((EntityPlayer)player).setBoundAction2(id, true);
                        } else {
                            throw new WrongUsageException("Valid keys: 1 or 2", new Object[0]);
                        }
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.vampirism.base.bind_action.success", new Object[]{args[1], args[0]}));
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.vampirism.base.bind_action.not_existing", new Object[]{args[1]}));
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.vampirism.base.bind_action.help", new Object[0]));
                    sender.func_145747_a((ITextComponent)new TextComponentString("/vampirism " + this.func_71518_a(sender)));
                }
            }

            public String func_71517_b() {
                return "bind-action";
            }

            public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
                if (args.length == 1) {
                    return 11.func_71530_a((String[])args, (String[])new String[]{"1", "2"});
                }
                if (args.length == 2) {
                    return 11.func_175762_a((String[])args, (Collection)VampirismAPI.actionManager().getRegistry().getKeys());
                }
                return Collections.emptyList();
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b() + " <1/2>  <action-id>";
            }
        });
        this.addSubcommand((ICommand)new SubCommand(0){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                sender.func_145747_a((ITextComponent)new TextComponentString("Vampirism: 1.6.0"));
            }

            public String func_71517_b() {
                return "version";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }
        });
        this.addSubcommand((ICommand)new CommandTreeHelp((CommandTreeBase)this));
    }

    public String func_71517_b() {
        return "vampirism";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/vampirism <sub>";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public int func_82362_a() {
        return 0;
    }

    public static abstract class SubCommand
    extends CommandBase {
        private final int perm;

        private SubCommand(int perm) {
            this.perm = perm;
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return this.perm == 0 || sender.func_70003_b(this.func_82362_a(), "vampirism." + this.func_71517_b());
        }

        public int func_82362_a() {
            return this.perm;
        }
    }
}

