/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.lib.VampLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.IEntityWithHome;
import de.teamlapen.vampirism.api.entity.IVampirismEntity;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IEntityAction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.action.EntityActionHandler;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public abstract class EntityVampirism
extends EntityCreature
implements IEntityWithHome,
IVampirismEntity {
    private final EntityAIBase moveTowardsRestriction;
    protected boolean hasArms = true;
    protected boolean peaceful = false;
    @Nullable
    protected EntityActionHandler<?> entityActionHandler;
    @Nullable
    protected EntityClassType entityclass;
    @Nullable
    protected EntityActionTier entitytier;
    protected boolean saveHome = false;
    private AxisAlignedBB home;
    private boolean moveTowardsRestrictionAdded = false;
    private int moveTowardsRestrictionPrio = -1;
    private int randomTickDivider;

    public EntityVampirism(World world) {
        super(world);
        this.setupEntityClass();
        this.moveTowardsRestriction = new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0);
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entity instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entity).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entity.func_70015_d(j * 4);
            }
            this.func_174815_a((EntityLivingBase)this, entity);
            if (entity instanceof EntityLivingBase) {
                this.attackedEntityAsMob((EntityLivingBase)entity);
            }
        }
        return flag;
    }

    @Nullable
    public EntityActionHandler getActionHandler() {
        return this.entityActionHandler;
    }

    public void func_110177_bN() {
        this.home = null;
    }

    public boolean func_70601_bi() {
        return (this.peaceful || this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) && super.func_70601_bi();
    }

    @Override
    @Nullable
    public AxisAlignedBB getHome() {
        return this.home;
    }

    @Override
    public void setHome(@Nullable AxisAlignedBB home) {
        this.home = home;
    }

    public BlockPos func_180486_cf() {
        if (!this.func_110175_bO()) {
            return new BlockPos(0, 0, 0);
        }
        int posX = (int)(this.home.field_72340_a + (this.home.field_72336_d - this.home.field_72340_a) / 2.0);
        int posY = (int)(this.home.field_72338_b + (this.home.field_72337_e - this.home.field_72338_b) / 2.0);
        int posZ = (int)(this.home.field_72339_c + (this.home.field_72334_f - this.home.field_72339_c) / 2.0);
        return new BlockPos(posX, posY, posZ);
    }

    public boolean func_110175_bO() {
        return this.home != null;
    }

    @Override
    public boolean isWithinHomeDistance(double x, double y, double z) {
        if (this.home != null) {
            return this.home.func_72318_a(new Vec3d(x, y, z));
        }
        return true;
    }

    public boolean func_110173_bK() {
        return this.isWithinHomeDistance(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public boolean func_180485_d(BlockPos pos) {
        return this.isWithinHomeDistance(pos);
    }

    public void func_70636_d() {
        if (this.hasArms) {
            this.func_82168_bl();
        }
        super.func_70636_d();
        if (this.entityActionHandler != null) {
            this.entityActionHandler.handle();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !this.peaceful && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        EntityClassType type;
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("home")) {
            this.saveHome = true;
            int[] h = nbt.func_74759_k("home");
            this.home = new AxisAlignedBB((double)h[0], (double)h[1], (double)h[2], (double)h[3], (double)h[4], (double)h[5]);
            if (nbt.func_74764_b("homeMovePrio")) {
                this.setMoveTowardsRestriction(nbt.func_74762_e("moveHomePrio"), true);
            }
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.readFromNBT(nbt);
        }
        if (nbt.func_74764_b("entityclasstype") && (type = EntityClassType.getEntityClassType(nbt.func_74762_e("entityclasstype"))) != null) {
            this.entityclass = type;
        }
    }

    @Override
    public void setHomeArea(BlockPos pos, int r) {
        this.setHome(new AxisAlignedBB(pos.func_177982_a(-r, -r, -r), pos.func_177982_a(r, r, r)));
    }

    public void func_175449_a(BlockPos pos, int distance) {
        this.setHomeArea(pos, distance);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.saveHome && this.func_110175_bO()) {
            int[] h = new int[]{(int)this.home.field_72340_a, (int)this.home.field_72338_b, (int)this.home.field_72339_c, (int)this.home.field_72336_d, (int)this.home.field_72337_e, (int)this.home.field_72334_f};
            nbt.func_74783_a("home", h);
            if (this.moveTowardsRestrictionAdded && this.moveTowardsRestrictionPrio > -1) {
                nbt.func_74768_a("homeMovePrio", this.moveTowardsRestrictionPrio);
            }
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.writeToNBT(nbt);
        }
        nbt.func_74768_a("entityclasstype", EntityClassType.getID(this.entityclass));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    protected void attackedEntityAsMob(EntityLivingBase entity) {
    }

    protected boolean func_146066_aG() {
        return true;
    }

    protected void disableMoveTowardsRestriction() {
        if (this.moveTowardsRestrictionAdded) {
            this.field_70714_bg.func_85156_a(this.moveTowardsRestriction);
            this.moveTowardsRestrictionAdded = false;
        }
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187738_cy;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return heightIn > 4 ? SoundEvents.field_187735_cx : SoundEvents.field_187589_cA;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187741_cz;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected boolean isLowLightLevel() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int i = this.field_70170_p.func_175671_l(blockpos);
        if (this.field_70170_p.func_72911_I()) {
            int j = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            i = this.field_70170_p.func_175671_l(blockpos);
            this.field_70170_p.func_175692_b(j);
        }
        return i <= this.field_70146_Z.nextInt(8);
    }

    protected void onRandomTick() {
    }

    protected void setDontDropEquipment() {
        for (int i = 0; i < this.field_184655_bs.length; ++i) {
            this.field_184655_bs[i] = 0.0f;
        }
        for (int j = 0; j < this.field_82174_bp.length; ++j) {
            this.field_82174_bp[j] = 0.0f;
        }
    }

    protected void setMoveTowardsRestriction(int prio, boolean active) {
        if (this.moveTowardsRestrictionAdded) {
            if (active && this.moveTowardsRestrictionPrio == prio) {
                return;
            }
            this.field_70714_bg.func_85156_a(this.moveTowardsRestriction);
            this.moveTowardsRestrictionAdded = false;
        }
        if (active) {
            this.field_70714_bg.func_75776_a(prio, this.moveTowardsRestriction);
            this.moveTowardsRestrictionAdded = true;
            this.moveTowardsRestrictionPrio = prio;
        }
    }

    protected void teleportAway() {
        this.func_82142_c(true);
        VampLib.proxy.getParticleHandler().spawnParticles(this.field_70170_p, ModParticles.GENERIC_PARTICLE, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, 20, 1.0, this.field_70146_Z, 134, 10, 657930, 0.6);
        this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        this.func_70106_y();
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (--this.randomTickDivider <= 0) {
            this.randomTickDivider = 70 + this.field_70146_Z.nextInt(50);
            this.onRandomTick();
        }
    }

    public List<IEntityAction> getAvailableActions() {
        return VampirismAPI.entityActionManager().getAllEntityActionsByTierAndClassType(((IFactionEntity)((Object)this)).getFaction(), this.entitytier, this.entityclass);
    }

    @Nullable
    public EntityClassType getEntityClass() {
        return this.entityclass;
    }

    @Nullable
    public EntityActionTier getEntityTier() {
        return this.entitytier;
    }

    protected void setupEntityClass() {
        this.entitytier = EntityActionTier.Default;
        this.entityclass = EntityClassType.getRandomClass(this.func_70681_au());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(this.entityclass.getHealthModifier());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(this.entityclass.getDamageModifier());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.entityclass.getSpeedModifier());
    }
}

