/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.BiteableEntry;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.Configs;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;

public class BiteableEntryManager {
    private static final String TAG = "BiteableEntryManager";
    private final Map<ResourceLocation, BiteableEntry> hardcoded;
    private final Map<ResourceLocation, BiteableEntry> dynamic = Maps.newHashMap();
    private final Set<ResourceLocation> blacklist = Sets.newHashSet();
    private boolean init;

    public BiteableEntryManager(Map<ResourceLocation, BiteableEntry> hardcoded, Set<ResourceLocation> blacklist) {
        this.hardcoded = ImmutableMap.copyOf(hardcoded);
        this.blacklist.addAll(blacklist);
        this.init = false;
    }

    public BiteableEntry addDynamic(ResourceLocation id, int blood) {
        BiteableEntry existing = this.dynamic.get(id);
        existing = existing != null ? existing.modifyBloodValue(blood) : new BiteableEntry(blood);
        this.dynamic.put(id, existing);
        return existing;
    }

    public void addDynamic(Map<ResourceLocation, Integer> map) {
        for (Map.Entry<ResourceLocation, Integer> e : map.entrySet()) {
            this.addDynamic(e.getKey(), e.getValue());
        }
    }

    @Nullable
    public BiteableEntry calculate(EntityCreature creature) {
        ResourceLocation id = EntityList.func_191301_a((Entity)creature);
        if (this.blacklist.contains(id)) {
            return null;
        }
        BiteableEntry entry = this.get(id);
        if (entry != null) {
            return entry;
        }
        if (!Configs.autoCalculateEntityBlood || !(creature instanceof EntityAnimal) || creature instanceof IVampire) {
            this.blacklist.add(id);
            return null;
        }
        AxisAlignedBB bb = creature.func_174813_aQ();
        double v = bb.field_72336_d - bb.field_72340_a;
        v *= bb.field_72337_e - bb.field_72338_b;
        v *= bb.field_72334_f - bb.field_72339_c;
        if (creature.func_70631_g_()) {
            v *= 8.0;
        }
        int blood = 0;
        if (v >= 0.3) {
            blood = (int)(v * 10.0);
            blood = Math.min(15, blood);
        }
        if (creature.func_110138_aP() > 50.0f) {
            blood = 0;
        }
        VampirismMod.log.d(TAG, "Calculated size %s and blood value %s for entity %s", Float.valueOf((float)Math.round(v * 100.0) / 100.0f), blood, id);
        if (blood == 0) {
            this.blacklist.add(id);
            return null;
        }
        return this.addDynamic(id, blood);
    }

    @Nullable
    public BiteableEntry get(ResourceLocation id) {
        return this.init ? this.dynamic.get(id) : this.hardcoded.get(id);
    }

    public Map<ResourceLocation, Integer> getDynamicAll() {
        HashMap map = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, BiteableEntry> entry : this.dynamic.entrySet()) {
            map.put(entry.getKey(), entry.getValue().blood);
        }
        return map;
    }

    public Map<ResourceLocation, Integer> getValuesToSave() {
        HashMap map = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, BiteableEntry> entry : this.dynamic.entrySet()) {
            if (this.hardcoded.containsKey(entry.getKey())) continue;
            map.put(entry.getKey(), entry.getValue().blood);
        }
        return map;
    }

    public void initDynamic() {
        this.dynamic.clear();
        this.dynamic.putAll(this.hardcoded);
        this.init = true;
    }

    public void resetDynamic() {
        this.init = false;
        this.dynamic.clear();
    }
}

