/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.entity.factions.Faction;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;

public class PlayableFaction<T extends IFactionPlayer>
extends Faction<T>
implements IPlayableFaction<T> {
    private final int highestLevel;
    private final Capability<T> playerCapability;
    private final ResourceLocation key;
    private boolean renderLevel = true;

    PlayableFaction(String name, Class<T> entityInterface, int color, ResourceLocation key, Capability<T> playerCapability, int highestLevel) {
        super(name, entityInterface, color);
        this.highestLevel = highestLevel;
        this.playerCapability = playerCapability;
        this.key = key;
    }

    @Override
    public Class<T> getFactionPlayerInterface() {
        return this.entityInterface;
    }

    @Override
    public int getHighestReachableLevel() {
        return this.highestLevel;
    }

    @Override
    public ResourceLocation getKey() {
        return this.key;
    }

    @Override
    public T getPlayerCapability(EntityPlayer player) {
        return (T)((IFactionPlayer)player.getCapability(this.playerCapability, null));
    }

    @Override
    public boolean renderLevel() {
        return this.renderLevel;
    }

    @Override
    public PlayableFaction<T> setRenderLevel(boolean render) {
        this.renderLevel = render;
        return this;
    }

    @Override
    public String toString() {
        return "PlayableFaction{playerCapability='" + this.playerCapability + '\'' + "name='" + this.name + '\'' + '}';
    }
}

