/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.EntityFactionVillager;
import de.teamlapen.vampirism.entity.ai.VampireAIFleeSun;
import de.teamlapen.vampirism.entity.ai.VampireAIRestrictSun;
import de.teamlapen.vampirism.util.Helper;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class EntityVampireFactionVillagerBase
extends EntityFactionVillager
implements IVampire {
    protected EnumStrength garlicResist = EnumStrength.NONE;
    private boolean sundamageCache;
    private EnumStrength garlicCache = EnumStrength.NONE;

    public EntityVampireFactionVillagerBase(World worldIn) {
        super(worldIn);
    }

    public EntityVampireFactionVillagerBase(World worldIn, int professionId) {
        super(worldIn, professionId);
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return !strength.isStrongerThan(this.garlicResist);
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, amt * 20));
    }

    @Override
    @Nonnull
    public EnumStrength isGettingGarlicDamage(boolean forcerefresh) {
        if (forcerefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this);
        }
        return this.garlicCache;
    }

    @Override
    public boolean isGettingSundamage(boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((EntityLivingBase)this);
        return this.sundamageCache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return this.func_70644_a(ModPotions.sunscreen);
    }

    @Override
    public void func_70636_d() {
        if (this.field_70173_aa % 40 == 3) {
            this.isGettingGarlicDamage(true);
        }
        if (this.field_70173_aa % 8 == 2) {
            this.isGettingSundamage(true);
        }
        if (!this.field_70170_p.field_72995_K) {
            double dmg;
            if (this.isGettingSundamage() && this.field_70173_aa % 40 == 11 && (dmg = this.func_110148_a(VReference.sunDamage).func_111126_e()) > 0.0) {
                this.func_70097_a(VReference.SUNDAMAGE, (float)dmg);
            }
            if (this.isGettingGarlicDamage() != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage(), this.field_70173_aa);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70090_H()) {
            this.func_70050_g(300);
            if (this.field_70173_aa % 16 == 4) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 80, 0));
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, amt * 20));
        return true;
    }

    @Override
    public boolean wantsBlood() {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(VReference.sunDamage).func_111128_a(Balance.mobProps.VAMPIRE_MOB_SUN_DAMAGE);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new VampireAIRestrictSun<EntityVampireFactionVillagerBase>(this));
        this.field_70714_bg.func_75776_a(1, new VampireAIFleeSun<EntityVampireFactionVillagerBase>(this, 0.9, false));
        super.func_184651_r();
    }
}

