/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IItemWithTierNBTImpl
extends IItemWithTier {
    public static IItemWithTier.TIER getTierStatic(@Nonnull ItemStack stack) {
        NBTTagCompound tag = UtilLib.checkNBT(stack);
        if (tag.func_74764_b("tier")) {
            try {
                return IItemWithTier.TIER.valueOf(tag.func_74779_i("tier"));
            }
            catch (IllegalArgumentException e) {
                VampirismMod.log.e(stack.func_77973_b().getRegistryName().toString(), e, "Unknown item tier %s", tag.func_74779_i("tier"));
            }
        }
        return IItemWithTier.TIER.NORMAL;
    }

    @Nonnull
    public static ItemStack setTierStatic(@Nonnull ItemStack stack, IItemWithTier.TIER tier) {
        NBTTagCompound tag = UtilLib.checkNBT(stack);
        tag.func_74778_a("tier", tier.name());
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    default public void addTierInformation(ItemStack stack, List<String> tooltip) {
        IItemWithTier.TIER t = this.getTier(stack);
        if (t != IItemWithTier.TIER.NORMAL) {
            tooltip.add(TextFormatting.AQUA + UtilLib.translate("text.vampirism.item_tier." + t.name().toLowerCase()));
        }
    }

    @Override
    default public IItemWithTier.TIER getTier(@Nonnull ItemStack stack) {
        return IItemWithTierNBTImpl.getTierStatic(stack);
    }

    @Override
    @Nonnull
    default public ItemStack setTier(@Nonnull ItemStack stack, IItemWithTier.TIER tier) {
        return IItemWithTierNBTImpl.setTierStatic(stack, tier);
    }
}

