/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.items.IItemWithTierNBTImpl;
import de.teamlapen.vampirism.items.VampirismVampireSword;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHeartStriker
extends VampirismVampireSword
implements IItemWithTierNBTImpl {
    public static final String regName = "heart_striker";
    private static final float[] DAMAGE_TIER = new float[]{6.0f, 7.0f, 9.0f};
    private static final float[] SPEED_TIER = new float[]{0.35f, 0.45f, 0.55f};

    public ItemHeartStriker() {
        super(regName, Item.ToolMaterial.IRON, 0.0f, 0.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        this.addTierInformation(stack, tooltip);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (IItemWithTier.TIER t : IItemWithTier.TIER.values()) {
                items.add((Object)this.setTier(new ItemStack((Item)this), t));
            }
        }
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (target.func_110143_aJ() <= 0.0f && Helper.isVampire((Entity)attacker)) {
            float trained = this.getTrained(stack, attacker);
            int exp = target instanceof EntityPlayer ? 10 : (attacker instanceof EntityPlayer ? Helper.getExperiencePoints(target, (EntityPlayer)attacker) : 5);
            trained += (float)exp / 5.0f * (1.0f - trained) / 15.0f;
            this.setTrained(stack, attacker, trained);
        }
        float charged = this.getCharged(stack);
        charged = (float)((double)charged - Balance.general.HEART_SEEKER_USAGE_FACTOR * (double)(this.getTier(stack).ordinal() + 2) / 2.0);
        this.setCharged(stack, charged);
        attacker.func_184611_a(EnumHand.MAIN_HAND, stack);
        return super.func_77644_a(stack, target, attacker);
    }

    @Override
    protected float getBaseAttackDamage(ItemStack stack) {
        return DAMAGE_TIER[this.getTier(stack).ordinal()];
    }

    @Override
    protected float getBaseAttackSpeed(ItemStack stack) {
        return SPEED_TIER[this.getTier(stack).ordinal()];
    }

    @Override
    protected float getChargingFactor(ItemStack stack) {
        return (float)Balance.general.HEART_SEEKER_CHARGING_FACTOR * 2.0f / (float)(this.getTier(stack).ordinal() + 2);
    }
}

